/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util.builder;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javafx.concurrent.Task;
import org.apache.commons.lang3.function.FailableFunction;

public class BackgroundTaskBuilder<T> {
    private Callable<T> callableTask;
    private FailableFunction<Task<T>, T, ? extends Exception> functionalTask;
    private Runnable postGuiCall;
    private Consumer<Task<T>> onCancelled;
    private Consumer<Task<T>> onFailed;
    private Consumer<Task<T>> onRunning;
    private Consumer<Task<T>> onScheduled;
    private Consumer<T> onSucceeded;

    private BackgroundTaskBuilder(Callable<T> callableTask) {
        this.callableTask = callableTask;
    }

    private BackgroundTaskBuilder(FailableFunction<Task<T>, T, ? extends Exception> functionalTask) {
        this.functionalTask = functionalTask;
    }

    public static <T> BackgroundTaskBuilder<T> task(Callable<T> callableTask) {
        return new BackgroundTaskBuilder<T>(callableTask);
    }

    public static <T> BackgroundTaskBuilder<T> task(FailableFunction<Task<T>, T, ? extends Exception> functionalTask) {
        return new BackgroundTaskBuilder<T>(functionalTask);
    }

    public void start() {
        Task<T> task = this.build();
        Thread thread = new Thread((Runnable)task);
        thread.start();
    }

    public Task<T> build() {
        Task task = new Task<T>(){

            protected T call() throws Exception {
                if (BackgroundTaskBuilder.this.callableTask != null) {
                    return BackgroundTaskBuilder.this.callableTask.call();
                }
                if (BackgroundTaskBuilder.this.functionalTask != null) {
                    return BackgroundTaskBuilder.this.functionalTask.apply((Object)this);
                }
                return null;
            }
        };
        this.setOnCancelled(task);
        this.setOnFailed(task);
        this.setOnRunning(task);
        this.setOnScheduled(task);
        this.setOnSucceeded(task);
        return task;
    }

    private void setOnCancelled(Task<T> task) {
        task.setOnCancelled(evt -> {
            if (this.onCancelled != null) {
                this.onCancelled.accept(task);
            }
            if (this.postGuiCall != null) {
                this.postGuiCall.run();
            }
        });
    }

    private void setOnFailed(Task<T> task) {
        task.setOnFailed(evt -> {
            if (this.onFailed != null) {
                this.onFailed.accept(task);
            }
            if (this.postGuiCall != null) {
                this.postGuiCall.run();
            }
        });
    }

    private void setOnRunning(Task<T> task) {
        task.setOnRunning(evt -> {
            if (this.onRunning != null) {
                this.onRunning.accept(task);
            }
        });
    }

    private void setOnScheduled(Task<T> task) {
        task.setOnScheduled(evt -> {
            if (this.onScheduled != null) {
                this.onScheduled.accept(task);
            }
        });
    }

    private void setOnSucceeded(Task<T> task) {
        task.setOnSucceeded(evt -> {
            if (this.onSucceeded != null) {
                this.onSucceeded.accept(task.getValue());
            }
            if (this.postGuiCall != null) {
                this.postGuiCall.run();
            }
        });
    }

    public BackgroundTaskBuilder<T> postGuiCall(Runnable postGuiCall) {
        this.postGuiCall = postGuiCall;
        return this;
    }

    public BackgroundTaskBuilder<T> onCancelled(Consumer<Task<T>> onCancelled) {
        this.onCancelled = onCancelled;
        return this;
    }

    public BackgroundTaskBuilder<T> onFailed(Consumer<Task<T>> onFailed) {
        this.onFailed = onFailed;
        return this;
    }

    public BackgroundTaskBuilder<T> onRunning(Consumer<Task<T>> onRunning) {
        this.onRunning = onRunning;
        return this;
    }

    public BackgroundTaskBuilder<T> onScheduled(Consumer<Task<T>> onScheduled) {
        this.onScheduled = onScheduled;
        return this;
    }

    public BackgroundTaskBuilder<T> onSucceeded(Consumer<T> onSucceeded) {
        this.onSucceeded = onSucceeded;
        return this;
    }
}

