/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util.constraint;

import cz.masci.springfx.mvci.util.constraint.ConditionUtils;
import io.github.palexdev.materialfx.validation.Constraint;
import io.github.palexdev.materialfx.validation.Severity;
import io.github.palexdev.materialfx.validation.Validated;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.beans.binding.NumberExpression;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;

public final class ConstraintUtils {
    private static final String FIELD_IS_REQUIRED = "FIELD_IS_REQUIRED";
    private static final String FIELD_IN_RANGE = "FIELD_IN_RANGE";
    private static final String FIELD_IS_NUMBER = "FIELD_IS_NUMBER";
    private static Locale locale = Locale.getDefault();

    private static String getMessage(String type, Object ... args) {
        ResourceBundle bundle = ResourceBundle.getBundle("constraint_messages", locale);
        return String.format(bundle.getString(type), args);
    }

    public static void setLocale(Locale locale) {
        ConstraintUtils.locale = locale;
    }

    public static Constraint isNotEmpty(StringProperty stringProperty, String fieldName) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(ConstraintUtils.getMessage(FIELD_IS_REQUIRED, fieldName)).setCondition(ConditionUtils.isNotEmpty((ObservableStringValue)stringProperty)).get();
    }

    public static Constraint isInRange(IntegerProperty integerProperty, String fieldName, int min, int max) {
        Objects.requireNonNull(integerProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(ConstraintUtils.getMessage(FIELD_IN_RANGE, fieldName, min, max)).setCondition(ConditionUtils.isInRange((NumberExpression)integerProperty, min, max)).get();
    }

    public static Constraint isNumber(StringProperty stringProperty, String fieldName) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(ConstraintUtils.getMessage(FIELD_IS_NUMBER, fieldName)).setCondition(ConditionUtils.isNumber((ObservableStringValue)stringProperty)).get();
    }

    public static Constraint isNumberOrEmpty(StringProperty stringProperty, String fieldName) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(ConstraintUtils.getMessage(FIELD_IS_NUMBER, fieldName)).setCondition(ConditionUtils.isNumberOrEmpty((ObservableStringValue)stringProperty)).get();
    }

    public static <T> Constraint isNotEmptyWhenPropertyIsNotEmpty(StringProperty stringProperty, Property<T> nullableProperty, String fieldName) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(ConstraintUtils.getMessage(FIELD_IS_REQUIRED, fieldName)).setCondition(ConditionUtils.isNotBlankWhenPropertyIsNotEmpty((ObservableStringValue)stringProperty, nullableProperty)).get();
    }

    public static <T> Constraint isNumberWhenPropertyIsNotEmpty(StringProperty stringProperty, Property<T> nullableProperty, String fieldName) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(ConstraintUtils.getMessage(FIELD_IS_NUMBER, fieldName)).setCondition(ConditionUtils.isNumberWhenPropertyIsNotEmpty((ObservableStringValue)stringProperty, nullableProperty)).get();
    }

    public static <T> Constraint isNumberOrEmptyWhenPropertyIsNotEmpty(StringProperty stringProperty, Property<T> nullableProperty, String fieldName) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(ConstraintUtils.getMessage(FIELD_IS_NUMBER, fieldName)).setCondition(ConditionUtils.isNumberOrBlankWhenPropertyIsNotEmpty((ObservableStringValue)stringProperty, nullableProperty)).get();
    }

    public static <T, U extends Validated> Constraint isValid(String fieldName, ObservableValue<T> parent, Function<T, ObservableValue<U>> childMap) {
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(fieldName).setCondition(ConditionUtils.isValid(parent, childMap)).get();
    }

    private ConstraintUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

