/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.view.builder;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import org.apache.commons.lang3.StringUtils;

public class ButtonBuilder {
    private Consumer<Runnable> appThreadCommand;
    private Runnable fxThreadCommand;
    BooleanExpression disableExpression;
    private String text;
    private String styleClass;

    protected ButtonBuilder() {
    }

    public static ButtonBuilder builder() {
        return new ButtonBuilder();
    }

    public ButtonBuilder command(Consumer<Runnable> appThreadCommand) {
        this.appThreadCommand = appThreadCommand;
        this.fxThreadCommand = null;
        return this;
    }

    public ButtonBuilder command(Runnable fxThreadCommand) {
        this.fxThreadCommand = fxThreadCommand;
        this.appThreadCommand = null;
        return this;
    }

    public ButtonBuilder disableExpression(BooleanExpression disableExpression) {
        this.disableExpression = disableExpression;
        return this;
    }

    public ButtonBuilder text(String text) {
        this.text = text;
        return this;
    }

    public ButtonBuilder styleClass(String styleClass) {
        this.styleClass = styleClass;
        return this;
    }

    public <T extends Button> T build(Supplier<T> buttonSupplier) {
        Button button = (Button)buttonSupplier.get();
        button.setText(this.text);
        if (StringUtils.isNotBlank((CharSequence)this.styleClass)) {
            button.getStyleClass().add((Object)this.styleClass);
        }
        SimpleBooleanProperty internalDisableProperty = new SimpleBooleanProperty(false);
        button.disableProperty().bind((ObservableValue)(this.disableExpression != null ? Bindings.or((ObservableBooleanValue)this.disableExpression, (ObservableBooleanValue)internalDisableProperty) : internalDisableProperty));
        if (this.appThreadCommand != null) {
            button.setOnAction(arg_0 -> this.lambda$build$1((BooleanProperty)internalDisableProperty, arg_0));
        }
        if (this.fxThreadCommand != null) {
            button.setOnAction(arg_0 -> this.lambda$build$2((BooleanProperty)internalDisableProperty, arg_0));
        }
        return (T)button;
    }

    private /* synthetic */ void lambda$build$2(BooleanProperty internalDisableProperty, ActionEvent evt) {
        internalDisableProperty.set(true);
        this.fxThreadCommand.run();
        internalDisableProperty.set(false);
    }

    private /* synthetic */ void lambda$build$1(BooleanProperty internalDisableProperty, ActionEvent evt) {
        internalDisableProperty.set(true);
        this.appThreadCommand.accept(() -> internalDisableProperty.set(false));
    }
}

