/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.commons.springfx.controller;

import cz.masci.commons.springfx.controller.AbstractDetailController;
import cz.masci.commons.springfx.data.Modifiable;
import cz.masci.commons.springfx.exception.CrudException;
import cz.masci.commons.springfx.service.CrudService;
import cz.masci.commons.springfx.service.EditDialogControllerService;
import cz.masci.commons.springfx.utility.StyleChangingRowFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxWeaver;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxmlView(value="fxml/master-view.fxml")
public abstract class AbstractMasterController<T extends Modifiable> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMasterController.class);
    private final FxWeaver fxWeaver;
    private final CrudService<T> itemService;
    private final Class<? extends EditDialogControllerService<T>> editControllerClass;
    private final ObservableList<T> changedItemList;
    @FXML
    protected BorderPane borderPane;
    @FXML
    protected TableView<T> tableView;
    @FXML
    protected VBox items;

    public AbstractMasterController(FxWeaver fxWeaver, CrudService<T> itemService, Class<? extends EditDialogControllerService<T>> editControllerClass) {
        this.fxWeaver = fxWeaver;
        this.itemService = itemService;
        this.editControllerClass = editControllerClass;
        this.changedItemList = FXCollections.observableArrayList();
    }

    @FXML
    public void onNewItem(ActionEvent event) {
        log.debug("New item action occurred");
        FxControllerAndView editor = this.fxWeaver.load(this.editControllerClass);
        Dialog dialog = new Dialog();
        dialog.setTitle("New Item");
        editor.getView().ifPresent(arg_0 -> ((Dialog)dialog).setDialogPane(arg_0));
        dialog.setResultConverter(((EditDialogControllerService)editor.getController()).getResultConverter());
        Optional result = dialog.showAndWait();
        result.ifPresent(item -> {
            try {
                log.debug("Saving new item: " + item);
                Modifiable savedItem = this.itemService.save(item);
                this.tableView.getItems().add((Object)savedItem);
                this.tableView.getSelectionModel().select((Object)savedItem);
                this.tableView.scrollTo((Object)savedItem);
            }
            catch (CrudException ex) {
                log.error(ex.getMessage());
            }
        });
        if (result.isEmpty()) {
            log.debug("Dialog result is empty");
        }
    }

    @FXML
    public void onSaveAll(ActionEvent event) {
        log.debug("Save all action occurred");
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Saving all items", new ButtonType[0]);
        alert.showAndWait().filter(ButtonType.OK::equals).ifPresent(button -> {
            ArrayList removedList = new ArrayList();
            this.changedItemList.forEach(item -> {
                try {
                    this.itemService.save(item);
                    removedList.add(item);
                }
                catch (CrudException ex) {
                    log.error(ex.getMessage());
                }
            });
            this.changedItemList.removeAll(removedList);
        });
    }

    @FXML
    public void onDelete(ActionEvent event) {
        log.debug("Delete action occurred");
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure to delete selected item?", new ButtonType[0]);
        alert.showAndWait().filter(ButtonType.OK::equals).ifPresent(unused -> {
            try {
                Modifiable item = (Modifiable)this.tableView.getSelectionModel().getSelectedItem();
                this.tableView.getItems().remove((Object)item);
                this.itemService.delete(item);
                this.changedItemList.remove((Object)item);
            }
            catch (CrudException ex) {
                log.error(ex.getMessage());
            }
        });
    }

    public final void initialize() {
        log.debug("Initialize");
        this.init();
        ObservableList newList = FXCollections.observableArrayList();
        try {
            newList.addAll((Collection)this.itemService.list());
        }
        catch (CrudException ex) {
            log.error(ex.getMessage());
        }
        this.tableView.setItems(newList);
    }

    @SafeVarargs
    public final void addColumns(TableColumn<T, ?> ... columns) {
        log.trace("Add table view columns: {}", (Object[])columns);
        this.tableView.getColumns().addAll((Object[])columns);
    }

    public <E extends AbstractDetailController<T>> void setDetailController(Class<E> detailController) {
        FxControllerAndView detailView = this.fxWeaver.load(detailController);
        ((AbstractDetailController)detailView.getController()).setChangedItemList(this.changedItemList);
        this.borderPane.setCenter((Node)detailView.getView().orElseThrow(() -> new RuntimeException("There is no view defined for controller " + detailController)));
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> ((AbstractDetailController)detailView.getController()).setItem(newValue));
    }

    protected void setRowFactory(String styleClass) {
        this.tableView.setRowFactory(new StyleChangingRowFactory<T>(styleClass, this.changedItemList));
    }

    protected abstract void init();

    public ObservableList<T> getChangedItemList() {
        return this.changedItemList;
    }
}

