/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.commons.springfx.utility;

import cz.masci.commons.springfx.data.Modifiable;
import io.github.palexdev.materialfx.controls.MFXTableRow;
import io.github.palexdev.materialfx.controls.MFXTableView;
import java.util.Collections;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class MFXStyleChangingRowFactory<T extends Modifiable>
implements Function<T, MFXTableRow<T>> {
    private final MFXTableView<T> tableView;
    private final ObservableList<T> selectionList;
    private final String styleClass;

    @Override
    public MFXTableRow<T> apply(T data) {
        MFXTableRow row = new MFXTableRow(this.tableView, data);
        row.dataProperty().addListener((obs, oldValue, newValue) -> this.updateStyleClass(row));
        this.selectionList.addListener(this.createListChangeListener(row));
        return row;
    }

    private ListChangeListener<T> createListChangeListener(MFXTableRow<T> row) {
        return change -> this.updateStyleClass(row);
    }

    private void updateStyleClass(MFXTableRow<T> row) {
        ObservableList rowStyleClasses = row.getStyleClass();
        if (this.selectionList.contains(row.getData())) {
            if (!rowStyleClasses.contains((Object)this.styleClass)) {
                rowStyleClasses.add((Object)this.styleClass);
            }
        } else {
            rowStyleClasses.removeAll(Collections.singleton(this.styleClass));
        }
    }

    public MFXStyleChangingRowFactory(MFXTableView<T> tableView, ObservableList<T> selectionList, String styleClass) {
        this.tableView = tableView;
        this.selectionList = selectionList;
        this.styleClass = styleClass;
    }
}

