/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.commons.springfx.controller;

import cz.masci.commons.springfx.data.Modifiable;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDetailController<T extends Modifiable> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDetailController.class);
    private ObservableList<T> changedItemList;
    private List<ObservableValue<String>> observableValues;
    private ChangeListener<String> listener;
    private T item;

    protected abstract List<ObservableValue<String>> initObservableValues();

    protected abstract void fillInputs(T var1);

    protected abstract void changed(ObservableValue<? extends String> var1, String var2, String var3);

    public void setChangedItemList(ObservableList<T> changedItemList) {
        this.changedItemList = changedItemList;
    }

    public void setItem(T item) {
        log.trace("Set item: {}", item);
        if (this.item != null) {
            this.unhookListener();
        }
        this.item = item;
        this.hookTo(this.item);
    }

    private void unhookListener() {
        this.getObservableValues().forEach(t -> t.removeListener(this.listener));
    }

    private void hookTo(T item) {
        this.fillInputs(item);
        if (item == null) {
            this.listener = null;
        } else {
            this.listener = (observable, oldValue, newValue) -> {
                log.trace("{} value changed from {} to {}", new Object[]{observable, oldValue, newValue});
                this.changed((ObservableValue<? extends String>)((ObservableValue<String>)observable), (String)oldValue, (String)newValue);
                if (this.changedItemList != null) {
                    this.changedItemList.add((Object)item);
                }
            };
            this.getObservableValues().forEach(t -> t.addListener(this.listener));
        }
    }

    private List<ObservableValue<String>> getObservableValues() {
        if (this.observableValues == null) {
            this.observableValues = List.copyOf(this.initObservableValues());
        }
        return this.observableValues;
    }

    public T getItem() {
        return this.item;
    }
}

