/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.commons.springfx.utility;

import cz.masci.commons.springfx.data.Modifiable;
import java.util.Collections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class StyleChangingRowFactory<T extends Modifiable>
implements Callback<TableView<T>, TableRow<T>> {
    private final ObservableList<T> selectionList;
    private final String styleClass;
    private final Callback<TableView<T>, TableRow<T>> baseFactory;

    public StyleChangingRowFactory(String styleClass, ObservableList<T> selectionList, Callback<TableView<T>, TableRow<T>> baseFactory) {
        this.styleClass = styleClass;
        this.selectionList = selectionList;
        this.baseFactory = baseFactory;
    }

    public StyleChangingRowFactory(String styleClass, ObservableList<T> selectionList) {
        this(styleClass, selectionList, null);
    }

    public TableRow<T> call(TableView<T> tableView) {
        TableRow row = this.baseFactory == null ? new TableRow() : (TableRow)this.baseFactory.call(tableView);
        row.itemProperty().addListener((obs, oldValue, newValue) -> this.updateStyleClass(row));
        this.selectionList.addListener(this.createListChangeListener(row));
        return row;
    }

    private ListChangeListener<T> createListChangeListener(TableRow<T> row) {
        return change -> this.updateStyleClass(row);
    }

    private void updateStyleClass(TableRow<T> row) {
        ObservableList rowStyleClasses = row.getStyleClass();
        if (this.selectionList.contains(row.getItem())) {
            if (!rowStyleClasses.contains((Object)this.styleClass)) {
                rowStyleClasses.add((Object)this.styleClass);
            }
        } else {
            rowStyleClasses.removeAll(Collections.singleton(this.styleClass));
        }
    }
}

