/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.commons.springfx.utility;

import cz.masci.commons.springfx.data.Modifiable;
import cz.masci.commons.springfx.service.ObservableListMap;
import java.util.Collections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class StyleChangingRowFactory<T extends Modifiable>
implements Callback<TableView<T>, TableRow<T>> {
    private final ObservableListMap observableListMap;
    private final String styleClass;
    private final String modifiableKey;
    private final Callback<TableView<T>, TableRow<T>> baseFactory;

    public StyleChangingRowFactory(String styleClass, String modifiableKey, ObservableListMap modifiableService, Callback<TableView<T>, TableRow<T>> baseFactory) {
        this.styleClass = styleClass;
        this.modifiableKey = modifiableKey;
        this.observableListMap = modifiableService;
        this.baseFactory = baseFactory;
    }

    public StyleChangingRowFactory(String styleClass, String modifiableKey, ObservableListMap modifiableService) {
        this(styleClass, modifiableKey, modifiableService, null);
    }

    public StyleChangingRowFactory(String styleClass, Class<T> modifiableKey, ObservableListMap modifiableService, Callback<TableView<T>, TableRow<T>> baseFactory) {
        this(styleClass, modifiableKey.getSimpleName(), modifiableService, baseFactory);
    }

    public StyleChangingRowFactory(String styleClass, Class<T> modifiableKey, ObservableListMap modifiableService) {
        this(styleClass, modifiableKey, modifiableService, null);
    }

    public TableRow<T> call(TableView<T> tableView) {
        TableRow row = this.baseFactory == null ? new TableRow() : (TableRow)this.baseFactory.call(tableView);
        row.itemProperty().addListener((obs, oldValue, newValue) -> this.updateStyleClass(row));
        this.observableListMap.addListener(this.modifiableKey, change -> this.updateStyleClass(row));
        return row;
    }

    private void updateStyleClass(TableRow<T> row) {
        ObservableList rowStyleClasses = row.getStyleClass();
        if (this.observableListMap.contains((Modifiable)row.getItem())) {
            if (!rowStyleClasses.contains((Object)this.styleClass)) {
                rowStyleClasses.add((Object)this.styleClass);
            }
        } else {
            rowStyleClasses.removeAll(Collections.singleton(this.styleClass));
        }
    }
}

