/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium;

import com.goterl.lazysodium.Sodium;
import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.interfaces.AEAD;
import com.goterl.lazysodium.interfaces.Auth;
import com.goterl.lazysodium.interfaces.Base;
import com.goterl.lazysodium.interfaces.Box;
import com.goterl.lazysodium.interfaces.DiffieHellman;
import com.goterl.lazysodium.interfaces.GenericHash;
import com.goterl.lazysodium.interfaces.Hash;
import com.goterl.lazysodium.interfaces.Helpers;
import com.goterl.lazysodium.interfaces.KeyDerivation;
import com.goterl.lazysodium.interfaces.KeyExchange;
import com.goterl.lazysodium.interfaces.MessageEncoder;
import com.goterl.lazysodium.interfaces.Padding;
import com.goterl.lazysodium.interfaces.PwHash;
import com.goterl.lazysodium.interfaces.Random;
import com.goterl.lazysodium.interfaces.Ristretto255;
import com.goterl.lazysodium.interfaces.SecretBox;
import com.goterl.lazysodium.interfaces.SecretStream;
import com.goterl.lazysodium.interfaces.SecureMemory;
import com.goterl.lazysodium.interfaces.ShortHash;
import com.goterl.lazysodium.interfaces.Sign;
import com.goterl.lazysodium.interfaces.Stream;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.DetachedDecrypt;
import com.goterl.lazysodium.utils.DetachedEncrypt;
import com.goterl.lazysodium.utils.HexMessageEncoder;
import com.goterl.lazysodium.utils.Key;
import com.goterl.lazysodium.utils.KeyPair;
import com.goterl.lazysodium.utils.SessionPair;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.AEADBadTagException;

public abstract class LazySodium
implements Base,
Random,
AEAD.Native,
AEAD.Lazy,
GenericHash.Native,
GenericHash.Lazy,
ShortHash.Native,
ShortHash.Lazy,
SecureMemory.Native,
SecureMemory.Lazy,
Auth.Native,
Auth.Lazy,
SecretStream.Native,
SecretStream.Lazy,
Stream.Native,
Stream.Lazy,
Padding.Native,
Padding.Lazy,
Helpers.Native,
Helpers.Lazy,
PwHash.Native,
PwHash.Lazy,
Hash.Native,
Hash.Lazy,
Sign.Native,
Sign.Lazy,
Box.Native,
Box.Lazy,
SecretBox.Native,
SecretBox.Lazy,
KeyExchange.Native,
KeyExchange.Lazy,
KeyDerivation.Native,
KeyDerivation.Lazy,
DiffieHellman.Native,
DiffieHellman.Lazy,
Ristretto255.Native,
Ristretto255.Lazy {
    protected final Charset charset;
    protected final MessageEncoder messageEncoder;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public LazySodium() {
        this(StandardCharsets.UTF_8, new HexMessageEncoder());
    }

    public LazySodium(Charset charset) {
        this(charset, new HexMessageEncoder());
    }

    public LazySodium(MessageEncoder messageEncoder) {
        this(StandardCharsets.UTF_8, messageEncoder);
    }

    public LazySodium(Charset charset, MessageEncoder messageEncoder) {
        this.charset = charset;
        this.messageEncoder = messageEncoder;
    }

    @Override
    public int sodiumInit() {
        return this.getSodium().sodium_init();
    }

    @Override
    public String sodiumBin2Hex(byte[] bin) {
        return LazySodium.bytesToHex(bin);
    }

    @Override
    public byte[] sodiumHex2Bin(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    public String toHexStr(byte[] bs) {
        return LazySodium.bytesToHex(bs);
    }

    public byte[] toBinary(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    public static String toHex(byte[] bin) {
        return LazySodium.bytesToHex(bin);
    }

    public static byte[] toBin(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static byte[] hexToBytes(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Hexadecimal string length must be even");
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)((LazySodium.hexDigit(s.charAt(2 * i)) & 0xFF) << 4 | LazySodium.hexDigit(s.charAt(2 * i + 1)) & 0xFF);
        }
        return data;
    }

    private static byte hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        throw new IllegalArgumentException("Illegal hexadecimal character " + (byte)c);
    }

    @Override
    public long randomBytesRandom() {
        return this.getSodium().randombytes_random();
    }

    @Override
    public void randomBytesBuf(byte[] buff, int size) {
        BaseChecker.checkArrayLength("buff", buff, size);
        this.getSodium().randombytes_buf(buff, size);
    }

    @Override
    public byte[] randomBytesBuf(int size) {
        byte[] bs = new byte[size];
        this.getSodium().randombytes_buf(bs, size);
        return bs;
    }

    @Override
    public byte[] nonce(int size) {
        return this.randomBytesBuf(size);
    }

    @Override
    public long randomBytesUniform(int upperBound) {
        return this.getSodium().randombytes_uniform(upperBound);
    }

    @Override
    public void randomBytesDeterministic(byte[] buff, int size, byte[] seed) {
        BaseChecker.checkArrayLength("buff", buff, size);
        Random.RandomChecker.checkSeed(seed);
        this.getSodium().randombytes_buf_deterministic(buff, size, seed);
    }

    @Override
    public byte[] randomBytesDeterministic(int size, byte[] seed) {
        Random.RandomChecker.checkSeed(seed);
        byte[] bs = new byte[size];
        this.getSodium().randombytes_buf_deterministic(bs, size, seed);
        return bs;
    }

    @Override
    public boolean sodiumPad(IntByReference paddedBuffLen, Pointer buf, int unpaddedBufLen, int blockSize, int maxBufLen) {
        return this.successful(this.getSodium().sodium_pad(paddedBuffLen, buf, unpaddedBufLen, blockSize, maxBufLen));
    }

    @Override
    public boolean sodiumUnpad(IntByReference unPaddedBuffLen, Pointer buf, int paddedBufLen, int blockSize) {
        return this.successful(this.getSodium().sodium_unpad(unPaddedBuffLen, buf, paddedBufLen, blockSize));
    }

    @Override
    public void sodiumMemZero(byte[] pnt, int len) {
        BaseChecker.checkArrayLength("pnt", pnt, len);
        this.getSodium().sodium_memzero(pnt, len);
    }

    @Override
    public boolean sodiumMLock(byte[] array, int len) {
        BaseChecker.checkArrayLength("array", array, len);
        return this.successful(this.getSodium().sodium_mlock(array, len));
    }

    @Override
    public boolean sodiumMUnlock(byte[] array, int len) {
        BaseChecker.checkArrayLength("array", array, len);
        return this.successful(this.getSodium().sodium_munlock(array, len));
    }

    @Override
    public Pointer sodiumMalloc(int size) {
        BaseChecker.checkAtLeast("size", size, 0L);
        return this.getSodium().sodium_malloc(size);
    }

    @Override
    public Pointer sodiumAllocArray(int count, int size) {
        BaseChecker.checkAtLeast("count", count, 0L);
        BaseChecker.checkAtLeast("size", size, 0L);
        return this.getSodium().sodium_allocarray(count, size);
    }

    @Override
    public void sodiumFree(Pointer p) {
        this.getSodium().sodium_free(p);
    }

    @Override
    public boolean sodiumMProtectNoAccess(Pointer ptr) {
        return this.successful(this.getSodium().sodium_mprotect_noaccess(ptr));
    }

    @Override
    public boolean sodiumMProtectReadOnly(Pointer ptr) {
        return this.successful(this.getSodium().sodium_mprotect_readonly(ptr));
    }

    @Override
    public boolean sodiumMProtectReadWrite(Pointer ptr) {
        return this.successful(this.getSodium().sodium_mprotect_readwrite(ptr));
    }

    @Override
    public void cryptoKdfKeygen(byte[] masterKey) {
        KeyDerivation.Checker.checkMasterKey(masterKey);
        this.getSodium().crypto_kdf_keygen(masterKey);
    }

    @Override
    public boolean cryptoKdfDeriveFromKey(byte[] subKey, int subKeyLen, long subKeyId, byte[] context, byte[] masterKey) {
        KeyDerivation.Checker.checkSubKeyLength(subKeyLen);
        BaseChecker.checkArrayLength("subKey", subKey, subKeyLen);
        KeyDerivation.Checker.checkMasterKey(masterKey);
        KeyDerivation.Checker.checkContext(context);
        return this.successful(this.getSodium().crypto_kdf_derive_from_key(subKey, subKeyLen, subKeyId, context, masterKey));
    }

    @Override
    public Key cryptoKdfKeygen() {
        byte[] masterKey = new byte[32];
        this.getSodium().crypto_kdf_keygen(masterKey);
        return Key.fromBytes(masterKey);
    }

    @Override
    public Key cryptoKdfDeriveFromKey(int lengthOfSubKey, long subKeyId, String context, Key masterKey) throws SodiumException {
        KeyDerivation.Checker.checkSubKeyLength(lengthOfSubKey);
        KeyDerivation.Checker.checkMasterKey(masterKey.getAsBytes());
        byte[] contextAsBytes = this.bytes(context);
        KeyDerivation.Checker.checkContext(contextAsBytes);
        byte[] subKey = new byte[lengthOfSubKey];
        byte[] masterKeyAsBytes = masterKey.getAsBytes();
        int res = this.getSodium().crypto_kdf_derive_from_key(subKey, lengthOfSubKey, subKeyId, contextAsBytes, masterKeyAsBytes);
        if (!this.successful(res)) {
            throw new SodiumException("Failed cryptoKdfDeriveFromKey.");
        }
        return Key.fromBytes(subKey);
    }

    @Override
    public boolean cryptoKxKeypair(byte[] publicKey, byte[] secretKey) {
        KeyExchange.Checker.checkPublicKey(publicKey);
        KeyExchange.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_kx_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoKxSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        KeyExchange.Checker.checkPublicKey(publicKey);
        KeyExchange.Checker.checkSecretKey(secretKey);
        KeyExchange.Checker.checkSeed(seed);
        return this.successful(this.getSodium().crypto_kx_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoKxClientSessionKeys(byte[] rx, byte[] tx, byte[] clientPk, byte[] clientSk, byte[] serverPk) {
        KeyExchange.Checker.checkSessionKey(rx);
        KeyExchange.Checker.checkSessionKey(tx);
        KeyExchange.Checker.checkPublicKey(clientPk);
        KeyExchange.Checker.checkSecretKey(clientSk);
        KeyExchange.Checker.checkPublicKey(serverPk);
        return this.successful(this.getSodium().crypto_kx_client_session_keys(rx, tx, clientPk, clientSk, serverPk));
    }

    @Override
    public boolean cryptoKxServerSessionKeys(byte[] rx, byte[] tx, byte[] serverPk, byte[] serverSk, byte[] clientPk) {
        KeyExchange.Checker.checkSessionKey(rx);
        KeyExchange.Checker.checkSessionKey(tx);
        KeyExchange.Checker.checkPublicKey(serverPk);
        KeyExchange.Checker.checkSecretKey(serverSk);
        KeyExchange.Checker.checkPublicKey(clientPk);
        return this.successful(this.getSodium().crypto_kx_server_session_keys(rx, tx, serverPk, serverSk, clientPk));
    }

    @Override
    public KeyPair cryptoKxKeypair() throws SodiumException {
        byte[] secretKey = new byte[32];
        byte[] publicKey = new byte[32];
        if (!this.successful(this.getSodium().crypto_kx_keypair(publicKey, secretKey))) {
            throw new SodiumException("Failed to generate keypair");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public KeyPair cryptoKxKeypair(byte[] seed) throws SodiumException {
        KeyExchange.Checker.checkSeed(seed);
        byte[] secretKey = new byte[32];
        byte[] publicKey = new byte[32];
        if (!this.successful(this.getSodium().crypto_kx_seed_keypair(publicKey, secretKey, seed))) {
            throw new SodiumException("Failed to generate keypair");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public SessionPair cryptoKxClientSessionKeys(KeyPair clientKeyPair, KeyPair serverKeyPair) throws SodiumException {
        return this.cryptoKxClientSessionKeys(clientKeyPair.getPublicKey(), clientKeyPair.getSecretKey(), serverKeyPair.getPublicKey());
    }

    @Override
    public SessionPair cryptoKxClientSessionKeys(KeyPair clientKeyPair, Key serverPublicKey) throws SodiumException {
        return this.cryptoKxClientSessionKeys(clientKeyPair.getPublicKey(), clientKeyPair.getSecretKey(), serverPublicKey);
    }

    @Override
    public SessionPair cryptoKxServerSessionKeys(Key serverPk, Key serverSk, Key clientPk) throws SodiumException {
        byte[] rx = new byte[32];
        byte[] tx = new byte[32];
        if (!this.cryptoKxServerSessionKeys(rx, tx, serverPk.getAsBytes(), serverSk.getAsBytes(), clientPk.getAsBytes())) {
            throw new SodiumException("Failed creating server session keys.");
        }
        return new SessionPair(rx, tx);
    }

    @Override
    public SessionPair cryptoKxClientSessionKeys(Key clientPk, Key clientSk, Key serverPk) throws SodiumException {
        byte[] rx = new byte[32];
        byte[] tx = new byte[32];
        if (!this.cryptoKxClientSessionKeys(rx, tx, clientPk.getAsBytes(), clientSk.getAsBytes(), serverPk.getAsBytes())) {
            throw new SodiumException("Failed creating client session keys.");
        }
        return new SessionPair(rx, tx);
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public SessionPair cryptoKxServerSessionKeys(KeyPair serverKeyPair, KeyPair clientKeyPair) throws SodiumException {
        return this.cryptoKxServerSessionKeys(serverKeyPair.getPublicKey(), serverKeyPair.getSecretKey(), clientKeyPair.getPublicKey());
    }

    @Override
    public SessionPair cryptoKxServerSessionKeys(KeyPair serverKeyPair, Key clientPublicKey) throws SodiumException {
        return this.cryptoKxServerSessionKeys(serverKeyPair.getPublicKey(), serverKeyPair.getSecretKey(), clientPublicKey);
    }

    @Override
    public boolean cryptoPwHash(byte[] outputHash, int outputHashLen, byte[] password, int passwordLen, byte[] salt, long opsLimit, NativeLong memLimit, PwHash.Alg alg) {
        BaseChecker.checkArrayLength("outputHash", outputHash, outputHashLen);
        PwHash.Checker.checkLengthOfHash(outputHashLen);
        BaseChecker.checkArrayLength("password", password, passwordLen);
        PwHash.Checker.checkLengthOfPassword(passwordLen);
        PwHash.Checker.checkSalt(salt);
        PwHash.Checker.checkOpsLimit(opsLimit);
        PwHash.Checker.checkMemLimit(memLimit);
        int res = this.getSodium().crypto_pwhash(outputHash, outputHashLen, password, passwordLen, salt, opsLimit, memLimit, alg.getValue());
        return this.successful(res);
    }

    @Override
    public boolean cryptoPwHashStr(byte[] outputStr, byte[] password, int passwordLen, long opsLimit, NativeLong memLimit) {
        PwHash.Checker.checkHashStrOutput(outputStr);
        BaseChecker.checkArrayLength("password", password, passwordLen);
        PwHash.Checker.checkLengthOfPassword(passwordLen);
        PwHash.Checker.checkOpsLimit(opsLimit);
        PwHash.Checker.checkMemLimit(memLimit);
        int res = this.getSodium().crypto_pwhash_str(outputStr, password, passwordLen, opsLimit, memLimit);
        return this.successful(res);
    }

    @Override
    public boolean cryptoPwHashStrVerify(byte[] hash, byte[] password, int passwordLen) {
        PwHash.Checker.checkHashStrInput(hash);
        BaseChecker.checkArrayLength("password", password, passwordLen);
        return this.successful(this.getSodium().crypto_pwhash_str_verify(hash, password, passwordLen));
    }

    @Override
    public PwHash.NeedsRehashResult cryptoPwHashStrNeedsRehash(byte[] hash, long opsLimit, NativeLong memLimit) {
        PwHash.Checker.checkHashStrInput(hash);
        PwHash.Checker.checkOpsLimit(opsLimit);
        PwHash.Checker.checkMemLimit(memLimit);
        return PwHash.NeedsRehashResult.valueOf(this.getSodium().crypto_pwhash_str_needs_rehash(hash, opsLimit, memLimit));
    }

    @Override
    public String cryptoPwHash(String password, int lengthOfHash, byte[] salt, long opsLimit, NativeLong memLimit, PwHash.Alg alg) throws SodiumException {
        byte[] passwordBytes = this.bytes(password);
        PwHash.Checker.checkPassword(passwordBytes);
        PwHash.Checker.checkLengthOfHash(lengthOfHash);
        PwHash.Checker.checkSalt(salt);
        PwHash.Checker.checkOpsLimit(opsLimit);
        PwHash.Checker.checkMemLimit(memLimit);
        byte[] hash = new byte[lengthOfHash];
        int res = this.getSodium().crypto_pwhash(hash, hash.length, passwordBytes, passwordBytes.length, salt, opsLimit, memLimit, alg.getValue());
        if (res != 0) {
            throw new SodiumException("Could not hash your string. This may be due to insufficient memory or your CPU does not support Argon2's instruction set.");
        }
        return this.messageEncoder.encode(hash);
    }

    @Override
    public String cryptoPwHashString(String password, long opsLimit, NativeLong memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        PwHash.Checker.checkPassword(passwordBytes);
        PwHash.Checker.checkOpsLimit(opsLimit);
        PwHash.Checker.checkMemLimit(memLimit);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        return LazySodium.decodeAsciiz(hash);
    }

    @Override
    @Deprecated
    public String cryptoPwHashStr(String password, long opsLimit, NativeLong memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        PwHash.Checker.checkPassword(passwordBytes);
        PwHash.Checker.checkOpsLimit(opsLimit);
        PwHash.Checker.checkMemLimit(memLimit);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        return this.messageEncoder.encode(hash);
    }

    @Override
    @Deprecated
    public String cryptoPwHashStrRemoveNulls(String password, long opsLimit, NativeLong memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        byte[] hashNoNulls = this.removeNulls(hash);
        return this.messageEncoder.encode(hashNoNulls);
    }

    @Override
    public boolean cryptoPwHashStringVerify(String hash, String password) {
        byte[] hashBytes = LazySodium.encodeToAsciiz(hash);
        byte[] passwordBytes = this.bytes(password);
        return this.cryptoPwHashStrVerify(hashBytes, passwordBytes, passwordBytes.length);
    }

    @Override
    @Deprecated
    public boolean cryptoPwHashStrVerify(String hash, String password) {
        byte[] hashBytes = this.messageEncoder.decode(hash);
        byte[] passwordBytes = this.bytes(password);
        byte endOfHash = hashBytes[hashBytes.length - 1];
        if (endOfHash != 0) {
            byte[] hashWithNullByte = new byte[hashBytes.length + 1];
            System.arraycopy(hashBytes, 0, hashWithNullByte, 0, hashBytes.length);
            hashBytes = hashWithNullByte;
        }
        return this.cryptoPwHashStrVerify(hashBytes, passwordBytes, passwordBytes.length);
    }

    @Override
    public PwHash.NeedsRehashResult cryptoPwHashStringNeedsRehash(String hash, long opsLimit, NativeLong memLimit) {
        byte[] hashBytes = LazySodium.encodeToAsciiz(hash);
        return this.cryptoPwHashStrNeedsRehash(hashBytes, opsLimit, memLimit);
    }

    @Override
    public boolean cryptoHashSha256(byte[] out, byte[] in, int inLen) {
        Hash.Checker.checkHashSha256(out);
        BaseChecker.checkArrayLength("in", in, inLen);
        return this.successful(this.getSodium().crypto_hash_sha256(out, in, inLen));
    }

    @Override
    public boolean cryptoHashSha256Init(Hash.State256 state) {
        BaseChecker.requireNonNull("state", (Object)state);
        return this.successful(this.getSodium().crypto_hash_sha256_init(state));
    }

    @Override
    public boolean cryptoHashSha256Update(Hash.State256 state, byte[] in, int inLen) {
        BaseChecker.requireNonNull("state", (Object)state);
        BaseChecker.checkArrayLength("in", in, inLen);
        return this.successful(this.getSodium().crypto_hash_sha256_update(state, in, inLen));
    }

    @Override
    public boolean cryptoHashSha256Final(Hash.State256 state, byte[] out) {
        BaseChecker.requireNonNull("state", (Object)state);
        Hash.Checker.checkHashSha256(out);
        return this.successful(this.getSodium().crypto_hash_sha256_final(state, out));
    }

    @Override
    public boolean cryptoHashSha512(byte[] out, byte[] in, int inLen) {
        Hash.Checker.checkHashSha512(out);
        BaseChecker.checkArrayLength("in", in, inLen);
        return this.successful(this.getSodium().crypto_hash_sha512(out, in, inLen));
    }

    @Override
    public boolean cryptoHashSha512Init(Hash.State512 state) {
        BaseChecker.requireNonNull("state", (Object)state);
        return this.successful(this.getSodium().crypto_hash_sha512_init(state));
    }

    @Override
    public boolean cryptoHashSha512Update(Hash.State512 state, byte[] in, int inLen) {
        BaseChecker.requireNonNull("state", (Object)state);
        BaseChecker.checkArrayLength("in", in, inLen);
        return this.successful(this.getSodium().crypto_hash_sha512_update(state, in, inLen));
    }

    @Override
    public boolean cryptoHashSha512Final(Hash.State512 state, byte[] out) {
        BaseChecker.requireNonNull("state", (Object)state);
        Hash.Checker.checkHashSha512(out);
        return this.successful(this.getSodium().crypto_hash_sha512_final(state, out));
    }

    @Override
    public String cryptoHashSha256(String message) throws SodiumException {
        byte[] hashedBytes = new byte[32];
        byte[] msgBytes = this.bytes(message);
        if (!this.cryptoHashSha256(hashedBytes, msgBytes, msgBytes.length)) {
            throw new SodiumException("Unsuccessful sha-256 hash.");
        }
        return this.messageEncoder.encode(hashedBytes);
    }

    @Override
    public String cryptoHashSha512(String message) throws SodiumException {
        byte[] hashedBytes = new byte[64];
        byte[] msgBytes = this.bytes(message);
        if (!this.cryptoHashSha512(hashedBytes, msgBytes, msgBytes.length)) {
            throw new SodiumException("Unsuccessful sha-512 hash.");
        }
        return this.messageEncoder.encode(hashedBytes);
    }

    @Override
    public boolean cryptoHashSha256Update(Hash.State256 state, String messagePart) {
        byte[] msgBytes = this.bytes(messagePart);
        return this.cryptoHashSha256Update(state, msgBytes, msgBytes.length);
    }

    @Override
    public String cryptoHashSha256Final(Hash.State256 state) throws SodiumException {
        byte[] finalHash = new byte[32];
        if (!this.cryptoHashSha256Final(state, finalHash)) {
            throw new SodiumException("Could not finalise sha-256.");
        }
        return this.messageEncoder.encode(finalHash);
    }

    @Override
    public boolean cryptoHashSha512Update(Hash.State512 state, String messagePart) {
        byte[] msgBytes = this.bytes(messagePart);
        return this.cryptoHashSha512Update(state, msgBytes, msgBytes.length);
    }

    @Override
    public String cryptoHashSha512Final(Hash.State512 state) throws SodiumException {
        byte[] finalHash = new byte[64];
        if (!this.cryptoHashSha512Final(state, finalHash)) {
            throw new SodiumException("Could not finalise sha-512.");
        }
        return this.messageEncoder.encode(finalHash);
    }

    @Override
    public void cryptoSecretBoxKeygen(byte[] key) {
        SecretBox.Checker.checkKey(key);
        this.getSodium().crypto_secretbox_keygen(key);
    }

    @Override
    public boolean cryptoSecretBoxEasy(byte[] cipherText, byte[] message, int messageLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        SecretBox.Checker.checkCipherText(cipherText, messageLen);
        SecretBox.Checker.checkNonce(nonce);
        SecretBox.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_secretbox_easy(cipherText, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxOpenEasy(byte[] message, byte[] cipherText, int cipherTextLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("cipherText", cipherText, cipherTextLen);
        SecretBox.Checker.checkCipherTextLength(cipherTextLen);
        SecretBox.Checker.checkMessage(message, cipherTextLen);
        SecretBox.Checker.checkNonce(nonce);
        SecretBox.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_secretbox_open_easy(message, cipherText, cipherTextLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxDetached(byte[] cipherText, byte[] mac, byte[] message, int messageLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipherText length", cipherText.length, messageLen);
        SecretBox.Checker.checkMac(mac);
        SecretBox.Checker.checkNonce(nonce);
        SecretBox.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_secretbox_detached(cipherText, mac, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxOpenDetached(byte[] message, byte[] cipherText, byte[] mac, int cipherTextLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("cipherText", cipherText, cipherTextLen);
        BaseChecker.checkExpectedMemorySize("message length", message.length, cipherTextLen);
        SecretBox.Checker.checkMac(mac);
        SecretBox.Checker.checkNonce(nonce);
        SecretBox.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_secretbox_open_detached(message, cipherText, mac, cipherTextLen, nonce, key));
    }

    @Override
    public Key cryptoSecretBoxKeygen() {
        byte[] key = new byte[32];
        this.cryptoSecretBoxKeygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public String cryptoSecretBoxEasy(String message, byte[] nonce, Key key) throws SodiumException {
        byte[] keyBytes = key.getAsBytes();
        byte[] messageBytes = this.bytes(message);
        byte[] cipherTextBytes = new byte[16 + messageBytes.length];
        if (!this.cryptoSecretBoxEasy(cipherTextBytes, messageBytes, messageBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not encrypt message.");
        }
        return this.messageEncoder.encode(cipherTextBytes);
    }

    @Override
    public String cryptoSecretBoxOpenEasy(String cipher, byte[] nonce, Key key) throws SodiumException {
        byte[] keyBytes = key.getAsBytes();
        byte[] cipherBytes = this.messageEncoder.decode(cipher);
        SecretBox.Checker.checkCipherTextLength(cipherBytes.length);
        byte[] messageBytes = new byte[cipherBytes.length - 16];
        if (!this.cryptoSecretBoxOpenEasy(messageBytes, cipherBytes, cipherBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not decrypt message.");
        }
        return this.str(messageBytes);
    }

    @Override
    public DetachedEncrypt cryptoSecretBoxDetached(String message, byte[] nonce, Key key) throws SodiumException {
        byte[] macBytes;
        byte[] keyBytes = key.getAsBytes();
        byte[] messageBytes = this.bytes(message);
        byte[] cipherTextBytes = new byte[messageBytes.length];
        if (!this.cryptoSecretBoxDetached(cipherTextBytes, macBytes = new byte[16], messageBytes, messageBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not encrypt detached message.");
        }
        return new DetachedEncrypt(cipherTextBytes, macBytes);
    }

    @Override
    public String cryptoSecretBoxOpenDetached(DetachedEncrypt cipherAndMac, byte[] nonce, Key key) throws SodiumException {
        byte[] macBytes;
        byte[] keyBytes = key.getAsBytes();
        byte[] cipherBytes = cipherAndMac.getCipher();
        byte[] messageBytes = new byte[cipherBytes.length];
        if (!this.cryptoSecretBoxOpenDetached(messageBytes, cipherBytes, macBytes = cipherAndMac.getMac(), cipherBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not decrypt detached message.");
        }
        return this.str(messageBytes);
    }

    @Override
    public boolean cryptoScalarMultBase(byte[] publicKey, byte[] secretKey) {
        DiffieHellman.Checker.checkPublicKey(publicKey);
        DiffieHellman.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_scalarmult_base(publicKey, secretKey));
    }

    @Override
    public Key cryptoScalarMultBase(Key secretKey) {
        byte[] publicKey = new byte[32];
        this.cryptoScalarMultBase(publicKey, secretKey.getAsBytes());
        return Key.fromBytes(publicKey);
    }

    @Override
    public boolean cryptoScalarMult(byte[] shared, byte[] secretKey, byte[] publicKey) {
        DiffieHellman.Checker.checkSharedKey(shared);
        DiffieHellman.Checker.checkPublicKey(publicKey);
        DiffieHellman.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_scalarmult(shared, secretKey, publicKey));
    }

    @Override
    public Key cryptoScalarMult(Key secretKey, Key publicKey) {
        byte[] sharedKey = new byte[32];
        this.cryptoScalarMult(sharedKey, secretKey.getAsBytes(), publicKey.getAsBytes());
        return Key.fromBytes(sharedKey);
    }

    @Override
    public boolean cryptoBoxKeypair(byte[] publicKey, byte[] secretKey) {
        Box.Checker.checkPublicKey(publicKey);
        Box.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_box_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        Box.Checker.checkPublicKey(publicKey);
        Box.Checker.checkSecretKey(secretKey);
        Box.Checker.checkSeed(seed);
        return this.successful(this.getSodium().crypto_box_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoBoxEasy(byte[] cipherText, byte[] message, int messageLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        Box.Checker.checkCipherText(cipherText, messageLen);
        Box.Checker.checkNonce(nonce);
        Box.Checker.checkPublicKey(publicKey);
        Box.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_box_easy(cipherText, message, messageLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxOpenEasy(byte[] message, byte[] cipherText, int cipherTextLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        BaseChecker.checkArrayLength("cipherText", cipherText, cipherTextLen);
        Box.Checker.checkCipherTextLength(cipherTextLen);
        Box.Checker.checkMessage(message, cipherTextLen);
        Box.Checker.checkNonce(nonce);
        Box.Checker.checkPublicKey(publicKey);
        Box.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_box_open_easy(message, cipherText, cipherTextLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxDetached(byte[] cipherText, byte[] mac, byte[] message, int messageLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipherText length", cipherText.length, messageLen);
        Box.Checker.checkMac(mac);
        Box.Checker.checkNonce(nonce);
        Box.Checker.checkPublicKey(publicKey);
        Box.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_box_detached(cipherText, mac, message, messageLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxOpenDetached(byte[] message, byte[] cipherText, byte[] mac, int cipherTextLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        BaseChecker.checkArrayLength("cipherText", cipherText, cipherTextLen);
        BaseChecker.checkExpectedMemorySize("message length", message.length, cipherTextLen);
        Box.Checker.checkMac(mac);
        Box.Checker.checkNonce(nonce);
        Box.Checker.checkPublicKey(publicKey);
        Box.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_box_open_detached(message, cipherText, mac, cipherTextLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxBeforeNm(byte[] k, byte[] publicKey, byte[] secretKey) {
        Box.Checker.checkSharedKey(k);
        Box.Checker.checkPublicKey(publicKey);
        Box.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_box_beforenm(k, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxEasyAfterNm(byte[] cipherText, byte[] message, int messageLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        Box.Checker.checkCipherText(cipherText, messageLen);
        Box.Checker.checkNonce(nonce);
        Box.Checker.checkSharedKey(key);
        return this.successful(this.getSodium().crypto_box_easy_afternm(cipherText, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxOpenEasyAfterNm(byte[] message, byte[] cipherText, int cipherTextLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("cipherText", cipherText, cipherTextLen);
        Box.Checker.checkCipherTextLength(cipherTextLen);
        Box.Checker.checkMessage(message, cipherTextLen);
        Box.Checker.checkNonce(nonce);
        Box.Checker.checkSharedKey(key);
        return this.successful(this.getSodium().crypto_box_open_easy_afternm(message, cipherText, cipherTextLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxDetachedAfterNm(byte[] cipherText, byte[] mac, byte[] message, int messageLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipherText length", cipherText.length, messageLen);
        Box.Checker.checkMac(mac);
        Box.Checker.checkNonce(nonce);
        Box.Checker.checkSharedKey(key);
        return this.successful(this.getSodium().crypto_box_detached_afternm(cipherText, mac, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxOpenDetachedAfterNm(byte[] message, byte[] cipherText, byte[] mac, int cipherTextLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("cipherText", cipherText, cipherTextLen);
        BaseChecker.checkExpectedMemorySize("message length", message.length, cipherTextLen);
        Box.Checker.checkMac(mac);
        Box.Checker.checkNonce(nonce);
        Box.Checker.checkSharedKey(key);
        return this.successful(this.getSodium().crypto_box_open_detached_afternm(message, cipherText, mac, cipherTextLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxSeal(byte[] cipher, byte[] message, int messageLen, byte[] publicKey) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        Box.Checker.checkSealCipherText(cipher, messageLen);
        Box.Checker.checkPublicKey(publicKey);
        return this.successful(this.getSodium().crypto_box_seal(cipher, message, messageLen, publicKey));
    }

    @Override
    public boolean cryptoBoxSealOpen(byte[] message, byte[] cipher, int cipherLen, byte[] publicKey, byte[] secretKey) {
        BaseChecker.checkArrayLength("cipher", cipher, cipherLen);
        Box.Checker.checkSealCipherTextLength(cipherLen);
        Box.Checker.checkSealMessage(message, cipherLen);
        Box.Checker.checkPublicKey(publicKey);
        Box.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_box_seal_open(message, cipher, cipherLen, publicKey, secretKey));
    }

    @Override
    public KeyPair cryptoBoxKeypair() throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoBoxKeypair(publicKey, secretKey = this.randomBytesBuf(32))) {
            throw new SodiumException("Unable to create a public and private key.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public KeyPair cryptoBoxSeedKeypair(byte[] seed) throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoBoxSeedKeypair(publicKey, secretKey = this.randomBytesBuf(32), seed)) {
            throw new SodiumException("Unable to create a public and private key.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public String cryptoBoxEasy(String message, byte[] nonce, KeyPair keyPair) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] cipherBytes = new byte[16 + messageBytes.length];
        boolean res = this.cryptoBoxEasy(cipherBytes, messageBytes, messageBytes.length, nonce, keyPair.getPublicKey().getAsBytes(), keyPair.getSecretKey().getAsBytes());
        if (!res) {
            throw new SodiumException("Could not encrypt your message.");
        }
        return this.messageEncoder.encode(cipherBytes);
    }

    @Override
    public String cryptoBoxOpenEasy(String cipherText, byte[] nonce, KeyPair keyPair) throws SodiumException {
        byte[] cipher = this.messageEncoder.decode(cipherText);
        Box.Checker.checkCipherTextLength(cipher.length);
        byte[] message = new byte[cipher.length - 16];
        boolean res = this.cryptoBoxOpenEasy(message, cipher, cipher.length, nonce, keyPair.getPublicKey().getAsBytes(), keyPair.getSecretKey().getAsBytes());
        if (!res) {
            throw new SodiumException("Could not decrypt your message.");
        }
        return this.str(message);
    }

    @Override
    public String cryptoBoxBeforeNm(byte[] publicKey, byte[] secretKey) throws SodiumException {
        byte[] sharedKey = new byte[32];
        boolean res = this.cryptoBoxBeforeNm(sharedKey, publicKey, secretKey);
        if (!res) {
            throw new SodiumException("Unable to generate shared secret key.");
        }
        return this.messageEncoder.encode(sharedKey);
    }

    @Override
    public String cryptoBoxBeforeNm(KeyPair keyPair) throws SodiumException {
        return this.cryptoBoxBeforeNm(keyPair.getPublicKey().getAsBytes(), keyPair.getSecretKey().getAsBytes());
    }

    @Override
    public String cryptoBoxEasyAfterNm(String message, byte[] nonce, String sharedSecretKey) throws SodiumException {
        byte[] sharedKey = this.messageEncoder.decode(sharedSecretKey);
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[messageBytes.length + 16];
        boolean res = this.cryptoBoxEasyAfterNm(cipher, messageBytes, messageBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key encryption.");
        }
        return this.messageEncoder.encode(cipher);
    }

    @Override
    public String cryptoBoxOpenEasyAfterNm(String cipher, byte[] nonce, String sharedSecretKey) throws SodiumException {
        byte[] sharedKey = this.messageEncoder.decode(sharedSecretKey);
        byte[] cipherBytes = this.messageEncoder.decode(cipher);
        Box.Checker.checkCipherTextLength(cipherBytes.length);
        byte[] message = new byte[cipherBytes.length - 16];
        boolean res = this.cryptoBoxOpenEasyAfterNm(message, cipherBytes, cipherBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key decryption.");
        }
        return this.str(message);
    }

    @Override
    public DetachedEncrypt cryptoBoxDetachedAfterNm(String message, byte[] nonce, String sharedSecretKey) throws SodiumException {
        byte[] mac;
        byte[] sharedKey = this.messageEncoder.decode(sharedSecretKey);
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[messageBytes.length];
        boolean res = this.cryptoBoxDetachedAfterNm(cipher, mac = new byte[16], messageBytes, messageBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key detached encryption.");
        }
        return new DetachedEncrypt(cipher, mac);
    }

    @Override
    public DetachedDecrypt cryptoBoxOpenDetachedAfterNm(DetachedEncrypt detachedEncrypt, byte[] nonce, String sharedSecretKey) throws SodiumException {
        byte[] mac;
        byte[] sharedKey = this.messageEncoder.decode(sharedSecretKey);
        byte[] cipherBytes = detachedEncrypt.getCipher();
        byte[] message = new byte[cipherBytes.length];
        boolean res = this.cryptoBoxOpenDetachedAfterNm(message, cipherBytes, mac = detachedEncrypt.getMac(), cipherBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key detached decryption.");
        }
        return new DetachedDecrypt(message, mac);
    }

    @Override
    public String cryptoBoxSealEasy(String message, Key publicKey) throws SodiumException {
        byte[] keyBytes = publicKey.getAsBytes();
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[48 + messageBytes.length];
        if (!this.cryptoBoxSeal(cipher, messageBytes, messageBytes.length, keyBytes)) {
            throw new SodiumException("Could not encrypt message.");
        }
        return this.messageEncoder.encode(cipher);
    }

    @Override
    public String cryptoBoxSealOpenEasy(String cipherText, KeyPair keyPair) throws SodiumException {
        byte[] cipher = this.messageEncoder.decode(cipherText);
        Box.Checker.checkCipherTextLength(cipher.length);
        byte[] message = new byte[cipher.length - 48];
        boolean res = this.cryptoBoxSealOpen(message, cipher, cipher.length, keyPair.getPublicKey().getAsBytes(), keyPair.getSecretKey().getAsBytes());
        if (!res) {
            throw new SodiumException("Could not decrypt your message.");
        }
        return this.str(message);
    }

    @Override
    public boolean cryptoSignInit(Sign.StateCryptoSign state) {
        return this.successful(this.getSodium().crypto_sign_init(state));
    }

    @Override
    public boolean cryptoSignUpdate(Sign.StateCryptoSign state, byte[] chunk, int chunkLength) {
        BaseChecker.checkArrayLength("chunk", chunk, chunkLength);
        return this.successful(this.getSodium().crypto_sign_update(state, chunk, chunkLength));
    }

    @Override
    public boolean cryptoSignFinalCreate(Sign.StateCryptoSign state, byte[] sig, byte[] sk) {
        Sign.Checker.checkSignature(sig);
        Sign.Checker.checkSecretKey(sk);
        return this.successful(this.getSodium().crypto_sign_final_create(state, sig, null, sk));
    }

    @Override
    public boolean cryptoSignFinalVerify(Sign.StateCryptoSign state, byte[] sig, byte[] pk) {
        Sign.Checker.checkSignature(sig);
        Sign.Checker.checkPublicKey(pk);
        return this.successful(this.getSodium().crypto_sign_final_verify(state, sig, pk));
    }

    @Override
    public boolean cryptoSignKeypair(byte[] publicKey, byte[] secretKey) {
        Sign.Checker.checkPublicKey(publicKey);
        Sign.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_sign_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoSignSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        Sign.Checker.checkPublicKey(publicKey);
        Sign.Checker.checkSecretKey(secretKey);
        Sign.Checker.checkSeed(seed);
        return this.successful(this.getSodium().crypto_sign_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoSign(byte[] signedMessage, byte[] message, int messageLen, byte[] secretKey) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        Sign.Checker.checkSignedMessageLength(signedMessage, messageLen);
        Sign.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_sign(signedMessage, new PointerByReference(Pointer.NULL).getPointer(), message, messageLen, secretKey));
    }

    @Override
    public boolean cryptoSignOpen(byte[] message, byte[] signedMessage, int signedMessageLen, byte[] publicKey) {
        BaseChecker.checkArrayLength("signedMessage", signedMessage, signedMessageLen);
        Sign.Checker.checkMessageLength(message, signedMessageLen);
        Sign.Checker.checkPublicKey(publicKey);
        return this.successful(this.getSodium().crypto_sign_open(message, new PointerByReference(Pointer.NULL).getPointer(), signedMessage, signedMessageLen, publicKey));
    }

    @Override
    public boolean cryptoSignDetached(byte[] signature, byte[] message, int messageLen, byte[] secretKey) {
        Sign.Checker.checkSignature(signature);
        BaseChecker.checkArrayLength("message", message, messageLen);
        Sign.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_sign_detached(signature, new PointerByReference(Pointer.NULL).getPointer(), message, messageLen, secretKey));
    }

    @Override
    public boolean cryptoSignVerifyDetached(byte[] signature, byte[] message, int messageLen, byte[] publicKey) {
        Sign.Checker.checkSignature(signature);
        BaseChecker.checkArrayLength("message", message, messageLen);
        Sign.Checker.checkPublicKey(publicKey);
        return this.successful(this.getSodium().crypto_sign_verify_detached(signature, message, messageLen, publicKey));
    }

    @Override
    public boolean convertPublicKeyEd25519ToCurve25519(byte[] curve, byte[] ed) {
        Sign.Checker.checkPublicKeyCurve25519(curve);
        Sign.Checker.checkPublicKeyEd25519(ed);
        return this.successful(this.getSodium().crypto_sign_ed25519_pk_to_curve25519(curve, ed));
    }

    @Override
    public boolean convertSecretKeyEd25519ToCurve25519(byte[] curve, byte[] ed) {
        Sign.Checker.checkSecretKeyCurve25519(curve);
        Sign.Checker.checkSecretKeyEd25519(ed);
        return this.successful(this.getSodium().crypto_sign_ed25519_sk_to_curve25519(curve, ed));
    }

    @Override
    public boolean cryptoSignEd25519SkToSeed(byte[] seed, byte[] ed) {
        Sign.Checker.checkSeed(seed);
        Sign.Checker.checkSecretKeyEd25519(ed);
        return this.successful(this.getSodium().crypto_sign_ed25519_sk_to_seed(seed, ed));
    }

    @Override
    public boolean cryptoSignEd25519SkToPk(byte[] publicKey, byte[] secretKey) {
        Sign.Checker.checkPublicKey(publicKey);
        Sign.Checker.checkSecretKey(secretKey);
        return this.successful(this.getSodium().crypto_sign_ed25519_sk_to_pk(publicKey, secretKey));
    }

    @Override
    public KeyPair cryptoSignKeypair() throws SodiumException {
        byte[] publicKey = new byte[32];
        byte[] secretKey = new byte[64];
        if (!this.cryptoSignKeypair(publicKey, secretKey)) {
            throw new SodiumException("Could not generate a signing keypair.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public KeyPair cryptoSignSeedKeypair(byte[] seed) throws SodiumException {
        byte[] publicKey = new byte[32];
        byte[] secretKey = new byte[64];
        if (!this.cryptoSignSeedKeypair(publicKey, secretKey, seed)) {
            throw new SodiumException("Could not generate a signing keypair with a seed.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secretKey));
    }

    @Override
    public KeyPair cryptoSignSecretKeyPair(Key secretKey) throws SodiumException {
        byte[] publicKey = new byte[32];
        byte[] secKeyBytes = secretKey.getAsBytes();
        if (!this.cryptoSignEd25519SkToPk(publicKey, secKeyBytes)) {
            throw new SodiumException("Could not extract public key.");
        }
        return new KeyPair(Key.fromBytes(publicKey), Key.fromBytes(secKeyBytes));
    }

    @Override
    public String cryptoSign(String message, String secretKey) throws SodiumException {
        byte[] secretKeyBytes;
        byte[] messageBytes = this.bytes(message);
        byte[] signedMessage = new byte[64 + messageBytes.length];
        boolean res = this.cryptoSign(signedMessage, messageBytes, messageBytes.length, secretKeyBytes = this.messageEncoder.decode(secretKey));
        if (!res) {
            throw new SodiumException("Could not sign your message.");
        }
        return this.messageEncoder.encode(signedMessage);
    }

    @Override
    public String cryptoSign(String message, Key secretKey) throws SodiumException {
        return this.cryptoSign(message, this.messageEncoder.encode(secretKey.getAsBytes()));
    }

    @Override
    public String cryptoSignOpen(String signedMessage, Key publicKey) {
        byte[] signedMessageBytes = this.messageEncoder.decode(signedMessage);
        Sign.Checker.checkSignedMessageLength(signedMessageBytes.length);
        byte[] messageBytes = new byte[signedMessageBytes.length - 64];
        byte[] publicKeyBytes = publicKey.getAsBytes();
        boolean res = this.cryptoSignOpen(messageBytes, signedMessageBytes, signedMessageBytes.length, publicKeyBytes);
        if (!res) {
            return null;
        }
        return this.str(messageBytes);
    }

    @Override
    public String cryptoSignDetached(String message, Key secretKey) throws SodiumException {
        byte[] skBytes;
        byte[] signatureBytes = new byte[64];
        byte[] messageBytes = this.bytes(message);
        if (!this.cryptoSignDetached(signatureBytes, messageBytes, messageBytes.length, skBytes = secretKey.getAsBytes())) {
            throw new SodiumException("Could not create a signature for your message in detached mode.");
        }
        return this.messageEncoder.encode(signatureBytes);
    }

    @Override
    public boolean cryptoSignVerifyDetached(String signature, String message, Key publicKey) {
        byte[] messageBytes = this.bytes(message);
        byte[] pkBytes = publicKey.getAsBytes();
        byte[] signatureBytes = this.messageEncoder.decode(signature);
        return this.cryptoSignVerifyDetached(signatureBytes, messageBytes, messageBytes.length, pkBytes);
    }

    @Override
    public KeyPair convertKeyPairEd25519ToCurve25519(KeyPair ed25519KeyPair) throws SodiumException {
        byte[] edPkBytes = ed25519KeyPair.getPublicKey().getAsBytes();
        byte[] edSkBytes = ed25519KeyPair.getSecretKey().getAsBytes();
        byte[] curvePkBytes = new byte[32];
        byte[] curveSkBytes = new byte[32];
        boolean pkSuccess = this.convertPublicKeyEd25519ToCurve25519(curvePkBytes, edPkBytes);
        boolean skSuccess = this.convertSecretKeyEd25519ToCurve25519(curveSkBytes, edSkBytes);
        if (!pkSuccess || !skSuccess) {
            throw new SodiumException("Could not convert this key pair.");
        }
        return new KeyPair(Key.fromBytes(curvePkBytes), Key.fromBytes(curveSkBytes));
    }

    @Override
    public byte[] cryptoSignEd25519SkToSeed(Key secretKey) throws SodiumException {
        byte[] seed = new byte[32];
        boolean res = this.cryptoSignEd25519SkToSeed(seed, secretKey.getAsBytes());
        if (!res) {
            throw new SodiumException("Could not convert this secret key.");
        }
        return seed;
    }

    @Override
    public void cryptoSecretStreamKeygen(byte[] key) {
        SecretStream.Checker.checkKey(key);
        this.getSodium().crypto_secretstream_xchacha20poly1305_keygen(key);
    }

    @Override
    public boolean cryptoSecretStreamInitPush(SecretStream.State state, byte[] header, byte[] key) {
        BaseChecker.requireNonNull("state", (Object)state);
        SecretStream.Checker.checkHeader(header);
        SecretStream.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_init_push(state, header, key));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, long[] cipherLen, byte[] message, int messageLen, byte tag) {
        BaseChecker.requireNonNull("state", (Object)state);
        SecretStream.Checker.checkPush(message, messageLen, cipher);
        BaseChecker.checkOptionalOutPointer("cipherLen", cipherLen);
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_push(state, cipher, cipherLen, message, messageLen, null, 0L, tag));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, byte[] message, int messageLen, byte tag) {
        BaseChecker.requireNonNull("state", (Object)state);
        SecretStream.Checker.checkPush(message, messageLen, cipher);
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_push(state, cipher, null, message, messageLen, null, 0L, tag));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, long[] cipherLen, byte[] message, int messageLen, byte[] additionalData, int additionalDataLen, byte tag) {
        BaseChecker.requireNonNull("state", (Object)state);
        SecretStream.Checker.checkPush(message, messageLen, cipher);
        BaseChecker.checkOptionalOutPointer("cipherLen", cipherLen);
        BaseChecker.checkOptionalArrayLength("additional data", additionalData, additionalDataLen);
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_push(state, cipher, cipherLen, message, messageLen, additionalData, additionalDataLen, tag));
    }

    @Override
    public boolean cryptoSecretStreamInitPull(SecretStream.State state, byte[] header, byte[] key) {
        BaseChecker.requireNonNull("state", (Object)state);
        SecretStream.Checker.checkHeader(header);
        SecretStream.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_init_pull(state, header, key));
    }

    @Override
    public boolean cryptoSecretStreamPull(SecretStream.State state, byte[] message, long[] messageLen, byte[] tag, byte[] cipher, int cipherLen, byte[] additionalData, int additionalDataLen) {
        BaseChecker.requireNonNull("state", (Object)state);
        SecretStream.Checker.checkPull(cipher, cipherLen, message);
        BaseChecker.checkOptionalOutPointer("messageLen", messageLen);
        BaseChecker.checkOptionalOutPointer("tag", tag);
        BaseChecker.checkOptionalArrayLength("additional data", additionalData, additionalDataLen);
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_pull(state, message, messageLen, tag, cipher, cipherLen, additionalData, additionalDataLen));
    }

    @Override
    public boolean cryptoSecretStreamPull(SecretStream.State state, byte[] message, byte[] tag, byte[] cipher, int cipherLen) {
        BaseChecker.requireNonNull("state", (Object)state);
        SecretStream.Checker.checkPull(cipher, cipherLen, message);
        BaseChecker.checkOptionalOutPointer("tag", tag);
        return this.successful(this.getSodium().crypto_secretstream_xchacha20poly1305_pull(state, message, null, tag, cipher, cipherLen, null, 0L));
    }

    @Override
    public Key cryptoSecretStreamKeygen() {
        byte[] key = this.randomBytesBuf(32);
        this.getSodium().crypto_secretstream_xchacha20poly1305_keygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public SecretStream.State cryptoSecretStreamInitPush(byte[] header, Key key) throws SodiumException {
        SecretStream.Checker.checkHeader(header);
        SecretStream.Checker.checkKey(key.getAsBytes());
        SecretStream.State.ByReference state = new SecretStream.State.ByReference();
        int res = this.getSodium().crypto_secretstream_xchacha20poly1305_init_push(state, header, key.getAsBytes());
        if (res != 0) {
            throw new SodiumException("Error initializing secret stream push.");
        }
        return state;
    }

    @Override
    public String cryptoSecretStreamPush(SecretStream.State state, String message, byte tag) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[17 + messageBytes.length];
        int res = this.getSodium().crypto_secretstream_xchacha20poly1305_push(state, cipher, null, messageBytes, messageBytes.length, null, 0L, tag);
        if (res != 0) {
            throw new SodiumException("Error when encrypting a message using secret stream.");
        }
        return this.messageEncoder.encode(cipher);
    }

    @Override
    public SecretStream.State cryptoSecretStreamInitPull(byte[] header, Key key) throws SodiumException {
        SecretStream.Checker.checkHeader(header);
        SecretStream.Checker.checkKey(key.getAsBytes());
        SecretStream.State.ByReference state = new SecretStream.State.ByReference();
        int res = this.getSodium().crypto_secretstream_xchacha20poly1305_init_pull(state, header, key.getAsBytes());
        if (res != 0) {
            throw new SodiumException("Could not initialise a decryption state.");
        }
        return state;
    }

    @Override
    public String cryptoSecretStreamPull(SecretStream.State state, String cipher, byte[] tag) throws SodiumException {
        byte[] cipherBytes = this.messageEncoder.decode(cipher);
        BaseChecker.checkAtLeast("cipherLength", cipherBytes.length, 17L);
        BaseChecker.checkOptionalOutPointer("tag", tag);
        byte[] message = new byte[cipherBytes.length - 17];
        int res = this.getSodium().crypto_secretstream_xchacha20poly1305_pull(state, message, null, tag, cipherBytes, cipherBytes.length, null, 0L);
        if (res != 0) {
            throw new SodiumException("Error when decrypting a message using secret stream.");
        }
        return this.str(message);
    }

    @Override
    public void cryptoSecretStreamRekey(SecretStream.State state) {
        BaseChecker.requireNonNull("state", (Object)state);
        this.getSodium().crypto_secretstream_xchacha20poly1305_rekey(state);
    }

    @Override
    public void cryptoStreamChaCha20Keygen(byte[] key) {
        Stream.Checker.checkChaCha20Key(key);
        this.getSodium().crypto_stream_chacha20_keygen(key);
    }

    @Override
    public boolean cryptoStreamChaCha20(byte[] c, int cLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("c", c, cLen);
        Stream.Checker.checkChaCha20Nonce(nonce);
        Stream.Checker.checkChaCha20Key(key);
        return this.successful(this.getSodium().crypto_stream_chacha20(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamChaCha20Xor(byte[] cipher, byte[] message, int messageLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher length", cipher.length, messageLen);
        Stream.Checker.checkChaCha20Nonce(nonce);
        Stream.Checker.checkChaCha20Key(key);
        return this.successful(this.getSodium().crypto_stream_chacha20_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamChaCha20XorIc(byte[] cipher, byte[] message, int messageLen, byte[] nonce, long ic, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher length", cipher.length, messageLen);
        Stream.Checker.checkChaCha20Nonce(nonce);
        Stream.Checker.checkChaCha20Key(key);
        return this.successful(this.getSodium().crypto_stream_chacha20_xor_ic(cipher, message, messageLen, nonce, ic, key));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoStreamChacha20XorIc(byte[] cipher, byte[] message, int messageLen, byte[] nonce, long ic, byte[] key) {
        return this.cryptoStreamChaCha20XorIc(cipher, message, messageLen, nonce, ic, key);
    }

    @Override
    public void cryptoStreamChaCha20IetfKeygen(byte[] key) {
        Stream.Checker.checkChaCha20IetfKey(key);
        this.getSodium().crypto_stream_chacha20_ietf_keygen(key);
    }

    @Override
    public boolean cryptoStreamChaCha20Ietf(byte[] c, int cLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("c", c, cLen);
        Stream.Checker.checkChaCha20IetfNonce(nonce);
        Stream.Checker.checkChaCha20IetfKey(key);
        return this.successful(this.getSodium().crypto_stream_chacha20_ietf(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamChaCha20IetfXor(byte[] cipher, byte[] message, int messageLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher length", cipher.length, messageLen);
        Stream.Checker.checkChaCha20IetfNonce(nonce);
        Stream.Checker.checkChaCha20IetfKey(key);
        return this.successful(this.getSodium().crypto_stream_chacha20_ietf_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamChaCha20IetfXorIc(byte[] cipher, byte[] message, int messageLen, byte[] nonce, long ic, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher length", cipher.length, messageLen);
        Stream.Checker.checkChaCha20IetfNonce(nonce);
        Stream.Checker.checkChaCha20IetfKey(key);
        return this.successful(this.getSodium().crypto_stream_chacha20_ietf_xor_ic(cipher, message, messageLen, nonce, ic, key));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoStreamChacha20IetfXorIc(byte[] cipher, byte[] message, int messageLen, byte[] nonce, long ic, byte[] key) {
        return this.cryptoStreamChaCha20IetfXorIc(cipher, message, messageLen, nonce, ic, key);
    }

    @Override
    public void cryptoStreamSalsa20Keygen(byte[] key) {
        Stream.Checker.checkSalsa20Key(key);
        this.getSodium().crypto_stream_salsa20_keygen(key);
    }

    @Override
    public boolean cryptoStreamSalsa20(byte[] c, int cLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("c", c, cLen);
        Stream.Checker.checkSalsa20Nonce(nonce);
        Stream.Checker.checkSalsa20Key(key);
        return this.successful(this.getSodium().crypto_stream_salsa20(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamSalsa20Xor(byte[] cipher, byte[] message, int messageLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher length", cipher.length, messageLen);
        Stream.Checker.checkSalsa20Nonce(nonce);
        Stream.Checker.checkSalsa20Key(key);
        return this.successful(this.getSodium().crypto_stream_salsa20_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamSalsa20XorIc(byte[] cipher, byte[] message, int messageLen, byte[] nonce, long ic, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher length", cipher.length, messageLen);
        Stream.Checker.checkSalsa20Nonce(nonce);
        Stream.Checker.checkSalsa20Key(key);
        return this.successful(this.getSodium().crypto_stream_salsa20_xor_ic(cipher, message, messageLen, nonce, ic, key));
    }

    @Override
    public void cryptoStreamXSalsa20Keygen(byte[] key) {
        Stream.Checker.checkXSalsa20Key(key);
        this.getSodium().crypto_stream_xsalsa20_keygen(key);
    }

    @Override
    public boolean cryptoStreamXSalsa20(byte[] c, int cLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("c", c, cLen);
        Stream.Checker.checkXSalsa20Nonce(nonce);
        Stream.Checker.checkXSalsa20Key(key);
        return this.successful(this.getSodium().crypto_stream_xsalsa20(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamXSalsa20Xor(byte[] cipher, byte[] message, int messageLen, byte[] nonce, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher length", cipher.length, messageLen);
        Stream.Checker.checkXSalsa20Nonce(nonce);
        Stream.Checker.checkXSalsa20Key(key);
        return this.successful(this.getSodium().crypto_stream_xsalsa20_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamXSalsa20XorIc(byte[] cipher, byte[] message, int messageLen, byte[] nonce, long ic, byte[] key) {
        BaseChecker.checkArrayLength("message", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher length", cipher.length, messageLen);
        Stream.Checker.checkXSalsa20Nonce(nonce);
        Stream.Checker.checkXSalsa20Key(key);
        return this.successful(this.getSodium().crypto_stream_xsalsa20_xor_ic(cipher, message, messageLen, nonce, ic, key));
    }

    @Override
    public Key cryptoStreamKeygen(Stream.Method method) {
        BaseChecker.requireNonNull("method", (Object)method);
        switch (method) {
            case CHACHA20: {
                byte[] k = new byte[32];
                this.cryptoStreamChaCha20Keygen(k);
                return Key.fromBytes(k);
            }
            case CHACHA20_IETF: {
                byte[] k = new byte[32];
                this.cryptoStreamChaCha20Keygen(k);
                return Key.fromBytes(k);
            }
            case SALSA20: {
                byte[] k = new byte[32];
                this.cryptoStreamSalsa20Keygen(k);
                return Key.fromBytes(k);
            }
            case XSALSA20: {
                byte[] k = new byte[32];
                this.cryptoStreamXSalsa20Keygen(k);
                return Key.fromBytes(k);
            }
        }
        throw new IllegalArgumentException("Unsupported stream cipher method " + method);
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public byte[] cryptoStream(byte[] nonce, Key key, Stream.Method method) {
        return this.cryptoStream(20, nonce, key, method);
    }

    @Override
    public byte[] cryptoStream(int bytes, byte[] nonce, Key key, Stream.Method method) {
        BaseChecker.requireNonNull("method", (Object)method);
        byte[] c = new byte[bytes];
        int cLen = c.length;
        switch (method) {
            case CHACHA20: {
                this.cryptoStreamChaCha20(c, cLen, nonce, key.getAsBytes());
                break;
            }
            case CHACHA20_IETF: {
                this.cryptoStreamChaCha20Ietf(c, cLen, nonce, key.getAsBytes());
                break;
            }
            case SALSA20: {
                this.cryptoStreamSalsa20(c, cLen, nonce, key.getAsBytes());
                break;
            }
            case XSALSA20: {
                this.cryptoStreamXSalsa20(c, cLen, nonce, key.getAsBytes());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported stream cipher method " + method);
            }
        }
        return c;
    }

    @Override
    public String cryptoStreamXor(String message, byte[] nonce, Key key, Stream.Method method) {
        byte[] mBytes = this.bytes(message);
        return this.messageEncoder.encode(this.cryptoStreamDefaultXor(mBytes, nonce, key, method));
    }

    @Override
    public String cryptoStreamXorDecrypt(String cipher, byte[] nonce, Key key, Stream.Method method) {
        return this.str(this.cryptoStreamDefaultXor(this.messageEncoder.decode(cipher), nonce, key, method));
    }

    @Override
    public String cryptoStreamXorIc(String message, byte[] nonce, long ic, Key key, Stream.Method method) {
        byte[] mBytes = this.bytes(message);
        return this.messageEncoder.encode(this.cryptoStreamDefaultXorIc(mBytes, nonce, ic, key, method));
    }

    @Override
    public String cryptoStreamXorIcDecrypt(String cipher, byte[] nonce, long ic, Key key, Stream.Method method) {
        byte[] cipherBytes = this.messageEncoder.decode(cipher);
        return this.str(this.cryptoStreamDefaultXorIc(cipherBytes, nonce, ic, key, method));
    }

    private byte[] cryptoStreamDefaultXor(byte[] messageBytes, byte[] nonce, Key key, Stream.Method method) {
        BaseChecker.requireNonNull("method", (Object)method);
        int mLen = messageBytes.length;
        byte[] cipher = new byte[mLen];
        switch (method) {
            case CHACHA20: {
                this.cryptoStreamChaCha20Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
                break;
            }
            case CHACHA20_IETF: {
                this.cryptoStreamChaCha20IetfXor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
                break;
            }
            case SALSA20: {
                this.cryptoStreamSalsa20Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
                break;
            }
            case XSALSA20: {
                this.cryptoStreamXSalsa20Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported stream cipher method " + method);
            }
        }
        return cipher;
    }

    private byte[] cryptoStreamDefaultXorIc(byte[] messageBytes, byte[] nonce, long ic, Key key, Stream.Method method) {
        BaseChecker.requireNonNull("method", (Object)method);
        int mLen = messageBytes.length;
        byte[] cipher = new byte[mLen];
        switch (method) {
            case CHACHA20: {
                this.cryptoStreamChaCha20XorIc(cipher, messageBytes, mLen, nonce, ic, key.getAsBytes());
                break;
            }
            case CHACHA20_IETF: {
                this.cryptoStreamChaCha20IetfXorIc(cipher, messageBytes, mLen, nonce, ic, key.getAsBytes());
                break;
            }
            case SALSA20: {
                this.cryptoStreamSalsa20XorIc(cipher, messageBytes, mLen, nonce, ic, key.getAsBytes());
                break;
            }
            case XSALSA20: {
                this.cryptoStreamXSalsa20XorIc(cipher, messageBytes, mLen, nonce, ic, key.getAsBytes());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported stream cipher method " + method);
            }
        }
        return cipher;
    }

    @Override
    public boolean cryptoAuth(byte[] tag, byte[] in, int inLen, byte[] key) {
        Auth.Checker.checkTag(tag);
        BaseChecker.checkArrayLength("in", in, inLen);
        Auth.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_auth(tag, in, inLen, key));
    }

    @Override
    public boolean cryptoAuthVerify(byte[] tag, byte[] in, int inLen, byte[] key) {
        Auth.Checker.checkTag(tag);
        BaseChecker.checkArrayLength("in", in, inLen);
        Auth.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_auth_verify(tag, in, inLen, key));
    }

    @Override
    public void cryptoAuthKeygen(byte[] k) {
        Auth.Checker.checkKey(k);
        this.getSodium().crypto_auth_keygen(k);
    }

    @Override
    public Key cryptoAuthKeygen() {
        byte[] key = this.randomBytesBuf(32);
        this.cryptoAuthKeygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public String cryptoAuth(String message, Key key) throws SodiumException {
        byte[] keyBytes;
        byte[] tag = new byte[32];
        byte[] messageBytes = this.bytes(message);
        boolean res = this.cryptoAuth(tag, messageBytes, messageBytes.length, keyBytes = key.getAsBytes());
        if (!res) {
            throw new SodiumException("Could not apply auth tag to your message.");
        }
        return this.messageEncoder.encode(tag);
    }

    @Override
    public boolean cryptoAuthVerify(String tag, String message, Key key) {
        byte[] tagToBytes = this.messageEncoder.decode(tag);
        byte[] messageBytes = this.bytes(message);
        byte[] keyBytes = key.getAsBytes();
        return this.cryptoAuthVerify(tagToBytes, messageBytes, messageBytes.length, keyBytes);
    }

    @Override
    public void cryptoAuthHMACSha256Keygen(byte[] key) {
        Auth.Checker.checkHMACSha256Key(key);
        this.getSodium().crypto_auth_hmacsha256_keygen(key);
    }

    @Override
    public boolean cryptoAuthHMACSha256(byte[] out, byte[] in, int inLen, byte[] k) {
        Auth.Checker.checkHMACSha256Tag(out);
        BaseChecker.checkArrayLength("in", in, inLen);
        Auth.Checker.checkHMACSha256Key(k);
        return this.successful(this.getSodium().crypto_auth_hmacsha256(out, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha256Verify(byte[] h, byte[] in, int inLen, byte[] k) {
        Auth.Checker.checkHMACSha256Tag(h);
        BaseChecker.checkArrayLength("in", in, inLen);
        Auth.Checker.checkHMACSha256Key(k);
        return this.successful(this.getSodium().crypto_auth_hmacsha256_verify(h, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha256Init(Auth.StateHMAC256 state, byte[] key, int keyLen) {
        BaseChecker.checkArrayLength("key", key, keyLen);
        return this.successful(this.getSodium().crypto_auth_hmacsha256_init(state, key, keyLen));
    }

    @Override
    public boolean cryptoAuthHMACSha256Update(Auth.StateHMAC256 state, byte[] in, int inLen) {
        BaseChecker.checkArrayLength("in", in, inLen);
        return this.successful(this.getSodium().crypto_auth_hmacsha256_update(state, in, inLen));
    }

    @Override
    public boolean cryptoAuthHMACSha256Final(Auth.StateHMAC256 state, byte[] out) {
        Auth.Checker.checkHMACSha256Tag(out);
        return this.successful(this.getSodium().crypto_auth_hmacsha256_final(state, out));
    }

    @Override
    public void cryptoAuthHMACSha512Keygen(byte[] key) {
        Auth.Checker.checkHMACSha512Key(key);
        this.getSodium().crypto_auth_hmacsha512_keygen(key);
    }

    @Override
    public boolean cryptoAuthHMACSha512(byte[] out, byte[] in, int inLen, byte[] k) {
        Auth.Checker.checkHMACSha512Tag(out);
        BaseChecker.checkArrayLength("in", in, inLen);
        Auth.Checker.checkHMACSha512Key(k);
        return this.successful(this.getSodium().crypto_auth_hmacsha512(out, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha512Verify(byte[] h, byte[] in, int inLen, byte[] k) {
        Auth.Checker.checkHMACSha512Tag(h);
        BaseChecker.checkArrayLength("in", in, inLen);
        Auth.Checker.checkHMACSha512Key(k);
        return this.successful(this.getSodium().crypto_auth_hmacsha512_verify(h, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha512Init(Auth.StateHMAC512 state, byte[] key, int keyLen) {
        BaseChecker.checkArrayLength("key", key, keyLen);
        return this.successful(this.getSodium().crypto_auth_hmacsha512_init(state, key, keyLen));
    }

    @Override
    public boolean cryptoAuthHMACSha512Update(Auth.StateHMAC512 state, byte[] in, int inLen) {
        BaseChecker.checkArrayLength("in", in, inLen);
        return this.successful(this.getSodium().crypto_auth_hmacsha512_update(state, in, inLen));
    }

    @Override
    public boolean cryptoAuthHMACSha512Final(Auth.StateHMAC512 state, byte[] out) {
        Auth.Checker.checkHMACSha512Tag(out);
        return this.successful(this.getSodium().crypto_auth_hmacsha512_final(state, out));
    }

    @Override
    public void cryptoAuthHMACSha512256Keygen(byte[] key) {
        Auth.Checker.checkHMACSha512256Key(key);
        this.getSodium().crypto_auth_hmacsha512256_keygen(key);
    }

    @Override
    public boolean cryptoAuthHMACSha512256(byte[] out, byte[] in, int inLen, byte[] k) {
        Auth.Checker.checkHMACSha512256Tag(out);
        BaseChecker.checkArrayLength("in", in, inLen);
        Auth.Checker.checkHMACSha512256Key(k);
        return this.successful(this.getSodium().crypto_auth_hmacsha512256(out, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha512256Verify(byte[] h, byte[] in, int inLen, byte[] k) {
        Auth.Checker.checkHMACSha512256Tag(h);
        BaseChecker.checkArrayLength("in", in, inLen);
        Auth.Checker.checkHMACSha512256Key(k);
        return this.successful(this.getSodium().crypto_auth_hmacsha512256_verify(h, in, inLen, k));
    }

    @Override
    public boolean cryptoAuthHMACSha512256Init(Auth.StateHMAC512256 state, byte[] key, int keyLen) {
        BaseChecker.checkArrayLength("key", key, keyLen);
        return this.successful(this.getSodium().crypto_auth_hmacsha512256_init(state, key, keyLen));
    }

    @Override
    public boolean cryptoAuthHMACSha512256Update(Auth.StateHMAC512256 state, byte[] in, int inLen) {
        BaseChecker.checkArrayLength("in", in, inLen);
        return this.successful(this.getSodium().crypto_auth_hmacsha512256_update(state, in, inLen));
    }

    @Override
    public boolean cryptoAuthHMACSha512256Final(Auth.StateHMAC512256 state, byte[] out) {
        Auth.Checker.checkHMACSha512256Tag(out);
        return this.successful(this.getSodium().crypto_auth_hmacsha512256_final(state, out));
    }

    @Override
    public Key cryptoAuthHMACShaKeygen(Auth.Type type) {
        BaseChecker.requireNonNull("type", (Object)type);
        switch (type) {
            case SHA256: {
                byte[] k = new byte[32];
                this.cryptoAuthHMACSha256Keygen(k);
                return Key.fromBytes(k);
            }
            case SHA512: {
                byte[] k = new byte[32];
                this.cryptoAuthHMACSha512Keygen(k);
                return Key.fromBytes(k);
            }
            case SHA512256: {
                byte[] k = new byte[32];
                this.cryptoAuthHMACSha512256Keygen(k);
                return Key.fromBytes(k);
            }
        }
        throw new IllegalArgumentException("Unsupported auth type " + type);
    }

    @Override
    public String cryptoAuthHMACSha(Auth.Type type, String in, Key key) {
        BaseChecker.requireNonNull("type", (Object)type);
        byte[] inBytes = this.bytes(in);
        byte[] keyBytes = key.getAsBytes();
        int inByteLen = inBytes.length;
        switch (type) {
            case SHA256: {
                byte[] out = new byte[32];
                this.cryptoAuthHMACSha256(out, inBytes, inByteLen, keyBytes);
                return this.messageEncoder.encode(out);
            }
            case SHA512: {
                byte[] out = new byte[64];
                this.cryptoAuthHMACSha512(out, inBytes, inByteLen, keyBytes);
                return this.messageEncoder.encode(out);
            }
            case SHA512256: {
                byte[] out = new byte[32];
                this.cryptoAuthHMACSha512256(out, inBytes, inByteLen, keyBytes);
                return this.messageEncoder.encode(out);
            }
        }
        throw new IllegalArgumentException("Unsupported auth type " + type);
    }

    @Override
    public boolean cryptoAuthHMACShaVerify(Auth.Type type, String h, String in, Key key) {
        BaseChecker.requireNonNull("type", (Object)type);
        byte[] authBytes = this.messageEncoder.decode(h);
        byte[] inBytes = this.bytes(in);
        byte[] keyBytes = key.getAsBytes();
        int inByteLen = inBytes.length;
        switch (type) {
            case SHA256: {
                return this.cryptoAuthHMACSha256Verify(authBytes, inBytes, inByteLen, keyBytes);
            }
            case SHA512: {
                return this.cryptoAuthHMACSha512Verify(authBytes, inBytes, inByteLen, keyBytes);
            }
            case SHA512256: {
                return this.cryptoAuthHMACSha512256Verify(authBytes, inBytes, inByteLen, keyBytes);
            }
        }
        throw new IllegalArgumentException("Unsupported auth type " + type);
    }

    @Override
    public boolean cryptoAuthHMACShaInit(Auth.StateHMAC256 state, Key key) {
        byte[] keyBytes = key.getAsBytes();
        return this.cryptoAuthHMACSha256Init(state, keyBytes, keyBytes.length);
    }

    @Override
    public boolean cryptoAuthHMACShaUpdate(Auth.StateHMAC256 state, String in) {
        byte[] inBytes = this.bytes(in);
        int inByteLen = inBytes.length;
        return this.cryptoAuthHMACSha256Update(state, inBytes, inByteLen);
    }

    @Override
    public String cryptoAuthHMACShaFinal(Auth.StateHMAC256 state) throws SodiumException {
        byte[] out = new byte[32];
        boolean res = this.cryptoAuthHMACSha256Final(state, out);
        if (!res) {
            throw new SodiumException("Could not finalise SHA Hash.");
        }
        return this.messageEncoder.encode(out);
    }

    @Override
    public boolean cryptoAuthHMACShaInit(Auth.StateHMAC512 state, Key key) {
        byte[] keyBytes = key.getAsBytes();
        return this.cryptoAuthHMACSha512Init(state, keyBytes, keyBytes.length);
    }

    @Override
    public boolean cryptoAuthHMACShaUpdate(Auth.StateHMAC512 state, String in) {
        byte[] inBytes = this.bytes(in);
        int inByteLen = inBytes.length;
        return this.cryptoAuthHMACSha512Update(state, inBytes, inByteLen);
    }

    @Override
    public String cryptoAuthHMACShaFinal(Auth.StateHMAC512 state) throws SodiumException {
        byte[] out = new byte[64];
        boolean res = this.cryptoAuthHMACSha512Final(state, out);
        if (!res) {
            throw new SodiumException("Could not finalise HMAC Sha 512.");
        }
        return this.messageEncoder.encode(out);
    }

    @Override
    public boolean cryptoAuthHMACShaInit(Auth.StateHMAC512256 state, Key key) {
        byte[] keyBytes = key.getAsBytes();
        return this.cryptoAuthHMACSha512256Init(state, keyBytes, keyBytes.length);
    }

    @Override
    public boolean cryptoAuthHMACShaUpdate(Auth.StateHMAC512256 state, String in) {
        byte[] inBytes = this.bytes(in);
        int inByteLen = inBytes.length;
        return this.cryptoAuthHMACSha512256Update(state, inBytes, inByteLen);
    }

    @Override
    public String cryptoAuthHMACShaFinal(Auth.StateHMAC512256 state) throws SodiumException {
        byte[] out = new byte[32];
        boolean res = this.cryptoAuthHMACSha512256Final(state, out);
        if (!res) {
            throw new SodiumException("Could not finalise HMAC Sha 512256.");
        }
        return this.messageEncoder.encode(out);
    }

    @Override
    public boolean cryptoShortHash(byte[] out, byte[] in, int inLen, byte[] key) {
        BaseChecker.checkArrayLength("in", in, inLen);
        ShortHash.Checker.checkHash(out);
        ShortHash.Checker.checkKey(key);
        return this.successful(this.getSodium().crypto_shorthash(out, in, inLen, key));
    }

    @Override
    public void cryptoShortHashKeygen(byte[] k) {
        ShortHash.Checker.checkKey(k);
        this.getSodium().crypto_shorthash_keygen(k);
    }

    @Override
    public String cryptoShortHash(byte[] inBytes, Key key) throws SodiumException {
        byte[] keyBytes = key.getAsBytes();
        ShortHash.Checker.checkKey(keyBytes);
        byte[] out = new byte[8];
        if (this.getSodium().crypto_shorthash(out, inBytes, inBytes.length, keyBytes) != 0) {
            throw new SodiumException("Failed short-input hashing.");
        }
        return this.sodiumBin2Hex(out);
    }

    @Override
    public String cryptoShortHashStr(String in, Key key) throws SodiumException {
        return this.cryptoShortHash(this.bytes(in), key);
    }

    @Override
    public String cryptoShortHashHex(String hexIn, Key key) throws SodiumException {
        return this.cryptoShortHash(LazySodium.hexToBytes(hexIn), key);
    }

    @Override
    public Key cryptoShortHashKeygen() {
        byte[] key = this.randomBytesBuf(16);
        this.getSodium().crypto_shorthash_keygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public boolean cryptoGenericHash(byte[] out, int outLen, byte[] in, int inLen, byte[] key, int keyLen) {
        BaseChecker.checkArrayLength("out", out, outLen);
        GenericHash.Checker.checkOutputLength(outLen);
        BaseChecker.checkArrayLength("in", in, inLen);
        GenericHash.Checker.checkKey(key, keyLen);
        return this.successful(this.getSodium().crypto_generichash(out, outLen, in, inLen, key, keyLen));
    }

    @Override
    public boolean cryptoGenericHash(byte[] out, int outLen, byte[] in, int inLen) {
        return this.cryptoGenericHash(out, outLen, in, inLen, null, 0);
    }

    @Override
    public boolean cryptoGenericHashInit(GenericHash.State state, byte[] key, int keyLength, int outLen) {
        GenericHash.Checker.checkKey(key, keyLength);
        GenericHash.Checker.checkOutputLength(outLen);
        return this.successful(this.getSodium().crypto_generichash_init(state.getPointer(), key, keyLength, outLen));
    }

    @Override
    public boolean cryptoGenericHashInit(GenericHash.State state, int outLen) {
        return this.cryptoGenericHashInit(state, null, 0, outLen);
    }

    @Override
    public boolean cryptoGenericHashUpdate(GenericHash.State state, byte[] in, int inLen) {
        BaseChecker.checkArrayLength("in", in, inLen);
        return this.successful(this.getSodium().crypto_generichash_update(state.getPointer(), in, inLen));
    }

    @Override
    public boolean cryptoGenericHashFinal(GenericHash.State state, byte[] out, int outLen) {
        BaseChecker.checkArrayLength("out", out, outLen);
        GenericHash.Checker.checkOutputLength(outLen);
        return this.successful(this.getSodium().crypto_generichash_final(state.getPointer(), out, outLen));
    }

    @Override
    public void cryptoGenericHashKeygen(byte[] k) {
        GenericHash.Checker.checkKey(k);
        this.getSodium().crypto_generichash_keygen(k);
    }

    @Override
    public Key cryptoGenericHashKeygen() {
        byte[] key = new byte[32];
        this.cryptoGenericHashKeygen(key);
        return Key.fromBytes(key);
    }

    @Override
    public Key cryptoGenericHashKeygen(int size) {
        return Key.generate(this, size);
    }

    @Override
    public String cryptoGenericHash(String in, Key key) throws SodiumException {
        byte[] keyBytes;
        byte[] hash = new byte[32];
        byte[] message = this.bytes(in);
        boolean res = this.cryptoGenericHash(hash, hash.length, message, message.length, keyBytes = key == null ? null : key.getAsBytes(), keyBytes == null ? 0 : keyBytes.length);
        if (!res) {
            throw new SodiumException("Could not hash the message.");
        }
        return this.messageEncoder.encode(hash);
    }

    @Override
    public String cryptoGenericHash(String in) throws SodiumException {
        return this.cryptoGenericHash(in, null);
    }

    @Override
    public boolean cryptoGenericHashInit(GenericHash.State state, Key key, int outLen) {
        byte[] keyBytes = key == null ? null : key.getAsBytes();
        return this.cryptoGenericHashInit(state, keyBytes, keyBytes == null ? 0 : keyBytes.length, outLen);
    }

    @Override
    public boolean cryptoGenericHashUpdate(GenericHash.State state, String in) {
        byte[] inBytes = this.bytes(in);
        return this.cryptoGenericHashUpdate(state, inBytes, inBytes.length);
    }

    @Override
    public String cryptoGenericHashFinal(GenericHash.State state, int outLen) throws SodiumException {
        byte[] hash = new byte[outLen];
        boolean res = this.cryptoGenericHashFinal(state, hash, hash.length);
        if (!res) {
            throw new SodiumException("Could not finalise the hashing process.");
        }
        return this.messageEncoder.encode(hash);
    }

    @Override
    public void cryptoAeadChaCha20Poly1305Keygen(byte[] key) {
        AEAD.Checker.checkChaCha20Poly1305Key(key);
        this.getSodium().crypto_aead_chacha20poly1305_keygen(key);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305Encrypt(byte[] c, long[] cLen, byte[] m, int mLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("mLen", m, mLen);
        AEAD.Checker.checkChaCha20Poly1305CipherLength(c, mLen, cLen != null);
        BaseChecker.checkOptionalOutPointer("cLen", cLen);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkChaCha20Poly1305Nonce(nPub);
        AEAD.Checker.checkChaCha20Poly1305Key(k);
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_encrypt(c, cLen, m, mLen, ad, adLen, null, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadChaCha20Poly1305Encrypt(byte[] c, long[] cLen, byte[] m, int mLen, byte[] ad, int adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.cryptoAeadChaCha20Poly1305Encrypt(c, cLen, m, mLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305Decrypt(byte[] m, long[] mLen, byte[] c, int cLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("cLen", c, cLen);
        AEAD.Checker.checkChaCha20Poly1305DecryptedMessageLength(m, cLen, mLen != null);
        BaseChecker.checkOptionalOutPointer("mLen", mLen);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkChaCha20Poly1305Nonce(nPub);
        AEAD.Checker.checkChaCha20Poly1305Key(k);
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_decrypt(m, mLen, null, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadChaCha20Poly1305Decrypt(byte[] m, long[] mLen, byte[] nSec, byte[] c, int cLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        return this.cryptoAeadChaCha20Poly1305Decrypt(m, mLen, c, cLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305EncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, int mLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("mLen", m, mLen);
        BaseChecker.checkExpectedMemorySize("c", c.length, mLen);
        AEAD.Checker.checkChaCha20Poly1305Mac(mac, macLenAddress != null);
        BaseChecker.checkOptionalOutPointer("macLenAddress", macLenAddress);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkChaCha20Poly1305Nonce(nPub);
        AEAD.Checker.checkChaCha20Poly1305Key(k);
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, null, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadChaCha20Poly1305EncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, int mLen, byte[] ad, int adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.cryptoAeadChaCha20Poly1305EncryptDetached(c, mac, macLenAddress, m, mLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305DecryptDetached(byte[] m, byte[] c, int cLen, byte[] mac, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("cLen", c, cLen);
        BaseChecker.checkExpectedMemorySize("m", m.length, cLen);
        AEAD.Checker.checkChaCha20Poly1305Mac(mac, false);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkChaCha20Poly1305Nonce(nPub);
        AEAD.Checker.checkChaCha20Poly1305Key(k);
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_decrypt_detached(m, null, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadChaCha20Poly1305DecryptDetached(byte[] m, byte[] nSec, byte[] c, int cLen, byte[] mac, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        return this.cryptoAeadChaCha20Poly1305DecryptDetached(m, c, cLen, mac, ad, adLen, nPub, k);
    }

    @Override
    public void cryptoAeadChaCha20Poly1305IetfKeygen(byte[] key) {
        AEAD.Checker.checkChaCha20Poly1305IetfKey(key);
        this.getSodium().crypto_aead_chacha20poly1305_ietf_keygen(key);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfEncrypt(byte[] c, long[] cLen, byte[] m, int mLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("mLen", m, mLen);
        AEAD.Checker.checkChaCha20Poly1305IetfCipherLength(c, mLen, cLen != null);
        BaseChecker.checkOptionalOutPointer("cLen", cLen);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkChaCha20Poly1305IetfNonce(nPub);
        AEAD.Checker.checkChaCha20Poly1305IetfKey(k);
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_ietf_encrypt(c, cLen, m, mLen, ad, adLen, null, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadChaCha20Poly1305IetfEncrypt(byte[] c, long[] cLen, byte[] m, int mLen, byte[] ad, int adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.cryptoAeadChaCha20Poly1305IetfEncrypt(c, cLen, m, mLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfDecrypt(byte[] m, long[] mLen, byte[] c, int cLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("cLen", c, cLen);
        AEAD.Checker.checkChaCha20Poly1305IetfDecryptedMessageLength(m, cLen, mLen != null);
        BaseChecker.checkOptionalOutPointer("mLen", mLen);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkChaCha20Poly1305IetfNonce(nPub);
        AEAD.Checker.checkChaCha20Poly1305IetfKey(k);
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_ietf_decrypt(m, mLen, null, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadChaCha20Poly1305IetfDecrypt(byte[] m, long[] mLen, byte[] nSec, byte[] c, int cLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        return this.cryptoAeadChaCha20Poly1305IetfDecrypt(m, mLen, c, cLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfEncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, int mLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("mLen", m, mLen);
        BaseChecker.checkExpectedMemorySize("c", c.length, mLen);
        AEAD.Checker.checkChaCha20Poly1305IetfMac(mac, macLenAddress != null);
        BaseChecker.checkOptionalOutPointer("macLenAddress", macLenAddress);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkChaCha20Poly1305IetfNonce(nPub);
        AEAD.Checker.checkChaCha20Poly1305IetfKey(k);
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_ietf_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, null, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadChaCha20Poly1305IetfEncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, int mLen, byte[] ad, int adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.cryptoAeadChaCha20Poly1305IetfEncryptDetached(c, mac, macLenAddress, m, mLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfDecryptDetached(byte[] m, byte[] c, int cLen, byte[] mac, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("cLen", c, cLen);
        BaseChecker.checkExpectedMemorySize("m", m.length, cLen);
        AEAD.Checker.checkChaCha20Poly1305IetfMac(mac, false);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkChaCha20Poly1305IetfNonce(nPub);
        AEAD.Checker.checkChaCha20Poly1305IetfKey(k);
        return this.successful(this.getSodium().crypto_aead_chacha20poly1305_ietf_decrypt_detached(m, null, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadChaCha20Poly1305IetfDecryptDetached(byte[] m, byte[] nSec, byte[] c, int cLen, byte[] mac, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        return this.cryptoAeadChaCha20Poly1305IetfDecryptDetached(m, c, cLen, mac, ad, adLen, nPub, k);
    }

    @Override
    public void cryptoAeadXChaCha20Poly1305IetfKeygen(byte[] k) {
        AEAD.Checker.checkXChaCha20Poly1305IetfKey(k);
        this.getSodium().crypto_aead_xchacha20poly1305_ietf_keygen(k);
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfEncrypt(byte[] c, long[] cLen, byte[] m, int mLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("mLen", m, mLen);
        AEAD.Checker.checkXChaCha20Poly1305IetfCipherLength(c, mLen, cLen != null);
        BaseChecker.checkOptionalOutPointer("cLen", cLen);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkXChaCha20Poly1305IetfNonce(nPub);
        AEAD.Checker.checkXChaCha20Poly1305IetfKey(k);
        return this.successful(this.getSodium().crypto_aead_xchacha20poly1305_ietf_encrypt(c, cLen, m, mLen, ad, adLen, null, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadXChaCha20Poly1305IetfEncrypt(byte[] c, long[] cLen, byte[] m, int mLen, byte[] ad, int adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.cryptoAeadXChaCha20Poly1305IetfEncrypt(c, cLen, m, mLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfDecrypt(byte[] m, long[] mLen, byte[] c, int cLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("cLen", c, cLen);
        AEAD.Checker.checkXChaCha20Poly1305IetfDecryptedMessageLength(m, cLen, mLen != null);
        BaseChecker.checkOptionalOutPointer("mLen", mLen);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkXChaCha20Poly1305IetfNonce(nPub);
        AEAD.Checker.checkXChaCha20Poly1305IetfKey(k);
        return this.successful(this.getSodium().crypto_aead_xchacha20poly1305_ietf_decrypt(m, mLen, null, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadXChaCha20Poly1305IetfDecrypt(byte[] m, long[] mLen, byte[] nSec, byte[] c, int cLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        return this.cryptoAeadXChaCha20Poly1305IetfDecrypt(m, mLen, c, cLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfEncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, int mLen, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("mLen", m, mLen);
        BaseChecker.checkExpectedMemorySize("c", c.length, mLen);
        AEAD.Checker.checkXChaCha20Poly1305IetfMac(mac, macLenAddress != null);
        BaseChecker.checkOptionalOutPointer("macLenAddress", macLenAddress);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkXChaCha20Poly1305IetfNonce(nPub);
        AEAD.Checker.checkXChaCha20Poly1305IetfKey(k);
        return this.successful(this.getSodium().crypto_aead_xchacha20poly1305_ietf_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, null, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadXChaCha20Poly1305IetfEncryptDetached(byte[] c, byte[] mac, long[] macLenAddress, byte[] m, int mLen, byte[] ad, int adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.cryptoAeadXChaCha20Poly1305IetfEncryptDetached(c, mac, macLenAddress, m, mLen, ad, adLen, nPub, k);
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfDecryptDetached(byte[] m, byte[] c, int cLen, byte[] mac, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        BaseChecker.checkArrayLength("cLen", c, cLen);
        BaseChecker.checkExpectedMemorySize("m", m.length, cLen);
        AEAD.Checker.checkXChaCha20Poly1305IetfMac(mac, false);
        BaseChecker.checkOptionalArrayLength("ad", ad, adLen);
        AEAD.Checker.checkXChaCha20Poly1305IetfNonce(nPub);
        AEAD.Checker.checkXChaCha20Poly1305IetfKey(k);
        return this.successful(this.getSodium().crypto_aead_xchacha20poly1305_ietf_decrypt_detached(m, null, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadXChaCha20Poly1305IetfDecryptDetached(byte[] m, byte[] nSec, byte[] c, int cLen, byte[] mac, byte[] ad, int adLen, byte[] nPub, byte[] k) {
        return this.cryptoAeadXChaCha20Poly1305IetfDecryptDetached(m, c, cLen, mac, ad, adLen, nPub, k);
    }

    @Override
    public void cryptoAeadAES256GCMKeygen(byte[] key) {
        AEAD.Checker.checkAes256GcmKey(key);
        this.getSodium().crypto_aead_aes256gcm_keygen(key);
    }

    @Override
    public boolean cryptoAeadAES256GCMEncrypt(byte[] cipher, long[] cipherLen, byte[] message, int messageLen, byte[] additionalData, int additionalDataLen, byte[] nPub, byte[] key) {
        BaseChecker.checkArrayLength("messageLen", message, messageLen);
        AEAD.Checker.checkAes256GcmCipherLength(cipher, messageLen, cipherLen != null);
        BaseChecker.checkOptionalOutPointer("cipherLen", cipherLen);
        BaseChecker.checkOptionalArrayLength("additionalDataLen", additionalData, additionalDataLen);
        AEAD.Checker.checkAes256GcmNonce(nPub);
        AEAD.Checker.checkAes256GcmKey(key);
        return this.successful(this.getSodium().crypto_aead_aes256gcm_encrypt(cipher, cipherLen, message, messageLen, additionalData, additionalDataLen, null, nPub, key));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadAES256GCMEncrypt(byte[] cipher, long[] cipherLen, byte[] message, int messageLen, byte[] additionalData, int additionalDataLen, byte[] nSec, byte[] nPub, byte[] key) {
        return this.cryptoAeadAES256GCMEncrypt(cipher, cipherLen, message, messageLen, additionalData, additionalDataLen, nPub, key);
    }

    @Override
    public boolean cryptoAeadAES256GCMDecrypt(byte[] message, long[] messageLen, byte[] cipher, int cipherLen, byte[] additionalData, int additionalDataLen, byte[] nPub, byte[] key) {
        BaseChecker.checkArrayLength("cipherLen", cipher, cipherLen);
        AEAD.Checker.checkAes256GcmDecryptedMessageLength(message, cipherLen, messageLen != null);
        BaseChecker.checkOptionalOutPointer("messageLen", messageLen);
        BaseChecker.checkOptionalArrayLength("additionalData", additionalData, additionalDataLen);
        AEAD.Checker.checkAes256GcmNonce(nPub);
        AEAD.Checker.checkAes256GcmKey(key);
        return this.successful(this.getSodium().crypto_aead_aes256gcm_decrypt(message, messageLen, null, cipher, cipherLen, additionalData, additionalDataLen, nPub, key));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadAES256GCMDecrypt(byte[] message, long[] messageLen, byte[] nSec, byte[] cipher, int cipherLen, byte[] additionalData, int additionalDataLen, byte[] nPub, byte[] key) {
        return this.cryptoAeadAES256GCMDecrypt(message, messageLen, cipher, cipherLen, additionalData, additionalDataLen, nPub, key);
    }

    @Override
    public boolean cryptoAeadAES256GCMEncryptDetached(byte[] cipher, byte[] mac, long[] macLenAddress, byte[] message, int messageLen, byte[] additionalData, int additionalDataLen, byte[] nPub, byte[] key) {
        BaseChecker.checkArrayLength("messageLen", message, messageLen);
        BaseChecker.checkExpectedMemorySize("cipher", cipher.length, messageLen);
        AEAD.Checker.checkAes256GcmMac(mac, macLenAddress != null);
        BaseChecker.checkOptionalOutPointer("macLenAddress", macLenAddress);
        BaseChecker.checkOptionalArrayLength("additionalDataLen", additionalData, additionalDataLen);
        AEAD.Checker.checkAes256GcmNonce(nPub);
        AEAD.Checker.checkAes256GcmKey(key);
        return this.successful(this.getSodium().crypto_aead_aes256gcm_encrypt_detached(cipher, mac, macLenAddress, message, messageLen, additionalData, additionalDataLen, null, nPub, key));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadAES256GCMEncryptDetached(byte[] cipher, byte[] mac, long[] macLenAddress, byte[] message, int messageLen, byte[] additionalData, int additionalDataLen, byte[] nSec, byte[] nPub, byte[] key) {
        return this.cryptoAeadAES256GCMEncryptDetached(cipher, mac, macLenAddress, message, messageLen, additionalData, additionalDataLen, nPub, key);
    }

    @Override
    public boolean cryptoAeadAES256GCMDecryptDetached(byte[] message, byte[] cipher, int cipherLen, byte[] mac, byte[] additionalData, int additionalDataLen, byte[] nPub, byte[] key) {
        BaseChecker.checkArrayLength("cipherLen", cipher, cipherLen);
        BaseChecker.checkExpectedMemorySize("message", message.length, cipherLen);
        AEAD.Checker.checkAes256GcmMac(mac, false);
        BaseChecker.checkOptionalArrayLength("additionalData", additionalData, additionalDataLen);
        AEAD.Checker.checkAes256GcmNonce(nPub);
        AEAD.Checker.checkAes256GcmKey(key);
        return this.successful(this.getSodium().crypto_aead_aes256gcm_decrypt_detached(message, null, cipher, cipherLen, mac, additionalData, additionalDataLen, nPub, key));
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public boolean cryptoAeadAES256GCMDecryptDetached(byte[] message, byte[] nSec, byte[] cipher, int cipherLen, byte[] mac, byte[] additionalData, int additionalDataLen, byte[] nPub, byte[] key) {
        return this.cryptoAeadAES256GCMDecryptDetached(message, cipher, cipherLen, mac, additionalData, additionalDataLen, nPub, key);
    }

    @Override
    public boolean cryptoAeadAES256GCMIsAvailable() {
        return this.getSodium().crypto_aead_aes256gcm_is_available() == 1;
    }

    @Override
    public Key keygen(AEAD.Method method) {
        switch (method) {
            case CHACHA20_POLY1305: {
                byte[] key = this.randomBytesBuf(32);
                this.cryptoAeadChaCha20Poly1305Keygen(key);
                return Key.fromBytes(key);
            }
            case CHACHA20_POLY1305_IETF: {
                byte[] key2 = this.randomBytesBuf(32);
                this.cryptoAeadChaCha20Poly1305IetfKeygen(key2);
                return Key.fromBytes(key2);
            }
            case XCHACHA20_POLY1305_IETF: {
                byte[] key3 = this.randomBytesBuf(32);
                this.cryptoAeadXChaCha20Poly1305IetfKeygen(key3);
                return Key.fromBytes(key3);
            }
            case AES256GCM: {
                byte[] key4 = this.randomBytesBuf(32);
                this.cryptoAeadAES256GCMKeygen(key4);
                return Key.fromBytes(key4);
            }
        }
        return null;
    }

    @Override
    public String encrypt(String m, String additionalData, byte[] nPub, Key k, AEAD.Method method) {
        BaseChecker.requireNonNull("method", (Object)method);
        byte[] messageBytes = this.bytes(m);
        byte[] additionalDataBytes = additionalData == null ? null : this.bytes(additionalData);
        int additionalBytesLen = additionalData == null ? 0 : additionalDataBytes.length;
        byte[] keyBytes = k.getAsBytes();
        switch (method) {
            case CHACHA20_POLY1305: {
                byte[] cipherBytes = new byte[messageBytes.length + 16];
                this.cryptoAeadChaCha20Poly1305Encrypt(cipherBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
                return this.messageEncoder.encode(cipherBytes);
            }
            case CHACHA20_POLY1305_IETF: {
                byte[] cipherBytes = new byte[messageBytes.length + 16];
                this.cryptoAeadChaCha20Poly1305IetfEncrypt(cipherBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
                return this.messageEncoder.encode(cipherBytes);
            }
            case XCHACHA20_POLY1305_IETF: {
                byte[] cipherBytes = new byte[messageBytes.length + 16];
                this.cryptoAeadXChaCha20Poly1305IetfEncrypt(cipherBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
                return this.messageEncoder.encode(cipherBytes);
            }
            case AES256GCM: {
                byte[] cipherBytes = new byte[messageBytes.length + 16];
                this.cryptoAeadAES256GCMEncrypt(cipherBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
                return this.messageEncoder.encode(cipherBytes);
            }
        }
        throw new IllegalArgumentException("Unsupported AEAD method: " + method);
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public String encrypt(String m, String additionalData, byte[] nSec, byte[] nPub, Key k, AEAD.Method method) {
        return this.encrypt(m, additionalData, nPub, k, method);
    }

    @Override
    public String decrypt(String cipher, String additionalData, byte[] nPub, Key k, AEAD.Method method) throws AEADBadTagException {
        BaseChecker.requireNonNull("method", (Object)method);
        byte[] cipherBytes = this.messageEncoder.decode(cipher);
        byte[] additionalDataBytes = additionalData == null ? null : this.bytes(additionalData);
        int additionalBytesLen = additionalData == null ? 0 : additionalDataBytes.length;
        byte[] keyBytes = k.getAsBytes();
        switch (method) {
            case CHACHA20_POLY1305: {
                byte[] messageBytes = new byte[cipherBytes.length - 16];
                if (!this.cryptoAeadChaCha20Poly1305Decrypt(messageBytes, null, cipherBytes, cipherBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes)) {
                    throw new AEADBadTagException();
                }
                return this.str(messageBytes);
            }
            case CHACHA20_POLY1305_IETF: {
                byte[] messageBytes = new byte[cipherBytes.length - 16];
                if (!this.cryptoAeadChaCha20Poly1305IetfDecrypt(messageBytes, null, cipherBytes, cipherBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes)) {
                    throw new AEADBadTagException();
                }
                return this.str(messageBytes);
            }
            case XCHACHA20_POLY1305_IETF: {
                byte[] messageBytes = new byte[cipherBytes.length - 16];
                if (!this.cryptoAeadXChaCha20Poly1305IetfDecrypt(messageBytes, null, cipherBytes, cipherBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes)) {
                    throw new AEADBadTagException();
                }
                return this.str(messageBytes);
            }
            case AES256GCM: {
                byte[] messageBytes = new byte[cipherBytes.length - 16];
                if (!this.cryptoAeadAES256GCMDecrypt(messageBytes, null, cipherBytes, cipherBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes)) {
                    throw new AEADBadTagException();
                }
                return this.str(messageBytes);
            }
        }
        throw new IllegalArgumentException("Unsupported AEAD method: " + method);
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public String decrypt(String cipher, String additionalData, byte[] nSec, byte[] nPub, Key k, AEAD.Method method) throws AEADBadTagException {
        return this.decrypt(cipher, additionalData, nPub, k, method);
    }

    @Override
    public DetachedEncrypt encryptDetached(String m, String additionalData, byte[] nPub, Key k, AEAD.Method method) {
        BaseChecker.requireNonNull("method", (Object)method);
        byte[] messageBytes = this.bytes(m);
        byte[] additionalDataBytes = additionalData == null ? null : this.bytes(additionalData);
        int additionalBytesLen = additionalData == null ? 0 : additionalDataBytes.length;
        byte[] keyBytes = k.getAsBytes();
        byte[] cipherBytes = new byte[messageBytes.length];
        switch (method) {
            case CHACHA20_POLY1305: {
                byte[] macBytes = new byte[16];
                this.cryptoAeadChaCha20Poly1305EncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
                return new DetachedEncrypt(cipherBytes, macBytes);
            }
            case CHACHA20_POLY1305_IETF: {
                byte[] macBytes = new byte[16];
                this.cryptoAeadChaCha20Poly1305IetfEncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
                return new DetachedEncrypt(cipherBytes, macBytes);
            }
            case XCHACHA20_POLY1305_IETF: {
                byte[] macBytes = new byte[16];
                this.cryptoAeadXChaCha20Poly1305IetfEncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
                return new DetachedEncrypt(cipherBytes, macBytes);
            }
            case AES256GCM: {
                byte[] macBytes = new byte[16];
                this.cryptoAeadAES256GCMEncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalBytesLen, nPub, keyBytes);
                return new DetachedEncrypt(cipherBytes, macBytes);
            }
        }
        throw new IllegalArgumentException("Unsupported AEAD method: " + method);
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public DetachedEncrypt encryptDetached(String m, String additionalData, byte[] nSec, byte[] nPub, Key k, AEAD.Method method) {
        return this.encryptDetached(m, additionalData, nPub, k, method);
    }

    @Override
    public DetachedDecrypt decryptDetached(DetachedEncrypt detachedEncrypt, String additionalData, byte[] nPub, Key k, AEAD.Method method) throws AEADBadTagException {
        byte[] cipherBytes = detachedEncrypt.getCipher();
        byte[] additionalDataBytes = additionalData == null ? null : this.bytes(additionalData);
        int additionalBytesLen = additionalData == null ? 0 : additionalDataBytes.length;
        byte[] keyBytes = k.getAsBytes();
        byte[] messageBytes = new byte[cipherBytes.length];
        byte[] macBytes = detachedEncrypt.getMac();
        switch (method) {
            case CHACHA20_POLY1305: {
                if (!this.cryptoAeadChaCha20Poly1305DecryptDetached(messageBytes, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalBytesLen, nPub, keyBytes)) {
                    throw new AEADBadTagException();
                }
                return new DetachedDecrypt(messageBytes, macBytes, this.charset);
            }
            case CHACHA20_POLY1305_IETF: {
                if (!this.cryptoAeadChaCha20Poly1305IetfDecryptDetached(messageBytes, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalBytesLen, nPub, keyBytes)) {
                    throw new AEADBadTagException();
                }
                return new DetachedDecrypt(messageBytes, macBytes, this.charset);
            }
            case XCHACHA20_POLY1305_IETF: {
                if (!this.cryptoAeadXChaCha20Poly1305IetfDecryptDetached(messageBytes, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalBytesLen, nPub, keyBytes)) {
                    throw new AEADBadTagException();
                }
                return new DetachedDecrypt(messageBytes, macBytes, this.charset);
            }
            case AES256GCM: {
                if (!this.cryptoAeadAES256GCMDecryptDetached(messageBytes, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalBytesLen, nPub, keyBytes)) {
                    throw new AEADBadTagException();
                }
                return new DetachedDecrypt(messageBytes, macBytes, this.charset);
            }
        }
        throw new IllegalArgumentException("Unsupported AEAD method: " + method);
    }

    @Override
    @Deprecated(forRemoval=true, since="6.0.0")
    public DetachedDecrypt decryptDetached(DetachedEncrypt detachedEncrypt, String additionalData, byte[] nSec, byte[] nPub, Key k, AEAD.Method method) throws AEADBadTagException {
        return this.decryptDetached(detachedEncrypt, additionalData, nPub, k, method);
    }

    @Override
    public boolean cryptoCoreRistretto255IsValidPoint(byte[] point) {
        return point.length == 32 && this.getSodium().crypto_core_ristretto255_is_valid_point(point) == 1;
    }

    @Override
    public void cryptoCoreRistretto255Random(byte[] point) {
        Ristretto255.Checker.checkPoint("point", point);
        this.getSodium().crypto_core_ristretto255_random(point);
    }

    @Override
    public boolean cryptoCoreRistretto255FromHash(byte[] point, byte[] hash) {
        Ristretto255.Checker.checkPoint("point", point);
        Ristretto255.Checker.checkHash("hash", hash);
        return this.successful(this.getSodium().crypto_core_ristretto255_from_hash(point, hash));
    }

    @Override
    public boolean cryptoScalarmultRistretto255(byte[] result, byte[] n, byte[] point) {
        Ristretto255.Checker.checkPoint("result", result);
        Ristretto255.Checker.checkScalar("n", n);
        Ristretto255.Checker.checkPoint("point", point);
        return this.successful(this.getSodium().crypto_scalarmult_ristretto255(result, n, point));
    }

    @Override
    public boolean cryptoScalarmultRistretto255Base(byte[] result, byte[] n) {
        Ristretto255.Checker.checkPoint("result", result);
        Ristretto255.Checker.checkScalar("n", n);
        return this.successful(this.getSodium().crypto_scalarmult_ristretto255_base(result, n));
    }

    @Override
    public boolean cryptoCoreRistretto255Add(byte[] result, byte[] p, byte[] q) {
        Ristretto255.Checker.checkPoint("result", result);
        Ristretto255.Checker.checkPoint("p", p);
        Ristretto255.Checker.checkPoint("q", q);
        return this.successful(this.getSodium().crypto_core_ristretto255_add(result, p, q));
    }

    @Override
    public boolean cryptoCoreRistretto255Sub(byte[] result, byte[] p, byte[] q) {
        Ristretto255.Checker.checkPoint("result", result);
        Ristretto255.Checker.checkPoint("p", p);
        Ristretto255.Checker.checkPoint("q", q);
        return this.successful(this.getSodium().crypto_core_ristretto255_sub(result, p, q));
    }

    @Override
    public void cryptoCoreRistretto255ScalarRandom(byte[] scalar) {
        Ristretto255.Checker.checkScalar("scalar", scalar);
        this.getSodium().crypto_core_ristretto255_scalar_random(scalar);
    }

    @Override
    public void cryptoCoreRistretto255ScalarReduce(byte[] result, byte[] scalar) {
        Ristretto255.Checker.checkScalar("result", result);
        Ristretto255.Checker.checkNonReducedScalar("scalar", scalar);
        this.getSodium().crypto_core_ristretto255_scalar_reduce(result, scalar);
    }

    @Override
    public boolean cryptoCoreRistretto255ScalarInvert(byte[] result, byte[] scalar) {
        Ristretto255.Checker.checkScalar("result", result);
        Ristretto255.Checker.checkScalar("scalar", scalar);
        return this.successful(this.getSodium().crypto_core_ristretto255_scalar_invert(result, scalar));
    }

    @Override
    public void cryptoCoreRistretto255ScalarNegate(byte[] result, byte[] scalar) {
        Ristretto255.Checker.checkScalar("result", result);
        Ristretto255.Checker.checkScalar("scalar", scalar);
        this.getSodium().crypto_core_ristretto255_scalar_negate(result, scalar);
    }

    @Override
    public void cryptoCoreRistretto255ScalarComplement(byte[] result, byte[] scalar) {
        Ristretto255.Checker.checkScalar("result", result);
        Ristretto255.Checker.checkScalar("scalar", scalar);
        this.getSodium().crypto_core_ristretto255_scalar_complement(result, scalar);
    }

    @Override
    public void cryptoCoreRistretto255ScalarAdd(byte[] result, byte[] x, byte[] y) {
        Ristretto255.Checker.checkScalar("result", result);
        Ristretto255.Checker.checkScalar("x", x);
        Ristretto255.Checker.checkScalar("y", y);
        this.getSodium().crypto_core_ristretto255_scalar_add(result, x, y);
    }

    @Override
    public void cryptoCoreRistretto255ScalarSub(byte[] result, byte[] x, byte[] y) {
        Ristretto255.Checker.checkScalar("result", result);
        Ristretto255.Checker.checkScalar("x", x);
        Ristretto255.Checker.checkScalar("y", y);
        this.getSodium().crypto_core_ristretto255_scalar_sub(result, x, y);
    }

    @Override
    public void cryptoCoreRistretto255ScalarMul(byte[] result, byte[] x, byte[] y) {
        Ristretto255.Checker.checkScalar("result", result);
        Ristretto255.Checker.checkScalar("x", x);
        Ristretto255.Checker.checkScalar("y", y);
        this.getSodium().crypto_core_ristretto255_scalar_mul(result, x, y);
    }

    @Override
    public boolean cryptoCoreRistretto255IsValidPoint(String point) {
        if (point == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255IsValidPoint(this.messageEncoder.decode(point));
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoCoreRistretto255Random() {
        byte[] point = Ristretto255.pointBuffer();
        this.cryptoCoreRistretto255Random(point);
        return Ristretto255.RistrettoPoint.fromBytes(this, point);
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoCoreRistretto255FromHash(String hash) throws SodiumException {
        if (hash == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255FromHash(this.messageEncoder.decode(hash));
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoCoreRistretto255FromHash(byte[] hash) throws SodiumException {
        byte[] point = Ristretto255.pointBuffer();
        if (!this.cryptoCoreRistretto255FromHash(point, hash)) {
            throw new SodiumException("Conversion from hash to Ristretto point failed");
        }
        return Ristretto255.RistrettoPoint.fromBytes(this, point);
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoScalarmultRistretto255(BigInteger n, Ristretto255.RistrettoPoint point) throws SodiumException {
        if (n == null || point == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoScalarmultRistretto255(Ristretto255.scalarToBytes(n), point);
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoScalarmultRistretto255(String nEnc, Ristretto255.RistrettoPoint point) throws SodiumException {
        if (nEnc == null || point == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoScalarmultRistretto255(this.messageEncoder.decode(nEnc), point);
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoScalarmultRistretto255(byte[] n, Ristretto255.RistrettoPoint point) throws SodiumException {
        byte[] result = Ristretto255.pointBuffer();
        if (!this.cryptoScalarmultRistretto255(result, n, point.toBytes())) {
            throw new SodiumException("Scalar multiplication failed. The resulting point was the identity element.");
        }
        return Ristretto255.RistrettoPoint.fromBytes(this, result);
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoScalarmultRistretto255Base(BigInteger n) throws SodiumException {
        if (n == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoScalarmultRistretto255Base(Ristretto255.scalarToBytes(n));
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoScalarmultRistretto255Base(String nEnc) throws SodiumException {
        if (nEnc == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoScalarmultRistretto255Base(this.messageEncoder.decode(nEnc));
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoScalarmultRistretto255Base(byte[] n) throws SodiumException {
        byte[] result = Ristretto255.pointBuffer();
        if (!this.cryptoScalarmultRistretto255Base(result, n)) {
            throw new SodiumException("Scalar multiplication failed. n was 0.");
        }
        return Ristretto255.RistrettoPoint.fromBytes(this, result);
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoCoreRistretto255Add(Ristretto255.RistrettoPoint p, Ristretto255.RistrettoPoint q) throws SodiumException {
        if (p == null || q == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        byte[] result = Ristretto255.pointBuffer();
        if (!this.cryptoCoreRistretto255Add(result, p.toBytes(), q.toBytes())) {
            throw new SodiumException("Either p or q was not a valid point.");
        }
        return Ristretto255.RistrettoPoint.fromBytes(this, result);
    }

    @Override
    public Ristretto255.RistrettoPoint cryptoCoreRistretto255Sub(Ristretto255.RistrettoPoint p, Ristretto255.RistrettoPoint q) throws SodiumException {
        if (p == null || q == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        byte[] result = Ristretto255.pointBuffer();
        if (!this.cryptoCoreRistretto255Sub(result, p.toBytes(), q.toBytes())) {
            throw new SodiumException("Either p or q was not a valid point.");
        }
        return Ristretto255.RistrettoPoint.fromBytes(this, result);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarRandom() {
        byte[] scalar = Ristretto255.scalarBuffer();
        this.cryptoCoreRistretto255ScalarRandom(scalar);
        return Ristretto255.bytesToScalar(scalar);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarReduce(BigInteger scalar) {
        if (scalar == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarReduce(Ristretto255.scalarToBytes(scalar, false));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarReduce(String scalarEnc) {
        if (scalarEnc == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarReduce(this.messageEncoder.decode(scalarEnc));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarReduce(byte[] scalar) {
        byte[] result = Ristretto255.scalarBuffer();
        this.cryptoCoreRistretto255ScalarReduce(result, scalar);
        return Ristretto255.bytesToScalar(result);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarInvert(BigInteger scalar) throws SodiumException {
        if (scalar == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarInvert(Ristretto255.scalarToBytes(scalar));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarInvert(String scalarEnc) throws SodiumException {
        if (scalarEnc == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarInvert(this.messageEncoder.decode(scalarEnc));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarInvert(byte[] scalar) throws SodiumException {
        byte[] result = Ristretto255.scalarBuffer();
        if (!this.cryptoCoreRistretto255ScalarInvert(result, scalar)) {
            throw new SodiumException("Scalar inversion failed. Did you pass 0?");
        }
        return Ristretto255.bytesToScalar(result);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarNegate(BigInteger scalar) {
        if (scalar == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarNegate(Ristretto255.scalarToBytes(scalar));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarNegate(String scalarEnc) {
        if (scalarEnc == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarNegate(this.messageEncoder.decode(scalarEnc));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarNegate(byte[] scalar) {
        byte[] result = Ristretto255.scalarBuffer();
        this.cryptoCoreRistretto255ScalarNegate(result, scalar);
        return Ristretto255.bytesToScalar(result);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarComplement(BigInteger scalar) {
        if (scalar == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarComplement(Ristretto255.scalarToBytes(scalar));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarComplement(String scalarEnc) {
        if (scalarEnc == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarComplement(this.messageEncoder.decode(scalarEnc));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarComplement(byte[] scalar) {
        byte[] result = Ristretto255.scalarBuffer();
        this.cryptoCoreRistretto255ScalarComplement(result, scalar);
        return Ristretto255.bytesToScalar(result);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(BigInteger x, BigInteger y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarAdd(Ristretto255.scalarToBytes(x), Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(BigInteger x, String y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarAdd(Ristretto255.scalarToBytes(x), this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(String x, BigInteger y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarAdd(this.messageEncoder.decode(x), Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(String x, String y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarAdd(this.messageEncoder.decode(x), this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(String x, byte[] y) {
        if (x == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarAdd(this.messageEncoder.decode(x), y);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(byte[] x, String y) {
        if (y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarAdd(x, this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(BigInteger x, byte[] y) {
        if (x == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarAdd(Ristretto255.scalarToBytes(x), y);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(byte[] x, BigInteger y) {
        if (y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarAdd(x, Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarAdd(byte[] x, byte[] y) {
        byte[] result = Ristretto255.scalarBuffer();
        this.cryptoCoreRistretto255ScalarAdd(result, x, y);
        return Ristretto255.bytesToScalar(result);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(BigInteger x, BigInteger y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarSub(Ristretto255.scalarToBytes(x), Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(BigInteger x, String y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarSub(Ristretto255.scalarToBytes(x), this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(String x, BigInteger y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarSub(this.messageEncoder.decode(x), Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(String x, String y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarSub(this.messageEncoder.decode(x), this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(String x, byte[] y) {
        if (x == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarSub(this.messageEncoder.decode(x), y);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(byte[] x, String y) {
        if (y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarSub(x, this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(BigInteger x, byte[] y) {
        if (x == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarSub(Ristretto255.scalarToBytes(x), y);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(byte[] x, BigInteger y) {
        if (y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarSub(x, Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarSub(byte[] x, byte[] y) {
        byte[] result = Ristretto255.scalarBuffer();
        this.cryptoCoreRistretto255ScalarSub(result, x, y);
        return Ristretto255.bytesToScalar(result);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(BigInteger x, BigInteger y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarMul(Ristretto255.scalarToBytes(x), Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(BigInteger x, String y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarMul(Ristretto255.scalarToBytes(x), this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(String x, BigInteger y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarMul(this.messageEncoder.decode(x), Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(String x, String y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarMul(this.messageEncoder.decode(x), this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(String x, byte[] y) {
        if (x == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarMul(this.messageEncoder.decode(x), y);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(byte[] x, String y) {
        if (y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarMul(x, this.messageEncoder.decode(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(BigInteger x, byte[] y) {
        if (x == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarMul(Ristretto255.scalarToBytes(x), y);
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(byte[] x, BigInteger y) {
        if (y == null) {
            throw new IllegalArgumentException("null arguments are invalid");
        }
        return this.cryptoCoreRistretto255ScalarMul(x, Ristretto255.scalarToBytes(y));
    }

    @Override
    public BigInteger cryptoCoreRistretto255ScalarMul(byte[] x, byte[] y) {
        byte[] result = Ristretto255.scalarBuffer();
        this.cryptoCoreRistretto255ScalarMul(result, x, y);
        return Ristretto255.bytesToScalar(result);
    }

    @Override
    public <T> T res(int res, T object) {
        return res != 0 ? null : (T)object;
    }

    @Override
    public boolean successful(int res) {
        return res == 0;
    }

    @Override
    public String str(byte[] bs) {
        return new String(bs, this.charset);
    }

    @Override
    public String str(byte[] bs, Charset charset) {
        if (charset == null) {
            return new String(bs, this.charset);
        }
        return new String(bs, charset);
    }

    @Override
    public byte[] bytes(String s) {
        return s.getBytes(this.charset);
    }

    public String encodeToString(byte[] bytes) {
        return this.messageEncoder.encode(bytes);
    }

    public byte[] decodeFromString(String encoded) {
        return this.messageEncoder.decode(encoded);
    }

    @Override
    public boolean wrongLen(byte[] bs, int shouldBe) {
        return bs.length != shouldBe;
    }

    @Override
    public boolean wrongLen(int byteLength, int shouldBe) {
        return byteLength != shouldBe;
    }

    @Override
    public boolean wrongLen(int byteLength, long shouldBe) {
        return (long)byteLength != shouldBe;
    }

    @Override
    public byte[] removeNulls(byte[] bs) {
        int totalBytesToCut = 0;
        for (int i = bs.length - 1; i >= 0; --i) {
            byte b = bs[i];
            if (b != 0) continue;
            ++totalBytesToCut;
        }
        int newLengthOfBs = bs.length - totalBytesToCut;
        byte[] trimmed = new byte[newLengthOfBs];
        System.arraycopy(bs, 0, trimmed, 0, newLengthOfBs);
        return trimmed;
    }

    static byte[] encodeToAsciiz(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
        byte[] bytesWithZero = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, bytesWithZero, 0, bytes.length);
        return bytesWithZero;
    }

    static String decodeAsciiz(byte[] bytes) throws SodiumException {
        int zeroPos = -1;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            zeroPos = i;
            break;
        }
        if (zeroPos < 0) {
            throw new SodiumException("Zero terminator missing in presumably ASCIIZ data");
        }
        return new String(bytes, 0, zeroPos, StandardCharsets.US_ASCII);
    }

    public abstract Sodium getSodium();

    public static void main(String[] args) throws SodiumException {
    }
}

