/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.DetachedDecrypt;
import com.goterl.lazysodium.utils.DetachedEncrypt;
import com.goterl.lazysodium.utils.Key;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import javax.crypto.AEADBadTagException;

public interface AEAD {
    public static final int CHACHA20POLY1305_KEYBYTES = 32;
    public static final int CHACHA20POLY1305_NPUBBYTES = 8;
    public static final int CHACHA20POLY1305_ABYTES = 16;
    public static final int CHACHA20POLY1305_IETF_ABYTES = 16;
    public static final int CHACHA20POLY1305_IETF_KEYBYTES = 32;
    public static final int CHACHA20POLY1305_IETF_NPUBBYTES = 12;
    public static final int XCHACHA20POLY1305_IETF_KEYBYTES = 32;
    public static final int XCHACHA20POLY1305_IETF_ABYTES = 16;
    public static final int XCHACHA20POLY1305_IETF_NPUBBYTES = 24;
    public static final int AES256GCM_KEYBYTES = 32;
    public static final int AES256GCM_NSECBYTES = 0;
    public static final int AES256GCM_NPUBBYTES = 12;
    public static final int AES256GCM_ABYTES = 16;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkChaCha20Poly1305Key(byte[] key) {
            Checker.checkExpectedMemorySize("key length", key.length, 32);
        }

        public static void checkChaCha20Poly1305Nonce(byte[] nPub) {
            Checker.checkExpectedMemorySize("nPub length", nPub.length, 8);
        }

        public static void checkChaCha20Poly1305CipherLength(byte[] cipher, int messageLength, boolean receivesCipherLen) {
            if (receivesCipherLen) {
                BaseChecker.checkAtLeast("cipher length", cipher.length, messageLength + 16);
            } else {
                Checker.checkExpectedMemorySize("cipher length", cipher.length, messageLength + 16);
            }
        }

        public static void checkChaCha20Poly1305DecryptedMessageLength(byte[] message, int cipherLength, boolean receivesMessageLen) {
            BaseChecker.checkAtLeast("cipherLength", cipherLength, 16L);
            if (receivesMessageLen) {
                BaseChecker.checkAtLeast("message length", message.length, cipherLength - 16);
            } else {
                Checker.checkExpectedMemorySize("message length", message.length, cipherLength - 16);
            }
        }

        public static void checkChaCha20Poly1305Mac(byte[] mac, boolean receivesMacLen) {
            if (receivesMacLen) {
                BaseChecker.checkAtLeast("mac length", mac.length, 16L);
            } else {
                Checker.checkExpectedMemorySize("mac length", mac.length, 16);
            }
        }

        public static void checkChaCha20Poly1305IetfKey(byte[] key) {
            Checker.checkExpectedMemorySize("key length", key.length, 32);
        }

        public static void checkChaCha20Poly1305IetfNonce(byte[] nPub) {
            Checker.checkExpectedMemorySize("nPub length", nPub.length, 12);
        }

        public static void checkChaCha20Poly1305IetfCipherLength(byte[] cipher, int messageLength, boolean receivesCipherLen) {
            if (receivesCipherLen) {
                BaseChecker.checkAtLeast("cipher length", cipher.length, messageLength + 16);
            } else {
                Checker.checkExpectedMemorySize("cipher length", cipher.length, messageLength + 16);
            }
        }

        public static void checkChaCha20Poly1305IetfDecryptedMessageLength(byte[] message, int cipherLength, boolean receivesMessageLen) {
            BaseChecker.checkAtLeast("cipherLength", cipherLength, 16L);
            if (receivesMessageLen) {
                BaseChecker.checkAtLeast("message length", message.length, cipherLength - 16);
            } else {
                Checker.checkExpectedMemorySize("message length", message.length, cipherLength - 16);
            }
        }

        public static void checkChaCha20Poly1305IetfMac(byte[] mac, boolean receivesMacLen) {
            if (receivesMacLen) {
                BaseChecker.checkAtLeast("mac length", mac.length, 16L);
            } else {
                Checker.checkExpectedMemorySize("mac length", mac.length, 16);
            }
        }

        public static void checkXChaCha20Poly1305IetfKey(byte[] key) {
            Checker.checkExpectedMemorySize("key length", key.length, 32);
        }

        public static void checkXChaCha20Poly1305IetfNonce(byte[] nPub) {
            Checker.checkExpectedMemorySize("nPub length", nPub.length, 24);
        }

        public static void checkXChaCha20Poly1305IetfCipherLength(byte[] cipher, int messageLength, boolean receivesCipherLen) {
            if (receivesCipherLen) {
                BaseChecker.checkAtLeast("cipher length", cipher.length, messageLength + 16);
            } else {
                Checker.checkExpectedMemorySize("cipher length", cipher.length, messageLength + 16);
            }
        }

        public static void checkXChaCha20Poly1305IetfDecryptedMessageLength(byte[] message, int cipherLength, boolean receivesMessageLen) {
            BaseChecker.checkAtLeast("cipherLength", cipherLength, 16L);
            if (receivesMessageLen) {
                BaseChecker.checkAtLeast("message length", message.length, cipherLength - 16);
            } else {
                Checker.checkExpectedMemorySize("message length", message.length, cipherLength - 16);
            }
        }

        public static void checkXChaCha20Poly1305IetfMac(byte[] mac, boolean receivesMacLen) {
            if (receivesMacLen) {
                BaseChecker.checkAtLeast("mac length", mac.length, 16L);
            } else {
                Checker.checkExpectedMemorySize("mac length", mac.length, 16);
            }
        }

        public static void checkAes256GcmKey(byte[] key) {
            Checker.checkExpectedMemorySize("key length", key.length, 32);
        }

        public static void checkAes256GcmNonce(byte[] nPub) {
            Checker.checkExpectedMemorySize("nPub length", nPub.length, 12);
        }

        public static void checkAes256GcmCipherLength(byte[] cipher, int messageLength, boolean receivesCipherLen) {
            if (receivesCipherLen) {
                BaseChecker.checkAtLeast("cipher length", cipher.length, messageLength + 16);
            } else {
                Checker.checkExpectedMemorySize("cipher length", cipher.length, messageLength + 16);
            }
        }

        public static void checkAes256GcmDecryptedMessageLength(byte[] message, int cipherLength, boolean receivesMessageLen) {
            BaseChecker.checkAtLeast("cipherLength", cipherLength, 16L);
            if (receivesMessageLen) {
                BaseChecker.checkAtLeast("message length", message.length, cipherLength - 16);
            } else {
                Checker.checkExpectedMemorySize("message length", message.length, cipherLength - 16);
            }
        }

        public static void checkAes256GcmMac(byte[] mac, boolean receivesMacLen) {
            if (receivesMacLen) {
                BaseChecker.checkAtLeast("mac length", mac.length, 16L);
            } else {
                Checker.checkExpectedMemorySize("mac length", mac.length, 16);
            }
        }
    }

    public static class StateAES
    extends Structure {
        public byte[] arr = new byte[512];

        protected List<String> getFieldOrder() {
            return Arrays.asList("arr");
        }

        public static class ByReference
        extends StateAES
        implements Structure.ByReference {
        }
    }

    public static interface Lazy {
        public Key keygen(Method var1);

        public String encrypt(String var1, String var2, byte[] var3, Key var4, Method var5);

        @Deprecated(forRemoval=true, since="6.0.0")
        public String encrypt(String var1, String var2, byte[] var3, byte[] var4, Key var5, Method var6);

        public String decrypt(String var1, String var2, byte[] var3, Key var4, Method var5) throws AEADBadTagException;

        @Deprecated(forRemoval=true, since="6.0.0")
        public String decrypt(String var1, String var2, byte[] var3, byte[] var4, Key var5, Method var6) throws AEADBadTagException;

        public DetachedEncrypt encryptDetached(String var1, String var2, byte[] var3, Key var4, Method var5);

        @Deprecated(forRemoval=true, since="6.0.0")
        public DetachedEncrypt encryptDetached(String var1, String var2, byte[] var3, byte[] var4, Key var5, Method var6);

        public DetachedDecrypt decryptDetached(DetachedEncrypt var1, String var2, byte[] var3, Key var4, Method var5) throws AEADBadTagException;

        @Deprecated(forRemoval=true, since="6.0.0")
        public DetachedDecrypt decryptDetached(DetachedEncrypt var1, String var2, byte[] var3, byte[] var4, Key var5, Method var6) throws AEADBadTagException;
    }

    public static interface Native {
        public void cryptoAeadChaCha20Poly1305Keygen(byte[] var1);

        public boolean cryptoAeadChaCha20Poly1305Encrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadChaCha20Poly1305Encrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadChaCha20Poly1305Decrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadChaCha20Poly1305Decrypt(byte[] var1, long[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadChaCha20Poly1305EncryptDetached(byte[] var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadChaCha20Poly1305EncryptDetached(byte[] var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9, byte[] var10);

        public boolean cryptoAeadChaCha20Poly1305DecryptDetached(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadChaCha20Poly1305DecryptDetached(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        public void cryptoAeadChaCha20Poly1305IetfKeygen(byte[] var1);

        public boolean cryptoAeadChaCha20Poly1305IetfEncrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadChaCha20Poly1305IetfEncrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadChaCha20Poly1305IetfDecrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadChaCha20Poly1305IetfDecrypt(byte[] var1, long[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadChaCha20Poly1305IetfEncryptDetached(byte[] var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadChaCha20Poly1305IetfEncryptDetached(byte[] var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9, byte[] var10);

        public boolean cryptoAeadChaCha20Poly1305IetfDecryptDetached(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadChaCha20Poly1305IetfDecryptDetached(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        public void cryptoAeadXChaCha20Poly1305IetfKeygen(byte[] var1);

        public boolean cryptoAeadXChaCha20Poly1305IetfEncrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadXChaCha20Poly1305IetfEncrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadXChaCha20Poly1305IetfDecrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadXChaCha20Poly1305IetfDecrypt(byte[] var1, long[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadXChaCha20Poly1305IetfEncryptDetached(byte[] var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadXChaCha20Poly1305IetfEncryptDetached(byte[] var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9, byte[] var10);

        public boolean cryptoAeadXChaCha20Poly1305IetfDecryptDetached(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadXChaCha20Poly1305IetfDecryptDetached(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        public void cryptoAeadAES256GCMKeygen(byte[] var1);

        public boolean cryptoAeadAES256GCMEncrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadAES256GCMEncrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadAES256GCMDecrypt(byte[] var1, long[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadAES256GCMDecrypt(byte[] var1, long[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadAES256GCMEncryptDetached(byte[] var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadAES256GCMEncryptDetached(byte[] var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, byte[] var9, byte[] var10);

        public boolean cryptoAeadAES256GCMDecryptDetached(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        @Deprecated(forRemoval=true, since="6.0.0")
        public boolean cryptoAeadAES256GCMDecryptDetached(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6, int var7, byte[] var8, byte[] var9);

        public boolean cryptoAeadAES256GCMIsAvailable();
    }

    public static enum Method {
        CHACHA20_POLY1305,
        CHACHA20_POLY1305_IETF,
        XCHACHA20_POLY1305_IETF,
        AES256GCM;

    }
}

