/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.DetachedDecrypt;
import com.goterl.lazysodium.utils.DetachedEncrypt;
import com.goterl.lazysodium.utils.Key;
import com.goterl.lazysodium.utils.KeyPair;

public interface Box {
    public static final int CURVE25519XSALSA20POLY1305_PUBLICKEYBYTES = 32;
    public static final int CURVE25519XSALSA20POLY1305_SECRETKEYBYTES = 32;
    public static final int CURVE25519XSALSA20POLY1305_MACBYTES = 16;
    public static final int CURVE25519XSALSA20POLY1305_SEEDBYTES = 32;
    public static final int CURVE25519XSALSA20POLY1305_BEFORENMBYTES = 32;
    public static final int CURVE25519XSALSA20POLY1305_NONCEBYTES = 24;
    public static final int PUBLICKEYBYTES = 32;
    public static final int SECRETKEYBYTES = 32;
    public static final int MACBYTES = 16;
    public static final int SEEDBYTES = 32;
    public static final int BEFORENMBYTES = 32;
    public static final int NONCEBYTES = 24;
    public static final int SEALBYTES = 48;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkPublicKey(byte[] key) {
            Checker.checkExpectedMemorySize("public key length", key.length, 32);
        }

        public static void checkSecretKey(byte[] key) {
            Checker.checkExpectedMemorySize("secret key length", key.length, 32);
        }

        public static void checkSeed(byte[] seed) {
            Checker.checkExpectedMemorySize("seed length", seed.length, 32);
        }

        public static void checkNonce(byte[] nonce) {
            Checker.checkExpectedMemorySize("nonce length", nonce.length, 24);
        }

        public static void checkMac(byte[] mac) {
            Checker.checkExpectedMemorySize("mac length", mac.length, 16);
        }

        public static void checkSharedKey(byte[] sharedKey) {
            Checker.checkExpectedMemorySize("key length", sharedKey.length, 32);
        }

        public static void checkCipherText(byte[] cipherText, int messageLen) {
            Checker.checkExpectedMemorySize("cipherText length", cipherText.length, 16 + messageLen);
        }

        public static void checkSealCipherText(byte[] cipherText, int messageLen) {
            Checker.checkExpectedMemorySize("cipherText length", cipherText.length, 48 + messageLen);
        }

        public static void checkMessage(byte[] message, int cipherTextLen) {
            Checker.checkExpectedMemorySize("message length", message.length, cipherTextLen - 16);
        }

        public static void checkSealMessage(byte[] message, int cipherTextLen) {
            Checker.checkExpectedMemorySize("message length", message.length, cipherTextLen - 48);
        }

        public static void checkCipherTextLength(long cipherTextLen) {
            Checker.checkAtLeast("cipher text length", cipherTextLen, 16L);
        }

        public static void checkSealCipherTextLength(long cipherTextLen) {
            Checker.checkAtLeast("cipher text length", cipherTextLen, 48L);
        }
    }

    public static interface Lazy {
        public KeyPair cryptoBoxKeypair() throws SodiumException;

        public KeyPair cryptoBoxSeedKeypair(byte[] var1) throws SodiumException;

        public String cryptoBoxEasy(String var1, byte[] var2, KeyPair var3) throws SodiumException;

        public String cryptoBoxOpenEasy(String var1, byte[] var2, KeyPair var3) throws SodiumException;

        public String cryptoBoxBeforeNm(byte[] var1, byte[] var2) throws SodiumException;

        public String cryptoBoxBeforeNm(KeyPair var1) throws SodiumException;

        public String cryptoBoxEasyAfterNm(String var1, byte[] var2, String var3) throws SodiumException;

        public String cryptoBoxOpenEasyAfterNm(String var1, byte[] var2, String var3) throws SodiumException;

        public DetachedEncrypt cryptoBoxDetachedAfterNm(String var1, byte[] var2, String var3) throws SodiumException;

        public DetachedDecrypt cryptoBoxOpenDetachedAfterNm(DetachedEncrypt var1, byte[] var2, String var3) throws SodiumException;

        public String cryptoBoxSealEasy(String var1, Key var2) throws SodiumException;

        public String cryptoBoxSealOpenEasy(String var1, KeyPair var2) throws SodiumException;
    }

    public static interface Native {
        public boolean cryptoBoxKeypair(byte[] var1, byte[] var2);

        public boolean cryptoBoxSeedKeypair(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoBoxEasy(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, byte[] var6);

        public boolean cryptoBoxOpenEasy(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, byte[] var6);

        public boolean cryptoBoxDetached(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6, byte[] var7);

        public boolean cryptoBoxOpenDetached(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6, byte[] var7);

        public boolean cryptoBoxBeforeNm(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoBoxEasyAfterNm(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);

        public boolean cryptoBoxOpenEasyAfterNm(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);

        public boolean cryptoBoxDetachedAfterNm(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6);

        public boolean cryptoBoxOpenDetachedAfterNm(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6);

        public boolean cryptoBoxSeal(byte[] var1, byte[] var2, int var3, byte[] var4);

        public boolean cryptoBoxSealOpen(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);
    }
}

