/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.Key;

public interface DiffieHellman {
    public static final int SCALARMULT_CURVE25519_BYTES = 32;
    public static final int SCALARMULT_CURVE25519_SCALARBYTES = 32;
    public static final int SCALARMULT_BYTES = 32;
    public static final int SCALARMULT_SCALARBYTES = 32;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkPublicKey(byte[] publicKey) {
            Checker.checkExpectedMemorySize("publicKey", publicKey.length, 32);
        }

        public static void checkSecretKey(byte[] secretKey) {
            Checker.checkExpectedMemorySize("secretKey", secretKey.length, 32);
        }

        public static void checkSharedKey(byte[] sharedKey) {
            Checker.checkExpectedMemorySize("sharedKey", sharedKey.length, 32);
        }
    }

    public static interface Lazy {
        public Key cryptoScalarMultBase(Key var1);

        public Key cryptoScalarMult(Key var1, Key var2);
    }

    public static interface Native {
        public boolean cryptoScalarMultBase(byte[] var1, byte[] var2);

        public boolean cryptoScalarMult(byte[] var1, byte[] var2, byte[] var3);
    }
}

