/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.Key;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.Closeable;

public interface GenericHash {
    public static final int BLAKE2B_BYTES = 32;
    public static final int BLAKE2B_BYTES_MIN = 16;
    public static final int BLAKE2B_BYTES_MAX = 64;
    public static final int BLAKE2B_KEYBYTES = 32;
    public static final int BLAKE2B_KEYBYTES_MIN = 16;
    public static final int BLAKE2B_KEYBYTES_MAX = 64;
    public static final int BLAKE2B_SALTBYTES = 16;
    public static final int BLAKE2B_PERSONALBYTES = 16;
    public static final int BYTES = 32;
    public static final int KEYBYTES = 32;
    public static final int BYTES_MAX = 64;
    public static final int BYTES_MIN = 16;
    public static final int KEYBYTES_MIN = 16;
    public static final int KEYBYTES_MAX = 64;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkKey(byte[] key) {
            Checker.checkExpectedMemorySize("key length", key.length, 32);
        }

        public static void checkOutputLength(int outLen) {
            BaseChecker.checkBetween("outLen", outLen, 1L, 64L);
        }

        public static void checkKey(byte[] key, int keyLen) {
            BaseChecker.checkOptionalArrayLength("key", key, keyLen);
            if (key != null) {
                BaseChecker.checkBetween("keyLen", keyLen, 1L, 64L);
            }
        }
    }

    public static class State
    implements Closeable {
        private final Memory allocatedMemory = new Memory(448L);
        private final Memory alignedMemory = this.allocatedMemory.align(64);

        public Pointer getPointer() {
            return this.alignedMemory;
        }

        @Override
        public void close() {
            this.alignedMemory.close();
            this.allocatedMemory.close();
        }
    }

    public static interface Lazy {
        public Key cryptoGenericHashKeygen();

        public Key cryptoGenericHashKeygen(int var1) throws SodiumException;

        public String cryptoGenericHash(String var1) throws SodiumException;

        public String cryptoGenericHash(String var1, Key var2) throws SodiumException;

        public boolean cryptoGenericHashInit(State var1, Key var2, int var3);

        public boolean cryptoGenericHashUpdate(State var1, String var2) throws SodiumException;

        public String cryptoGenericHashFinal(State var1, int var2) throws SodiumException;
    }

    public static interface Native {
        public void cryptoGenericHashKeygen(byte[] var1);

        public boolean cryptoGenericHash(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

        public boolean cryptoGenericHash(byte[] var1, int var2, byte[] var3, int var4);

        public boolean cryptoGenericHashInit(State var1, byte[] var2, int var3, int var4);

        public boolean cryptoGenericHashInit(State var1, int var2);

        public boolean cryptoGenericHashUpdate(State var1, byte[] var2, int var3);

        public boolean cryptoGenericHashFinal(State var1, byte[] var2, int var3);
    }
}

