/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.Key;

public interface KeyDerivation {
    public static final int MASTER_KEY_BYTES = 32;
    public static final int CONTEXT_BYTES = 8;
    public static final int BLAKE2B_BYTES_MIN = 16;
    public static final int BLAKE2B_BYTES_MAX = 64;
    public static final int BYTES_MIN = 16;
    public static final int BYTES_MAX = 64;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkMasterKey(byte[] key) {
            Checker.checkExpectedMemorySize("master key length", key.length, 32);
        }

        public static void checkSubKeyLength(int subkeyLen) {
            Checker.checkBetween("subkey length", subkeyLen, 16L, 64L);
        }

        public static void checkContext(byte[] context) {
            Checker.checkExpectedMemorySize("context length", context.length, 8);
        }
    }

    public static interface Lazy {
        public Key cryptoKdfKeygen();

        public Key cryptoKdfDeriveFromKey(int var1, long var2, String var4, Key var5) throws SodiumException;
    }

    public static interface Native {
        public void cryptoKdfKeygen(byte[] var1);

        public boolean cryptoKdfDeriveFromKey(byte[] var1, int var2, long var3, byte[] var5, byte[] var6);
    }
}

