/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.Key;
import com.goterl.lazysodium.utils.KeyPair;
import com.goterl.lazysodium.utils.SessionPair;

public interface KeyExchange {
    public static final int PUBLICKEYBYTES = 32;
    public static final int SECRETKEYBYTES = 32;
    public static final int SESSIONKEYBYTES = 32;
    public static final int SEEDBYTES = 32;
    public static final String PRIMITIVE = "x25519blake2b";

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkPublicKey(byte[] key) {
            Checker.checkExpectedMemorySize("public key length", key.length, 32);
        }

        public static void checkSecretKey(byte[] key) {
            Checker.checkExpectedMemorySize("secret key length", key.length, 32);
        }

        public static void checkSessionKey(byte[] key) {
            Checker.checkExpectedMemorySize("session key length", key.length, 32);
        }

        public static void checkSeed(byte[] seed) {
            Checker.checkExpectedMemorySize("seed length", seed.length, 32);
        }
    }

    public static interface Lazy {
        public KeyPair cryptoKxKeypair() throws SodiumException;

        public KeyPair cryptoKxKeypair(byte[] var1) throws SodiumException;

        public SessionPair cryptoKxClientSessionKeys(Key var1, Key var2, Key var3) throws SodiumException;

        @Deprecated(forRemoval=true, since="6.0.0")
        public SessionPair cryptoKxClientSessionKeys(KeyPair var1, KeyPair var2) throws SodiumException;

        public SessionPair cryptoKxClientSessionKeys(KeyPair var1, Key var2) throws SodiumException;

        public SessionPair cryptoKxServerSessionKeys(Key var1, Key var2, Key var3) throws SodiumException;

        @Deprecated(forRemoval=true, since="6.0.0")
        public SessionPair cryptoKxServerSessionKeys(KeyPair var1, KeyPair var2) throws SodiumException;

        public SessionPair cryptoKxServerSessionKeys(KeyPair var1, Key var2) throws SodiumException;
    }

    public static interface Native {
        public boolean cryptoKxKeypair(byte[] var1, byte[] var2);

        public boolean cryptoKxSeedKeypair(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoKxClientSessionKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

        public boolean cryptoKxServerSessionKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);
    }
}

