/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.BaseChecker;
import com.sun.jna.NativeLong;
import java.util.HashMap;
import java.util.Map;

public interface PwHash {
    public static final int ARGON2ID_SALTBYTES = 16;
    public static final int ARGON2ID_BYTES_MIN = 16;
    public static final int ARGON2ID_STR_BYTES = 128;
    public static final int SALTBYTES = 16;
    public static final int STR_BYTES = 128;
    public static final long ARGON2ID_OPSLIMIT_MIN = 1L;
    public static final long ARGON2ID_OPSLIMIT_MAX = Integer.MAX_VALUE;
    public static final long ARGON2ID_OPSLIMIT_INTERACTIVE = 2L;
    public static final long ARGON2ID_OPSLIMIT_MODERATE = 3L;
    public static final long ARGON2ID_OPSLIMIT_SENSITIVE = 4L;
    public static final long OPSLIMIT_MIN = 1L;
    public static final long OPSLIMIT_MAX = Integer.MAX_VALUE;
    public static final long OPSLIMIT_MODERATE = 3L;
    public static final long OPSLIMIT_INTERACTIVE = 2L;
    public static final long OPSLIMIT_SENSITIVE = 4L;
    public static final int ARGON2ID_MEMLIMIT_MIN = 8192;
    public static final int ARGON2ID_MEMLIMIT_MAX = Integer.MAX_VALUE;
    public static final int ARGON2ID_MEMLIMIT_INTERACTIVE = 0x4000000;
    public static final int ARGON2ID_MEMLIMIT_MODERATE = 0x10000000;
    public static final int ARGON2ID_MEMLIMIT_SENSITIVE = 0x40000000;
    public static final int ARGON2ID_PASSWD_MIN = 0;
    public static final int ARGON2ID_PASSWD_MAX = Integer.MAX_VALUE;
    public static final int ARGON2ID_BYTES_MAX = Integer.MAX_VALUE;
    public static final int PASSWD_MIN = 0;
    public static final int PASSWD_MAX = Integer.MAX_VALUE;
    public static final int BYTES_MIN = 16;
    public static final int BYTES_MAX = Integer.MAX_VALUE;
    public static final NativeLong MEMLIMIT_MIN = new NativeLong(8192L);
    public static final NativeLong MEMLIMIT_INTERACTIVE = new NativeLong(0x4000000L);
    public static final NativeLong MEMLIMIT_SENSITIVE = new NativeLong(0x40000000L);
    public static final NativeLong MEMLIMIT_MODERATE = new NativeLong(0x10000000L);
    public static final NativeLong MEMLIMIT_MAX = new NativeLong(Integer.MAX_VALUE);

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkLengthOfHash(int lengthOfHash) {
            Checker.checkBetween("hash length", lengthOfHash, 16L, Integer.MAX_VALUE);
        }

        public static void checkHashStrOutput(byte[] outputStr) {
            Checker.checkAtLeast("outputStr length", outputStr.length, 128L);
        }

        public static void checkPassword(byte[] password) {
            Checker.checkLengthOfPassword(password.length);
        }

        public static void checkLengthOfPassword(int lengthOfPassword) {
            Checker.checkBetween("password length", lengthOfPassword, 0L, Integer.MAX_VALUE);
        }

        public static void checkSalt(byte[] salt) {
            Checker.checkExpectedMemorySize("salt length", salt.length, 16);
        }

        public static void checkOpsLimit(long opsLimit) {
            Checker.checkBetween("opsLimit", opsLimit, 1L, Integer.MAX_VALUE);
        }

        public static void checkMemLimit(NativeLong memLimit) {
            Checker.checkBetween("memLimit", memLimit, MEMLIMIT_MIN, MEMLIMIT_MAX);
        }

        public static void checkHashStrInput(byte[] hashStrBytes) {
            int maxHashLen = Math.min(hashStrBytes.length, 128);
            for (int i = 0; i < maxHashLen; ++i) {
                if (hashStrBytes[i] != 0) continue;
                return;
            }
            if (maxHashLen == hashStrBytes.length) {
                throw new IllegalArgumentException("Hash is not null terminated");
            }
            throw new IllegalArgumentException("Hash is too long or not null terminated");
        }
    }

    public static enum NeedsRehashResult {
        NO_REHASH_NEEDED(0),
        NEEDS_REHASH(1),
        INVALID_HASH(-1);

        private final int val;
        private static final Map<Integer, NeedsRehashResult> map;

        private NeedsRehashResult(int val) {
            this.val = val;
        }

        public static NeedsRehashResult valueOf(int alg) {
            NeedsRehashResult result = map.get(alg);
            if (result == null) {
                return INVALID_HASH;
            }
            return result;
        }

        private static Map<Integer, NeedsRehashResult> getMap() {
            HashMap<Integer, NeedsRehashResult> map = new HashMap<Integer, NeedsRehashResult>();
            for (NeedsRehashResult alg : NeedsRehashResult.values()) {
                map.put(alg.val, alg);
            }
            return map;
        }

        static {
            map = NeedsRehashResult.getMap();
        }
    }

    public static enum Alg {
        PWHASH_ALG_ARGON2I13(1),
        PWHASH_ALG_ARGON2ID13(2);

        private final int val;
        private static final Map<Integer, Alg> map;

        private Alg(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }

        public static Alg getDefault() {
            return PWHASH_ALG_ARGON2ID13;
        }

        public static Alg valueOf(int alg) {
            return map.get(alg);
        }

        private static Map<Integer, Alg> getMap() {
            HashMap<Integer, Alg> map = new HashMap<Integer, Alg>();
            for (Alg alg : Alg.values()) {
                map.put(alg.val, alg);
            }
            return map;
        }

        static {
            map = Alg.getMap();
        }
    }

    public static interface Lazy {
        public String cryptoPwHash(String var1, int var2, byte[] var3, long var4, NativeLong var6, Alg var7) throws SodiumException;

        public String cryptoPwHashString(String var1, long var2, NativeLong var4) throws SodiumException;

        @Deprecated
        public String cryptoPwHashStr(String var1, long var2, NativeLong var4) throws SodiumException;

        @Deprecated
        public String cryptoPwHashStrRemoveNulls(String var1, long var2, NativeLong var4) throws SodiumException;

        @Deprecated
        public boolean cryptoPwHashStrVerify(String var1, String var2);

        public boolean cryptoPwHashStringVerify(String var1, String var2);

        public NeedsRehashResult cryptoPwHashStringNeedsRehash(String var1, long var2, NativeLong var4);
    }

    public static interface Native {
        public boolean cryptoPwHash(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, long var6, NativeLong var8, Alg var9);

        public boolean cryptoPwHashStr(byte[] var1, byte[] var2, int var3, long var4, NativeLong var6);

        public boolean cryptoPwHashStrVerify(byte[] var1, byte[] var2, int var3);

        public NeedsRehashResult cryptoPwHashStrNeedsRehash(byte[] var1, long var2, NativeLong var4);
    }
}

