/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.DetachedEncrypt;
import com.goterl.lazysodium.utils.Key;

public interface SecretBox {
    public static final int XSALSA20POLY1305_KEYBYTES = 32;
    public static final int XSALSA20POLY1305_NONCEBYTES = 24;
    public static final int XSALSA20POLY1305_MACBYTES = 16;
    public static final int KEYBYTES = 32;
    public static final int MACBYTES = 16;
    public static final int NONCEBYTES = 24;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkKey(byte[] key) {
            Checker.checkExpectedMemorySize("key length", key.length, 32);
        }

        public static void checkMac(byte[] mac) {
            Checker.checkExpectedMemorySize("mac length", mac.length, 16);
        }

        public static void checkNonce(byte[] nonce) {
            Checker.checkExpectedMemorySize("nonce length", nonce.length, 24);
        }

        public static void checkCipherText(byte[] cipherText, int messageLen) {
            Checker.checkExpectedMemorySize("cipherText length", cipherText.length, 16 + messageLen);
        }

        public static void checkMessage(byte[] message, int cipherTextLen) {
            Checker.checkExpectedMemorySize("message length", message.length, cipherTextLen - 16);
        }

        public static void checkCipherTextLength(long cipherTextLen) {
            Checker.checkAtLeast("cipher text length", cipherTextLen, 16L);
        }
    }

    public static interface Lazy {
        public Key cryptoSecretBoxKeygen();

        public String cryptoSecretBoxEasy(String var1, byte[] var2, Key var3) throws SodiumException;

        public String cryptoSecretBoxOpenEasy(String var1, byte[] var2, Key var3) throws SodiumException;

        public DetachedEncrypt cryptoSecretBoxDetached(String var1, byte[] var2, Key var3) throws SodiumException;

        public String cryptoSecretBoxOpenDetached(DetachedEncrypt var1, byte[] var2, Key var3) throws SodiumException;
    }

    public static interface Native {
        public void cryptoSecretBoxKeygen(byte[] var1);

        public boolean cryptoSecretBoxEasy(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);

        public boolean cryptoSecretBoxOpenEasy(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);

        public boolean cryptoSecretBoxDetached(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6);

        public boolean cryptoSecretBoxOpenDetached(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6);
    }
}

