/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.Key;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public interface SecretStream {
    public static final int CHACHA20_IETF_NONCEBYTES = 12;
    public static final byte XCHACHA20POLY1305_TAG_PUSH = 1;
    public static final byte XCHACHA20POLY1305_TAG_REKEY = 2;
    public static final byte XCHACHA20POLY1305_TAG_MESSAGE = 0;
    public static final byte XCHACHA20POLY1305_TAG_FINAL = 3;
    public static final byte TAG_PUSH = 1;
    public static final byte TAG_REKEY = 2;
    public static final byte TAG_MESSAGE = 0;
    public static final byte TAG_FINAL = 3;
    public static final int KEYBYTES = 32;
    public static final int ABYTES = 17;
    public static final int HEADERBYTES = 24;
    public static final int NONCEBYTES = 12;
    public static final long MESSAGEBYTES_MAX = 0x800000000L;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkHeader(byte[] header) {
            Checker.checkExpectedMemorySize("secret stream header length", header.length, 24);
        }

        public static void checkKey(byte[] key) {
            Checker.checkExpectedMemorySize("secret stream key length", key.length, 32);
        }

        public static void checkPush(byte[] message, int messageLen, byte[] cipher) {
            Checker.checkArrayLength("message bytes", message, messageLen);
            if (cipher.length < messageLen + 17) {
                throw new IllegalArgumentException("Cipher array too small for messageLen + header");
            }
        }

        public static void checkPull(byte[] cipher, int cipherLen, byte[] message) {
            Checker.checkArrayLength("message bytes", cipher, cipherLen);
            if (message.length < cipherLen - 17) {
                throw new IllegalArgumentException("Message array too small for cipherLen - header");
            }
        }
    }

    public static class State
    extends Structure {
        public byte[] k = new byte[32];
        public byte[] nonce = new byte[12];
        public byte[] _pad = new byte[8];

        protected List<String> getFieldOrder() {
            return Arrays.asList("k", "nonce", "_pad");
        }

        public static class ByReference
        extends State
        implements Structure.ByReference {
        }
    }

    public static interface Lazy {
        public Key cryptoSecretStreamKeygen();

        public State cryptoSecretStreamInitPush(byte[] var1, Key var2) throws SodiumException;

        public String cryptoSecretStreamPush(State var1, String var2, byte var3) throws SodiumException;

        public State cryptoSecretStreamInitPull(byte[] var1, Key var2) throws SodiumException;

        public String cryptoSecretStreamPull(State var1, String var2, byte[] var3) throws SodiumException;

        public void cryptoSecretStreamRekey(State var1);
    }

    public static interface Native {
        public void cryptoSecretStreamKeygen(byte[] var1);

        public boolean cryptoSecretStreamInitPush(State var1, byte[] var2, byte[] var3);

        public boolean cryptoSecretStreamPush(State var1, byte[] var2, long[] var3, byte[] var4, int var5, byte[] var6, int var7, byte var8);

        public boolean cryptoSecretStreamPush(State var1, byte[] var2, long[] var3, byte[] var4, int var5, byte var6);

        public boolean cryptoSecretStreamPush(State var1, byte[] var2, byte[] var3, int var4, byte var5);

        public boolean cryptoSecretStreamInitPull(State var1, byte[] var2, byte[] var3);

        public boolean cryptoSecretStreamPull(State var1, byte[] var2, long[] var3, byte[] var4, byte[] var5, int var6, byte[] var7, int var8);

        public boolean cryptoSecretStreamPull(State var1, byte[] var2, byte[] var3, byte[] var4, int var5);

        public void cryptoSecretStreamRekey(State var1);
    }
}

