/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.Key;

public interface ShortHash {
    public static final int SIPHASH24_BYTES = 8;
    public static final int SIPHASH24_KEYBYTES = 16;
    public static final int SIPHASHX24_BYTES = 16;
    public static final int SIPHASHX24_KEYBYTES = 16;
    public static final int BYTES = 8;
    public static final int KEYBYTES = 16;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkHash(byte[] hash) {
            Checker.checkExpectedMemorySize("hash length", hash.length, 8);
        }

        public static void checkKey(byte[] key) {
            Checker.checkExpectedMemorySize("key length", key.length, 16);
        }
    }

    public static interface Lazy {
        public Key cryptoShortHashKeygen();

        public String cryptoShortHash(byte[] var1, Key var2) throws SodiumException;

        public String cryptoShortHashStr(String var1, Key var2) throws SodiumException;

        public String cryptoShortHashHex(String var1, Key var2) throws SodiumException;
    }

    public static interface Native {
        public boolean cryptoShortHash(byte[] var1, byte[] var2, int var3, byte[] var4);

        public void cryptoShortHashKeygen(byte[] var1);
    }
}

