/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.interfaces.Hash;
import com.goterl.lazysodium.utils.BaseChecker;
import com.goterl.lazysodium.utils.Key;
import com.goterl.lazysodium.utils.KeyPair;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public interface Sign {
    public static final int ED25519_PUBLICKEYBYTES = 32;
    public static final int ED25519_BYTES = 64;
    public static final int ED25519_SECRETKEYBYTES = 64;
    public static final int ED25519_SEEDBYTES = 32;
    public static final int CURVE25519_PUBLICKEYBYTES = 32;
    public static final int CURVE25519_SECRETKEYBYTES = 32;
    public static final long ED25519_MESSAGEBYTES_MAX = 0x7FFFFFFFFFFFFFBFL;
    public static final int BYTES = 64;
    public static final int PUBLICKEYBYTES = 32;
    public static final int SECRETKEYBYTES = 64;
    public static final int SEEDBYTES = 32;
    public static final long MESSAGEBYTES_MAX = 0x7FFFFFFFFFFFFFBFL;

    public static final class Checker
    extends BaseChecker {
        private Checker() {
        }

        public static void checkPublicKey(byte[] key) {
            Checker.checkExpectedMemorySize("public key length", key.length, 32);
        }

        public static void checkSecretKey(byte[] key) {
            Checker.checkExpectedMemorySize("secret key length", key.length, 64);
        }

        public static void checkSeed(byte[] seed) {
            Checker.checkExpectedMemorySize("seed length", seed.length, 32);
        }

        public static void checkSignature(byte[] sig) {
            Checker.checkExpectedMemorySize("signature length", sig.length, 64);
        }

        public static void checkSignedMessageLength(int signedMessageLength) {
            Checker.checkAtLeast("signed message length", signedMessageLength, 64L);
        }

        public static void checkSignedMessageLength(byte[] signedMessage, int messageLen) {
            Checker.checkExpectedMemorySize("signed message length", signedMessage.length, messageLen + 64);
        }

        public static void checkMessageLength(byte[] message, int signedMessageLen) {
            Checker.checkExpectedMemorySize("message length", message.length, signedMessageLen - 64);
        }

        public static void checkPublicKeyCurve25519(byte[] curve) {
            Checker.checkExpectedMemorySize("curve25519 pk length", curve.length, 32);
        }

        public static void checkPublicKeyEd25519(byte[] curve) {
            Checker.checkExpectedMemorySize("ed25519 pk length", curve.length, 32);
        }

        public static void checkSecretKeyCurve25519(byte[] curve) {
            Checker.checkExpectedMemorySize("curve25519 sk length", curve.length, 32);
        }

        public static void checkSecretKeyEd25519(byte[] curve) {
            Checker.checkExpectedMemorySize("ed25519 sk length", curve.length, 64);
        }
    }

    public static class StateCryptoSign
    extends Structure {
        public Hash.State512 hs;

        protected List<String> getFieldOrder() {
            return Arrays.asList("hs");
        }

        public StateCryptoSign clone() {
            StateCryptoSign state2 = new StateCryptoSign();
            state2.hs.count = (long[])this.hs.count.clone();
            state2.hs.state = (long[])this.hs.state.clone();
            state2.hs.buf = (byte[])this.hs.buf.clone();
            return state2;
        }
    }

    public static interface Lazy {
        public KeyPair cryptoSignKeypair() throws SodiumException;

        public KeyPair cryptoSignSeedKeypair(byte[] var1) throws SodiumException;

        public KeyPair cryptoSignSecretKeyPair(Key var1) throws SodiumException;

        public String cryptoSign(String var1, String var2) throws SodiumException;

        public String cryptoSign(String var1, Key var2) throws SodiumException;

        public String cryptoSignOpen(String var1, Key var2);

        public String cryptoSignDetached(String var1, Key var2) throws SodiumException;

        public boolean cryptoSignVerifyDetached(String var1, String var2, Key var3);

        public KeyPair convertKeyPairEd25519ToCurve25519(KeyPair var1) throws SodiumException;

        public byte[] cryptoSignEd25519SkToSeed(Key var1) throws SodiumException;
    }

    public static interface Native {
        public boolean cryptoSignInit(StateCryptoSign var1);

        public boolean cryptoSignUpdate(StateCryptoSign var1, byte[] var2, int var3);

        public boolean cryptoSignFinalCreate(StateCryptoSign var1, byte[] var2, byte[] var3);

        public boolean cryptoSignFinalVerify(StateCryptoSign var1, byte[] var2, byte[] var3);

        public boolean cryptoSignKeypair(byte[] var1, byte[] var2);

        public boolean cryptoSignSeedKeypair(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoSign(byte[] var1, byte[] var2, int var3, byte[] var4);

        public boolean cryptoSignOpen(byte[] var1, byte[] var2, int var3, byte[] var4);

        public boolean cryptoSignDetached(byte[] var1, byte[] var2, int var3, byte[] var4);

        public boolean cryptoSignVerifyDetached(byte[] var1, byte[] var2, int var3, byte[] var4);

        public boolean convertPublicKeyEd25519ToCurve25519(byte[] var1, byte[] var2);

        public boolean convertSecretKeyEd25519ToCurve25519(byte[] var1, byte[] var2);

        public boolean cryptoSignEd25519SkToSeed(byte[] var1, byte[] var2);

        public boolean cryptoSignEd25519SkToPk(byte[] var1, byte[] var2);
    }
}

