/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.utils;

import com.sun.jna.NativeLong;

public class BaseChecker {
    public static void checkBetween(String name, long num, long min, long max) {
        if (num < min) {
            throw new IllegalArgumentException("Provided " + name + " is below minimum bound.");
        }
        if (num > max) {
            throw new IllegalArgumentException("Provided " + name + " is above maximum bound.");
        }
    }

    public static void checkBetween(String name, NativeLong num, NativeLong min, NativeLong max) {
        BaseChecker.checkBetween(name, num.longValue(), min.longValue(), max.longValue());
    }

    public static void checkAtLeast(String name, long num, long min) {
        if (num < min) {
            throw new IllegalArgumentException("Provided " + name + " is below minimum bound.");
        }
    }

    public static boolean isBetween(long num, long min, long max) {
        return min <= num && num <= max;
    }

    public static boolean correctLen(long num, long len) {
        return num == len;
    }

    public static void checkEqual(String name, int actual, int expected) {
        if (actual != expected) {
            throw new IllegalArgumentException("Provided " + name + " did not match expected value");
        }
    }

    public static void checkExpectedMemorySize(String name, int actual, int expected) {
        BaseChecker.checkEqual(name, expected, actual);
    }

    public static void checkArrayLength(String name, byte[] array, int length) {
        BaseChecker.checkArrayLength(name, array.length, length);
    }

    public static void checkOptionalArrayLength(String name, byte[] array, int length) {
        if (array == null) {
            if (length != 0) {
                throw new IllegalArgumentException("Provided non-zero length for null " + name);
            }
        } else {
            BaseChecker.checkArrayLength(name, array.length, length);
        }
    }

    private static void checkArrayLength(String name, int arrayLength, int length) {
        if (length > arrayLength) {
            throw new IllegalArgumentException("Provided " + name + " array length is larger than array");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Provided " + name + " array length is negative");
        }
    }

    public static void checkOptionalOutPointer(String name, byte[] refArray) {
        if (refArray != null && refArray.length == 0) {
            throw new IllegalArgumentException("Provided " + name + " must be either null or non-empty");
        }
    }

    public static void checkOptionalOutPointer(String name, long[] refArray) {
        if (refArray != null && refArray.length == 0) {
            throw new IllegalArgumentException("Provided " + name + " must be either null or non-empty");
        }
    }

    public static void requireNonNull(String name, Object state) {
        if (state == null) {
            throw new IllegalArgumentException("Provided " + name + " must not be null");
        }
    }
}

