/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl;

import cz.muni.fi.mathml.MathMLElement;
import cz.muni.fi.mathml.mathml2text.converter.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.XmlAttribute;
import cz.muni.fi.mathml.mathml2text.converter.impl.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.impl.Node;
import cz.muni.fi.mathml.mathml2text.converter.numbers.NumberFormat;
import cz.muni.fi.mathml.mathml2text.converter.numbers.NumberTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathMLConverter {
    private static final Logger logger = LoggerFactory.getLogger(MathMLConverter.class);
    @Nonnull
    private Map<Locale, Properties> localizationMap = new HashMap<Locale, Properties>();
    private NumberTransformer numberTransformer;
    private Properties currentLocalization;
    private NumberFormat numberFormat = NumberFormat.CARDINAL;

    private Properties getLocalization(Locale locale) {
        if (this.localizationMap.get(locale) == null) {
            Properties properties = new Properties();
            InputStream resourceAsStream = this.getClass().getResourceAsStream(String.format("%1$s.xml", locale.getLanguage()));
            try {
                properties.loadFromXML(resourceAsStream);
                this.localizationMap.put(locale, properties);
            }
            catch (IOException ex) {
                logger.error(String.format("Cannot load properties for language [%1$s].", locale.getLanguage()), (Throwable)ex);
            }
        }
        return this.localizationMap.get(locale);
    }

    protected String getProperty(String key) {
        return this.currentLocalization.getProperty(key) + " ";
    }

    protected NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    protected void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    protected NumberTransformer getNumberTransformer() {
        return this.numberTransformer;
    }

    public List<String> convert(List<MathMLNode> nodeList, Locale language) {
        ArrayList<MathMLNode> checked = new ArrayList<MathMLNode>();
        for (MathMLNode node : nodeList) {
            if (MathMLElement.MATH.equals((Object)node.getType())) {
                checked.add(node);
                continue;
            }
            logger.debug(String.format("Expected [math] node, but got [%1$s].", node.getType().getElementName()));
        }
        this.numberTransformer = new NumberTransformer(language);
        this.currentLocalization = this.getLocalization(language);
        ConverterSettings settings = new ConverterSettings();
        settings.setLocalization(this.currentLocalization);
        settings.setNumberTransformer(this.numberTransformer);
        ArrayList<String> converted = new ArrayList<String>(checked.size());
        for (MathMLNode root : checked) {
            MathMLNode nodeToProcess = this.getNodeForProcessing(root);
            converted.add(Node.process(nodeToProcess, settings));
        }
        return converted;
    }

    public String convert(MathMLNode node, Locale language) {
        if (!MathMLElement.MATH.equals((Object)node.getType())) {
            throw new IllegalStateException(String.format("Expected [math] node, but got [%1$s].", node.getType().getElementName()));
        }
        this.numberTransformer = new NumberTransformer(language);
        this.currentLocalization = this.getLocalization(language);
        ConverterSettings settings = new ConverterSettings();
        settings.setLocalization(this.currentLocalization);
        settings.setNumberTransformer(this.numberTransformer);
        MathMLNode nodeToProcess = this.getNodeForProcessing(node);
        return Node.process(nodeToProcess, settings);
    }

    private boolean chooseMathMLTypeToUse(MathMLNode node) {
        for (MathMLNode child : node.getChildren()) {
            if (MathMLElement.SEMANTICS.equals((Object)child.getType())) {
                for (MathMLNode semanticsChild : child.getChildren()) {
                    if (!MathMLElement.ANNOTATION_XML.equals((Object)semanticsChild.getType())) continue;
                    for (XmlAttribute attr : semanticsChild.getAttributes()) {
                        if (!"encoding".equals(attr.getKey()) || !"MathML-Content".equals(attr.getValue())) continue;
                        return true;
                    }
                }
                continue;
            }
            if (!MathMLElement.ANNOTATION_XML.equals((Object)child.getType())) continue;
            for (XmlAttribute attr : child.getAttributes()) {
                if (!"encoding".equals(attr.getKey()) || !"MathML-Content".equals(attr.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private MathMLNode getNodeForProcessing(MathMLNode node) {
        for (MathMLNode child : node.getChildren()) {
            if (MathMLElement.SEMANTICS.equals((Object)child.getType())) {
                for (MathMLNode semanticsChild : child.getChildren()) {
                    if (!MathMLElement.ANNOTATION_XML.equals((Object)semanticsChild.getType())) continue;
                    for (XmlAttribute attr : semanticsChild.getAttributes()) {
                        if (!"encoding".equals(attr.getKey()) || !"MathML-Content".equals(attr.getValue()) || semanticsChild.getChildren().isEmpty()) continue;
                        return semanticsChild;
                    }
                }
                continue;
            }
            if (!MathMLElement.ANNOTATION_XML.equals((Object)child.getType())) continue;
            for (XmlAttribute attr : child.getAttributes()) {
                if (!"encoding".equals(attr.getKey()) || !"MathML-Content".equals(attr.getValue()) || child.getChildren().isEmpty()) continue;
                return child;
            }
        }
        return node;
    }
}

