/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl.presentation;

import cz.muni.fi.mathml.MathMLElement;
import cz.muni.fi.mathml.mathml2text.converter.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.impl.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.impl.Node;
import cz.muni.fi.mathml.mathml2text.converter.impl.Operation;

public final class Munderover {
    public static String process(MathMLNode node, ConverterSettings settings) {
        if (node.getChildren().size() != 3) {
            throw new IllegalArgumentException("[munderover] should have three children.");
        }
        StringBuilder builder = new StringBuilder();
        String possibleOperation = node.getChildren().get(0).getValue();
        if (Operation.INTEGRAL.getSymbols().contains(possibleOperation)) {
            builder.append(settings.getProperty("integral_definite"));
            builder.append(Node.process(node.getChildren().get(0), settings));
            builder.append(settings.getProperty("from"));
            builder.append(Node.process(node.getChildren().get(1), settings));
            builder.append(settings.getProperty("to"));
            builder.append(Node.process(node.getChildren().get(2), settings));
            builder.append(settings.getProperty("of"));
            MathMLNode firstSibling = node.getParent().getChildren().get(1);
            if (firstSibling != null) {
                builder.append(Node.process(firstSibling, settings));
            }
        } else if (Operation.SUMMATION.getSymbols().contains(possibleOperation) || Operation.PRODUCT.getSymbols().contains(possibleOperation)) {
            MathMLNode identifier;
            builder.append(Node.process(node.getChildren().get(0), settings));
            MathMLNode mathMLNode = identifier = !node.getChildren().get(1).getChildren().isEmpty() ? node.getChildren().get(1).getChildren().get(0) : null;
            if (identifier != null && MathMLElement.MI.equals((Object)identifier.getType())) {
                builder.append(settings.getProperty("over"));
                builder.append(Node.process(identifier, settings));
                builder.append(settings.getProperty("from"));
                node.getChildren().get(1).getChildren().get(1).setProcessed();
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(settings.getProperty("to"));
                builder.append(Node.process(node.getChildren().get(2), settings));
                builder.append(settings.getProperty("of"));
                MathMLNode firstSibling = node.getParent().getChildren().get(1);
                if (firstSibling != null) {
                    builder.append(Node.process(firstSibling, settings));
                }
            } else {
                builder.append(settings.getProperty("from"));
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(settings.getProperty("to"));
                builder.append(Node.process(node.getChildren().get(2), settings));
                builder.append(settings.getProperty("of"));
                MathMLNode firstSibling = node.getParent().getChildren().get(1);
                if (firstSibling != null) {
                    builder.append(Node.process(firstSibling, settings));
                }
            }
        }
        return builder.toString();
    }
}

