/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text;

import cz.muni.fi.mathml.mathml2text.converter.impl.XmlParserStAX;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static final Logger logger = LoggerFactory.getLogger(App.class);
    private static final Set<String> SUPPORTED_LANGUAGES = new HashSet<String>(3);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please specify input file path.");
            System.exit(1);
        }
        int fileArg = 0;
        String language = "en";
        if (args.length > 1) {
            if (!"-l".equals(args[0])) {
                System.out.println("Unknow parameter [" + args[0] + "].");
                System.exit(1);
            }
            if (!SUPPORTED_LANGUAGES.contains(language = args[1])) {
                System.out.println("Unsupported language.");
                System.exit(1);
            }
            fileArg = 2;
        }
        File input = new File(args[fileArg]);
        Instant start = Instant.now();
        XmlParserStAX parser = new XmlParserStAX();
        File parse = parser.parse(input, new Locale(language));
        Instant end = Instant.now();
        Duration duration = new Duration((ReadableInstant)start, (ReadableInstant)end);
        System.out.println("\n" + duration.getMillis() + " ms");
    }

    static {
        SUPPORTED_LANGUAGES.add("en");
        SUPPORTED_LANGUAGES.add("sk");
        SUPPORTED_LANGUAGES.add("cs");
    }
}

