/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;

public enum Symbol {
    ALPHA("alpha", "alpha", "&alpha;", "Alpha", "&Alpha;", "&#x391;", "&#x3B1;", "&#913;", "&#945;"),
    BETA("beta", "beta", "&beta;", "Beta", "&Beta;", "&#x392;", "&#x3B2;", "&#914;", "&#946;"),
    GAMMA("gamma", "gamma", "&gamma;", "Gamma", "&Gamma;", "&#x393;", "&#x3B3;", "&#915;", "&#947;"),
    DELTA("delta", "delta", "&delta;", "Delta", "&Delta;", "&#x394;", "&#x3B4;", "&#916;", "&#948;"),
    EPSILON("epsilon", "epsilon", "&epsilon;", "Epsilon", "&Epsilon;", "&#x395;", "&#x3B5;", "&#917;", "&#949;"),
    ZETA("zeta", "zeta", "&zeta;", "Zeta", "&Zeta;", "&#x396;", "&#x3B6;", "&#918;", "&#950;"),
    ETA("eta", "eta", "&eta;", "Eta", "&Eta;", "&#x397;", "&#x3B7;", "&#919;", "&#951;"),
    THETA("theta", "theta", "&theta;", "Theta", "&Theta;", "&#x398;", "&#x3B8;", "&#920;", "&#952;"),
    IOTA("iota", "iota", "&iota;", "Iota", "&Iota;", "&#x399;", "&#x3B9;", "&#921;", "&#953;"),
    KAPPA("kappa", "kappa", "&kappa;", "Kappa", "&Kappa;", "&#x39A;", "&#x3BA;", "&#922;", "&#954;"),
    LAMBDA("lambda", "lambda", "&lambda;", "Lambda", "&Lambda;", "&#x39B;", "&#x3BB;", "&#923;", "&#955;"),
    MU("mu", "mu", "&mu;", "Mu", "&Mu;", "&#x39C;", "&#x3BC;", "&#924;", "&#956;"),
    NU("nu", "nu", "&nu;", "Nu", "&Nu;", "&#x39D;", "&#x3BD;", "&#925;", "&#957;"),
    XI("xi", "xi", "&xi;", "Xi", "&Xi;", "&#x39E;", "&#x3BE;", "&#926;", "&#958;"),
    OMICRON("omicron", "omicron", "&omicron;", "Omicron", "&Omicron;", "&#x39F;", "&#x3BF;", "&#927;", "&#959;"),
    PI("pi", "pi", "&pi;", "Pi", "&Pi;", "&#x3A0;", "&#x3C0;", "&#928;", "&#960;"),
    RHO("rho", "rho", "&rho;", "Rho", "&Rho;", "&#x3A1;", "&#x3C1;", "&#929;", "&#961;"),
    SIGMA("sigma", "sigma", "&sigma;", "Sigma", "&Simga;", "sigmaf", "&sigmaf;", "&#x3A3;", "&#x3C3;", "&#931;", "&#963;", "&#x3C2;", "&#962;"),
    TAU("tau", "tau", "&tau;", "Tau", "&Tau;", "&#x3A4;", "&#x3C4;", "&#932;", "&#964;"),
    UPSILON("upsilon", "upsilon", "&upsilon;", "Upsilon", "&Upsilon;", "&#x3A5;", "&#x3C5;", "&#933;", "&#965;"),
    PHI("phi", "phi", "&phi;", "Phi", "&Phi;", "&#x3A6;", "&#x3C6;", "&#934;", "&#966;"),
    CHI("chi", "chi", "&chi;", "Chi", "&Chi;", "&#x3A7;", "&#x3C7;", "&#935;", "&#967;"),
    PSI("psi", "psi", "&psi;", "Psi", "&Psi;", "&#x3A8;", "&#x3C8;", "&#936;", "&#968;"),
    OMEGA("omega", "omega", "&omega;", "Omega", "&Omega;", "&#x3A9;", "&#x3C9;", "&#937;", "&#969;");

    private final String key;
    private final Collection<String> values;

    private Symbol(String key, String ... values) {
        this.key = key;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])values);
        this.values = builder.build();
    }

    public String getKey() {
        return this.key;
    }

    public static Symbol forValue(String value) {
        for (Symbol s : Symbol.values()) {
            if (!s.values.contains(value)) continue;
            return s;
        }
        return null;
    }
}

