/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl.presentation;

import cz.muni.fi.mathml.mathml2text.converter.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.impl.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.impl.Node;
import cz.muni.fi.mathml.mathml2text.converter.impl.Operation;
import org.slf4j.LoggerFactory;

public final class Munder {
    public static String process(MathMLNode node, ConverterSettings settings) {
        if (node.getChildren().size() != 2) {
            throw new IllegalArgumentException("[munder] should have two children.");
        }
        StringBuilder builder = new StringBuilder();
        if (Operation.LIMIT.getSymbols().contains(node.getChildren().get(0).getValue())) {
            builder.append(Node.process(node.getChildren().get(0), settings));
            MathMLNode firstSibling = null;
            for (int index = 0; index < node.getParent().getChildren().size(); ++index) {
                if (!node.equals(node.getParent().getChildren().get(index))) continue;
                try {
                    firstSibling = node.getParent().getChildren().get(index + 1);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    LoggerFactory.getLogger(Munder.class).warn("No next sibling for [munder].");
                }
            }
            if (firstSibling != null) {
                builder.append(Node.process(firstSibling, settings));
            }
            builder.append(settings.getProperty("limit_as"));
            builder.append(Node.process(node.getChildren().get(1), settings));
        } else {
            builder.append(Node.process(node.getChildren().get(0), settings));
            builder.append(settings.getProperty("subscript"));
            builder.append(Node.process(node.getChildren().get(1), settings));
        }
        return builder.toString();
    }
}

