/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml;

import cz.muni.fi.mathml.MathMLType;

public enum MathMLElement {
    MATH("math", MathMLType.PRESENTATION),
    MROW("mrow", MathMLType.PRESENTATION),
    MN("mn", MathMLType.PRESENTATION),
    MI("mi", MathMLType.PRESENTATION),
    MO("mo", MathMLType.PRESENTATION),
    MFRAC("mfrac", MathMLType.PRESENTATION),
    MSUB("msub", MathMLType.PRESENTATION),
    MSUP("msup", MathMLType.PRESENTATION),
    MSUBSUP("msubsup", MathMLType.PRESENTATION),
    MUNDER("munder", MathMLType.PRESENTATION),
    MOVER("mover", MathMLType.PRESENTATION),
    MUNDEROVER("munderover", MathMLType.PRESENTATION),
    MSQRT("msqrt", MathMLType.PRESENTATION),
    MROOT("mroot", MathMLType.PRESENTATION),
    MFENCED("mfenced", MathMLType.PRESENTATION),
    MS("ms", MathMLType.PRESENTATION),
    MTEXT("mtext", MathMLType.PRESENTATION),
    MSPACE("mspace", MathMLType.PRESENTATION),
    MTABLE("mtable", MathMLType.PRESENTATION),
    MTR("mtr", MathMLType.PRESENTATION),
    MTD("mtd", MathMLType.PRESENTATION),
    SEMANTICS("semantics", MathMLType.OTHER),
    ANNOTATION_XML("annotation-xml", MathMLType.OTHER),
    CN("cn", MathMLType.CONTENT),
    CI("ci", MathMLType.CONTENT),
    CSYMBOL("csymbol", MathMLType.CONTENT),
    APPLY("apply", MathMLType.CONTENT),
    QUOTIENT("quotient", MathMLType.CONTENT_BEFORE_MIDDLE),
    FACTORIAL("factorial", MathMLType.CONTENT_GROUP),
    DIVIDE("divide", MathMLType.CONTENT_MIDDLE),
    MAX("max", MathMLType.CONTENT_GROUP),
    MIN("min", MathMLType.CONTENT_GROUP),
    MINUS("minus", MathMLType.CONTENT_MIDDLE),
    PLUS("plus", MathMLType.CONTENT_MIDDLE),
    POWER("power", MathMLType.CONTENT),
    REM("rem", MathMLType.CONTENT_BEFORE_MIDDLE),
    TIMES("times", MathMLType.CONTENT_MIDDLE),
    ROOT("root", MathMLType.CONTENT),
    DEGREE("degree", MathMLType.CONTENT),
    GCD("gcd", MathMLType.CONTENT_GROUP),
    AND("and", MathMLType.CONTENT_MIDDLE),
    OR("or", MathMLType.CONTENT_MIDDLE),
    XOR("xor", MathMLType.CONTENT_MIDDLE),
    NOT("not", MathMLType.CONTENT_BEFORE),
    IMPLIES("implies", MathMLType.CONTENT_MIDDLE),
    FORALL("forall", MathMLType.CONTENT),
    EXISTS("exists", MathMLType.CONTENT),
    ABS("abs", MathMLType.CONTENT_BEFORE),
    CONJUGATE("conjugate", MathMLType.CONTENT),
    ARG("arg", MathMLType.CONTENT),
    REAL("real", MathMLType.CONTENT),
    IMAGINARY("imaginary", MathMLType.CONTENT),
    LCM("lcm", MathMLType.CONTENT_GROUP),
    FLOOR("floor", MathMLType.CONTENT_BEFORE),
    CEILING("ceiling", MathMLType.CONTENT_BEFORE),
    EQ("eq", MathMLType.CONTENT_MIDDLE),
    NEQ("neq", MathMLType.CONTENT_MIDDLE),
    GT("gt", MathMLType.CONTENT_MIDDLE),
    LT("lt", MathMLType.CONTENT_MIDDLE),
    GEQ("geq", MathMLType.CONTENT_MIDDLE),
    LEQ("leq", MathMLType.CONTENT_MIDDLE),
    EQUIVALENT("equivalent", MathMLType.CONTENT_MIDDLE),
    APPROX("approx", MathMLType.CONTENT_MIDDLE),
    FACTOROF("factorof", MathMLType.CONTENT_MIDDLE),
    INT("int", MathMLType.CONTENT),
    DIFF("diff", MathMLType.CONTENT),
    PARTIALDIFF("partialdiff", MathMLType.CONTENT),
    DIVERGENCE("divergence", MathMLType.CONTENT),
    GRAD("grad", MathMLType.CONTENT),
    CURL("curl", MathMLType.CONTENT),
    LAPLACIAN("laplacian", MathMLType.CONTENT),
    SET("set", MathMLType.CONTENT_GROUP),
    LIST("list", MathMLType.CONTENT_GROUP),
    UNION("union", MathMLType.CONTENT_MIDDLE),
    INTERSECT("intersect", MathMLType.CONTENT_MIDDLE),
    IN("in", MathMLType.CONTENT_MIDDLE),
    NOTIN("notin", MathMLType.CONTENT_MIDDLE),
    SUBSET("subset", MathMLType.CONTENT_MIDDLE),
    PRSUBSET("prsubset", MathMLType.CONTENT_MIDDLE),
    NOTSUBSET("notsubset", MathMLType.CONTENT_MIDDLE),
    NOTPRSUBSET("notprsubset", MathMLType.CONTENT_MIDDLE),
    SETDIFF("setdiff", MathMLType.CONTENT_MIDDLE),
    CARD("card", MathMLType.CONTENT_BEFORE),
    CARTESIANPRODUCT("cartesianproduct", MathMLType.CONTENT),
    SUM("sum", MathMLType.CONTENT),
    PRODUCT("product", MathMLType.CONTENT),
    LIMIT("limit", MathMLType.CONTENT),
    TENDSTO("tendsto", MathMLType.CONTENT),
    SIN("sin", MathMLType.CONTENT_TRIGONOMETRY),
    COS("cos", MathMLType.CONTENT_TRIGONOMETRY),
    TAN("tan", MathMLType.CONTENT_TRIGONOMETRY),
    SEC("sec", MathMLType.CONTENT_TRIGONOMETRY),
    CSC("csc", MathMLType.CONTENT_TRIGONOMETRY),
    COT("cot", MathMLType.CONTENT_TRIGONOMETRY),
    SINH("sinh", MathMLType.CONTENT_TRIGONOMETRY),
    COSH("cosh", MathMLType.CONTENT_TRIGONOMETRY),
    TANH("tanh", MathMLType.CONTENT_TRIGONOMETRY),
    SECH("sech", MathMLType.CONTENT_TRIGONOMETRY),
    CSCH("csch", MathMLType.CONTENT_TRIGONOMETRY),
    COTH("coth", MathMLType.CONTENT_TRIGONOMETRY),
    ARCSIN("arcsin", MathMLType.CONTENT_TRIGONOMETRY),
    ARCCOS("arccos", MathMLType.CONTENT_TRIGONOMETRY),
    ARCTAN("arctan", MathMLType.CONTENT_TRIGONOMETRY),
    ARCCOSH("arccosh", MathMLType.CONTENT_TRIGONOMETRY),
    ARCCOT("arccot", MathMLType.CONTENT_TRIGONOMETRY),
    ARCCOTH("arccoth", MathMLType.CONTENT_TRIGONOMETRY),
    ARCCSC("arccsc", MathMLType.CONTENT_TRIGONOMETRY),
    ARCCSCH("arccsch", MathMLType.CONTENT_TRIGONOMETRY),
    ARCSEC("arcsec", MathMLType.CONTENT_TRIGONOMETRY),
    ARCSECH("arcsech", MathMLType.CONTENT_TRIGONOMETRY),
    ARCSINH("arcsinh", MathMLType.CONTENT_TRIGONOMETRY),
    ARCTANH("arctanh", MathMLType.CONTENT_TRIGONOMETRY),
    EXP("exp", MathMLType.CONTENT_BEFORE),
    LN("ln", MathMLType.CONTENT_BEFORE),
    LOG("log", MathMLType.CONTENT),
    LOGBASE("logbase", MathMLType.CONTENT),
    INTEGERS("integers", MathMLType.CONTENT),
    REALS("reals", MathMLType.CONTENT),
    RATIONALS("rationals", MathMLType.CONTENT),
    NATURALNUMBERS("naturalnumbers", MathMLType.CONTENT),
    COMPLEXES("complexes", MathMLType.CONTENT),
    PRIMES("primes", MathMLType.CONTENT),
    EXPONENTIALE("exponentiale", MathMLType.CONTENT),
    IMAGINARYI("imaginaryi", MathMLType.CONTENT),
    NOTANUMBER("notanumber", MathMLType.CONTENT),
    TRUE("true", MathMLType.CONTENT),
    FALSE("false", MathMLType.CONTENT),
    EMPTYSET("emptyset", MathMLType.CONTENT),
    PI("pi", MathMLType.CONTENT),
    EULERGAMMA("eulergamma", MathMLType.CONTENT),
    INFINITY("infinity", MathMLType.CONTENT),
    INTERVAL("interval", MathMLType.CONTENT),
    COMPOSE("compose", MathMLType.CONTENT),
    VECTOR("vector", MathMLType.CONTENT),
    UNKNOWN("unknown", MathMLType.OTHER);

    private final String elementName;
    private final MathMLType type;

    private MathMLElement(String elementName, MathMLType type) {
        this.elementName = elementName;
        this.type = type;
    }

    public String getElementName() {
        return this.elementName;
    }

    public MathMLType getType() {
        return this.type;
    }

    public static MathMLElement forElementName(String elementName) {
        for (MathMLElement element : MathMLElement.values()) {
            if (!element.getElementName().equals(elementName)) continue;
            return element;
        }
        return UNKNOWN;
    }
}

