/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter;

import cz.muni.fi.mathml.MathMLElement;
import cz.muni.fi.mathml.mathml2text.converter.XmlAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MathMLNode {
    private MathMLElement type;
    private List<MathMLNode> children = new ArrayList<MathMLNode>();
    private String value;
    private MathMLNode parent;
    private boolean processed = false;
    @Nonnull
    private Set<XmlAttribute> attributes = new HashSet<XmlAttribute>();

    public MathMLNode getParent() {
        return this.parent;
    }

    public void setParent(MathMLNode parent) {
        this.parent = parent;
    }

    public MathMLElement getType() {
        return this.type;
    }

    public void setType(MathMLElement type) {
        this.type = type;
    }

    @Nonnull
    public List<MathMLNode> getChildren() {
        return this.children;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Nonnull
    public Set<XmlAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed() {
        this.processed = true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type.getElementName());
        for (XmlAttribute attr : this.attributes) {
            builder.append("\t");
            builder.append(attr.toString());
        }
        if (!this.attributes.isEmpty()) {
            builder.append("\n");
        }
        if (this.value != null) {
            builder.append("\t");
            builder.append("value=");
            builder.append(this.value);
        } else {
            for (MathMLNode node : this.children) {
                builder.append("\n");
                builder.append("\t");
                builder.append(node.toString());
                builder.append("\n");
            }
        }
        return builder.toString();
    }
}

