/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl;

import com.google.common.collect.Sets;
import cz.muni.fi.mathml.mathml2text.converter.numbers.NumberFormat;
import cz.muni.fi.mathml.mathml2text.converter.numbers.NumberTransformer;
import java.util.Properties;
import java.util.Set;

public final class ConverterSettings {
    private Properties localization;
    private NumberTransformer numberTransformer;
    private boolean replaceSpaces = false;
    private boolean canonicalize = true;
    private static final ConverterSettings INSTANCE = new ConverterSettings();

    private ConverterSettings() {
    }

    public static ConverterSettings getInstance() {
        return INSTANCE;
    }

    public Properties getLocalization() {
        return this.localization;
    }

    public void setLocalization(Properties localization) {
        this.localization = localization;
    }

    public NumberTransformer getNumberTransformer() {
        return this.numberTransformer;
    }

    public void setNumberTransformer(NumberTransformer numberTransformer) {
        this.numberTransformer = numberTransformer;
    }

    public NumberFormat getNumberFormat() {
        return this.getNumberTransformer().getNumberFormat();
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.getNumberTransformer().setNumberFormat(numberFormat);
    }

    public String getProperty(String key) {
        String result = this.getLocalization().getProperty(key);
        if (this.isReplaceSpaces()) {
            result = result.replace(" ", "_");
        }
        return result + " ";
    }

    public boolean isReplaceSpaces() {
        return this.replaceSpaces;
    }

    public void setReplaceSpaces(boolean replaceSpaces) {
        this.replaceSpaces = replaceSpaces;
    }

    public boolean isCanonicalize() {
        return this.canonicalize;
    }

    public void setCanonicalize(boolean canonicalize) {
        this.canonicalize = canonicalize;
    }

    public Set<String> getSupportedLanguages() {
        return Sets.newHashSet((Object[])new String[]{"en", "cs", "sk"});
    }
}

