/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;

public enum Operation {
    ADD("plus", "+", "&plus;", "plus"),
    SUBTRACT("minus", "-", "&minus;", "minus"),
    MULTIPLY("times", "&times;", "*", "times", "&sdot;"),
    DIVIDE("divide", "/", "&divide;", "divide", ":"),
    EQUALS("equals", "=", "eq"),
    LOGARITHM("logarithm", "log"),
    NATURAL_LOGARITHM("naturalLogarithm", "ln"),
    SQUARE("square", "2"),
    LIMIT("limit", "lim"),
    APPROACHES("approaches", "&rarr;", "rarr", "\u2192"),
    INTEGRAL("integral", "int", "&int;"),
    DIFFERENTIAL("differential", "dd", "&dd;"),
    SUMMATION("summation", "sum", "&sum;"),
    PRODUCT("product", "prod", "&prod;", "\u220f", "&amp;prod;"),
    SIN("sin", "sin"),
    COS("cos", "cos"),
    TAN("tan", "tan"),
    SEC("sec", "sec"),
    CSC("csc", "csc"),
    COT("cot", "cot"),
    SINH("sinh", "sinh"),
    COSH("cosh", "cosh"),
    TANH("tanh", "tanh"),
    SECH("sech", "sech"),
    CSCH("csch", "csch"),
    COTH("coth", "coth"),
    ARCSIN("arcsin", "arcsin"),
    ARCCOS("arccos", "arccos"),
    ARCTAN("arctan", "arctan"),
    ARCCOSH("arccosh", "arccosh"),
    ARCCOT("arccot", "arccot"),
    ARCCOTH("arccoth", "arccoth"),
    ARCCSC("arccsc", "arccsc"),
    ARCCSCH("arccsch", "arccsch"),
    ARCSEC("arcsec", "arcsec"),
    ARCSECH("arcsech", "arcsech"),
    ARCSINH("arcsinh", "arcsinh"),
    ARCTANH("arctanh", "arctanh"),
    NOT_EQUAL_TO("neq", "neq", "&neq;"),
    GREATER_THAN("gt", "gt", "&gt;"),
    LOWER_THAN("lt", "lt", "&lt;"),
    GREATER_THAN_OR_EQUAL_TO("geq", "geq", "&geq;"),
    LOWER_THAN_OR_EQUAL_TO("leq", "leq", "&leq;"),
    EQUIVALENT_TO("equivalent", "equivalent", "&hArr;"),
    APPROXIMATELY("approx", "approx"),
    AND("and", "and"),
    OR("or", "or"),
    XOR("xor", "xor"),
    IMPLIES("implies", "implies"),
    FACTOR_OF("factorof", "factorof"),
    UNION("union", "union"),
    INTERSECT("intersect", "intersect"),
    IN("in", "in", "\u2208", "&isin;"),
    NOTIN("notin", "notin"),
    SUBSET("subset", "subset", "\u2282", "&sub;"),
    PRSUBSET("prsubset", "prsubset"),
    NOTSUBSET("notsubset", "notsubset"),
    NOTPRSUBSET("notprsubset", "notprsubset"),
    SETDIFF("setdiff", "setdiff"),
    NOT("not", "not"),
    ABSOLUTE_VALUE("abs", "abs"),
    FLOOR("floor", "floor"),
    CEILING("ceiling", "ceiling"),
    EXPONENTIAL("exp", "exp"),
    CARDINALITY("card", "card"),
    REMAINDER("rem", "rem"),
    QUOTIENT("quotient", "quotient"),
    EXPONENTIATION("power", "power"),
    ROOT("root", "root"),
    OPEN_BRACES("open_braces", "("),
    CLOSE_BRACES("close_braces", ")"),
    SUPERSCRIPT("superscript", "superscript"),
    SUBSCRIPT("subscript", "subscript"),
    CI("ci", new String[0]),
    ASSIGN("assign", ":="),
    TILDE("tilde", "~"),
    DASHED("dashed", "\u00af"),
    INTERVAL("interval", "interval"),
    COMPOSE("compose", "compose"),
    VECTOR("vector", "vector"),
    DIRECT_SUM("direct_sum", "&oplus;", "\u2295");

    private final String key;
    private final Collection<String> symbols;

    private Operation(String key, String ... symbols) {
        this.key = key;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])symbols);
        this.symbols = builder.build();
    }

    public String getKey() {
        return this.key;
    }

    public Collection<String> getSymbols() {
        return this.symbols;
    }

    public static Operation forSymbol(String symbol) {
        for (Operation operation : Operation.values()) {
            if (!operation.getSymbols().contains(symbol)) continue;
            return operation;
        }
        return null;
    }
}

