/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl;

import cz.muni.fi.mathml.MathMLElement;
import cz.muni.fi.mathml.mathml2text.converter.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.XmlAttribute;
import cz.muni.fi.mathml.mathml2text.converter.impl.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.impl.MathMLConverter;
import cz.muni.fi.mathml.mathml2text.converter.impl.UnsupportedLanguageException;
import cz.muni.fi.mathml.mathml2text.converter.impl.XmlStreamConstant;
import cz.muni.fi.mir.mathmlcanonicalization.MathMLCanonizer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.ElementMinimizer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.MfencedReplacer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.Module;
import cz.muni.fi.mir.mathmlcanonicalization.modules.MrowNormalizer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.OperatorNormalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlParserStAX {
    private final Logger logger = LoggerFactory.getLogger(XmlParserStAX.class);
    private MathMLConverter converter = new MathMLConverter();
    private XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private XMLOutputFactory xmlOutputFactory;
    private static final String CONVERTER_NAMESPACE_URI = "http://code.google.com/p/mathml-converter/";
    private static final String CONVERTER_NAMESPACE_PREFIX = "conv";
    private static final String CONVERTER_ELEMENT_NAME = "math";

    public XmlParserStAX() {
        this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.resolver", new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                if (systemID.endsWith("dtd")) {
                    return XmlParserStAX.class.getResourceAsStream("xhtml-math11-f.dtd");
                }
                return null;
            }
        });
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
    }

    private Logger getLogger() {
        return this.logger;
    }

    public String parse(@Nonnull String inputString, Locale language) throws UnsupportedLanguageException {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)inputString));
        this.checkSupportedLanguages(language);
        MathMLNode tree = null;
        MathMLNode currentNode = null;
        MathMLNode parentNode = null;
        MathMLElement currentElement = null;
        try {
            ByteArrayInputStream inputStream = ConverterSettings.getInstance().isCanonicalize() ? this.canonicalize(new ByteArrayInputStream(inputString.getBytes())) : new ByteArrayInputStream(inputString.getBytes());
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(inputStream, "UTF-8");
            StringBuilder output = new StringBuilder();
            boolean processingMathMLElement = false;
            while (reader.hasNext()) {
                int eventCode = reader.next();
                XmlStreamConstant constant = XmlStreamConstant.forEventCode(eventCode);
                if (!processingMathMLElement && !XmlStreamConstant.START_ELEMENT.equals((Object)constant)) continue;
                block1 : switch (constant) {
                    case START_ELEMENT: {
                        String elementName = reader.getLocalName();
                        if (!processingMathMLElement && !MathMLElement.MATH.getElementName().equals(elementName)) break;
                        currentElement = MathMLElement.forElementName(elementName);
                        processingMathMLElement = true;
                        currentNode = new MathMLNode();
                        currentNode.setType(currentElement);
                        for (int index = 0; index < reader.getAttributeCount(); ++index) {
                            currentNode.getAttributes().add(new XmlAttribute(reader.getAttributeLocalName(index), reader.getAttributeValue(index)));
                        }
                        if (parentNode != null) {
                            currentNode.setParent(parentNode);
                            parentNode.getChildren().add(currentNode);
                        }
                        if (tree == null) {
                            tree = currentNode;
                        }
                        parentNode = currentNode;
                        break;
                    }
                    case END_ELEMENT: {
                        currentNode = parentNode = currentNode.getParent();
                        String elementName = reader.getLocalName();
                        MathMLElement element = MathMLElement.forElementName(elementName);
                        switch (element) {
                            case MATH: {
                                String converted = this.converter.convert(tree, language);
                                output.append(converted);
                                processingMathMLElement = false;
                                currentElement = null;
                                tree = null;
                                currentNode = null;
                                parentNode = null;
                                break block1;
                            }
                        }
                        break;
                    }
                    case CHARACTERS: {
                        String value = reader.getText();
                        if (currentElement == null || !StringUtils.isNotBlank((CharSequence)value)) break;
                        currentNode.setValue(value);
                        break;
                    }
                    case ENTITY_REFERENCE: {
                        String value = reader.getLocalName();
                        if (currentElement == null || !StringUtils.isNotBlank((CharSequence)value)) break;
                        currentNode.setValue(value);
                        break;
                    }
                }
            }
            reader.close();
            return output.toString();
        }
        catch (XMLStreamException ex) {
            this.getLogger().error("Cannot open xml file for reading.", (Throwable)ex);
            return "";
        }
    }

    public File parse(@Nonnull File file, Locale language) {
        Validate.isTrue((file != null ? 1 : 0) != 0, (String)"File for transformation should not be null.", (Object[])new Object[0]);
        String filePath = file.getPath();
        String outputFilePath = filePath.substring(0, filePath.lastIndexOf(46));
        File outputFile = new File(outputFilePath + "-transformed.xml");
        try {
            outputFile.createNewFile();
        }
        catch (IOException ex) {
            this.getLogger().warn("File [{}] already exists.", (Object)outputFile.getPath());
        }
        MathMLNode tree = null;
        MathMLNode currentNode = null;
        MathMLNode parentNode = null;
        MathMLElement currentElement = null;
        try {
            FileInputStream inputStream = ConverterSettings.getInstance().isCanonicalize() ? this.canonicalize(new FileInputStream(file)) : new FileInputStream(file);
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(inputStream, "UTF-8");
            FileOutputStream output = new FileOutputStream(outputFile);
            XMLStreamWriter writer = this.xmlOutputFactory.createXMLStreamWriter(output, "UTF-8");
            writer.writeStartDocument(reader.getEncoding(), reader.getVersion());
            boolean isRoot = true;
            boolean processingMathMLElement = false;
            block21: while (reader.hasNext()) {
                int eventCode = reader.next();
                XmlStreamConstant constant = XmlStreamConstant.forEventCode(eventCode);
                if (!processingMathMLElement && !XmlStreamConstant.START_ELEMENT.equals((Object)constant)) {
                    switch (constant) {
                        case END_ELEMENT: {
                            writer.writeEndElement();
                            continue block21;
                        }
                        case CHARACTERS: {
                            writer.writeCharacters(reader.getText());
                            continue block21;
                        }
                        case DTD: {
                            writer.writeDTD(reader.getText());
                            continue block21;
                        }
                    }
                    continue;
                }
                block7 : switch (constant) {
                    case START_ELEMENT: {
                        String elementName = reader.getLocalName();
                        if (!processingMathMLElement && !MathMLElement.MATH.getElementName().equals(elementName)) {
                            int index;
                            writer.writeStartElement(reader.getName().getPrefix(), reader.getLocalName(), reader.getName().getNamespaceURI());
                            for (index = 0; index < reader.getAttributeCount(); ++index) {
                                writer.writeAttribute(reader.getAttributeLocalName(index), reader.getAttributeValue(index));
                            }
                            for (index = 0; index < reader.getNamespaceCount(); ++index) {
                                writer.writeNamespace(reader.getNamespacePrefix(index), reader.getNamespaceURI(index));
                            }
                            if (!isRoot) break;
                            writer.writeNamespace(CONVERTER_NAMESPACE_PREFIX, CONVERTER_NAMESPACE_URI);
                            isRoot = false;
                            break;
                        }
                        currentElement = MathMLElement.forElementName(elementName);
                        processingMathMLElement = true;
                        currentNode = new MathMLNode();
                        currentNode.setType(currentElement);
                        for (int index = 0; index < reader.getAttributeCount(); ++index) {
                            currentNode.getAttributes().add(new XmlAttribute(reader.getAttributeLocalName(index), reader.getAttributeValue(index)));
                        }
                        if (parentNode != null) {
                            currentNode.setParent(parentNode);
                            parentNode.getChildren().add(currentNode);
                        }
                        if (tree == null) {
                            tree = currentNode;
                        }
                        parentNode = currentNode;
                        break;
                    }
                    case END_ELEMENT: {
                        currentNode = parentNode = currentNode.getParent();
                        String elementName = reader.getLocalName();
                        MathMLElement element = MathMLElement.forElementName(elementName);
                        switch (element) {
                            case MATH: {
                                String converted = this.converter.convert(tree, language);
                                if (isRoot) {
                                    writer.writeStartElement(CONVERTER_ELEMENT_NAME);
                                    writer.writeDefaultNamespace(CONVERTER_NAMESPACE_URI);
                                    isRoot = false;
                                } else {
                                    writer.writeStartElement(CONVERTER_NAMESPACE_URI, CONVERTER_ELEMENT_NAME);
                                }
                                writer.writeCharacters(converted);
                                writer.writeEndElement();
                                processingMathMLElement = false;
                                currentElement = null;
                                tree = null;
                                currentNode = null;
                                parentNode = null;
                                break block7;
                            }
                        }
                        break;
                    }
                    case CHARACTERS: {
                        String value = reader.getText();
                        if (currentElement == null || !StringUtils.isNotBlank((CharSequence)value)) break;
                        currentNode.setValue(value);
                        break;
                    }
                    case ENTITY_REFERENCE: {
                        String value = reader.getLocalName();
                        if (currentElement == null || !StringUtils.isNotBlank((CharSequence)value)) break;
                        currentNode.setValue(value);
                        break;
                    }
                    case COMMENT: {
                        writer.writeComment(reader.getText());
                        break;
                    }
                    case DTD: {
                        writer.writeDTD(reader.getText());
                    }
                }
            }
            reader.close();
            writer.flush();
            writer.close();
            output.flush();
            ((OutputStream)output).close();
        }
        catch (IOException ex) {
            this.getLogger().error("Cannot load input file.", (Throwable)ex);
        }
        catch (XMLStreamException ex) {
            this.getLogger().error("Cannot open xml file for reading.", (Throwable)ex);
        }
        return outputFile;
    }

    private void checkSupportedLanguages(Locale language) throws UnsupportedLanguageException {
        if (!ConverterSettings.getInstance().getSupportedLanguages().contains(language.getLanguage())) {
            throw new UnsupportedLanguageException(String.format("[%1$s] is not supported.", language.getLanguage()));
        }
    }

    private InputStream canonicalize(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.logger.trace("Starting canonicalization.");
            MathMLCanonizer canonizer = new MathMLCanonizer().addModule((Module)new ElementMinimizer()).addModule((Module)new MfencedReplacer()).addModule((Module)new MrowNormalizer()).addModule((Module)new OperatorNormalizer());
            canonizer.canonicalize(input, (OutputStream)output);
            this.logger.trace("Canonicalization completed.");
        }
        catch (JDOMException ex) {
            this.logger.error("Error while performing canonicalization.", (Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            this.logger.error("Input file not found.", (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error("General IO exception.", (Throwable)ex);
        }
        ByteArrayInputStream result = new ByteArrayInputStream(output.toByteArray());
        return result;
    }
}

