/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl.content;

import cz.muni.fi.mathml.MathMLElement;
import cz.muni.fi.mathml.mathml2text.converter.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.impl.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.impl.Node;
import cz.muni.fi.mathml.mathml2text.converter.impl.Operation;
import cz.muni.fi.mathml.mathml2text.converter.numbers.NumberFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Apply {
    private static final Logger logger = LoggerFactory.getLogger(Apply.class);

    public static String process(MathMLNode node, ConverterSettings settings) {
        String function;
        StringBuilder builder = new StringBuilder();
        MathMLNode firstChild = node.getChildren().get(0);
        if (MathMLElement.CSYMBOL.equals((Object)firstChild.getType())) {
            function = firstChild.getValue();
        } else {
            if (MathMLElement.APPLY.equals((Object)firstChild.getType())) {
                builder.append(Node.process(firstChild, settings));
                builder.append(settings.getProperty("applied_to"));
                for (int index = 1; index < node.getChildren().size(); ++index) {
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            function = MathMLElement.CI.equals((Object)firstChild.getType()) && node.getChildren().size() > 1 ? firstChild.getValue() : firstChild.getType().getElementName();
        }
        firstChild.setProcessed();
        Operation operation = Operation.forSymbol(function);
        if (operation == null) {
            logger.info("Unknown operation [{}]", (Object)function);
            return "";
        }
        String functionName = settings.getProperty(operation.getKey());
        if (StringUtils.isBlank((CharSequence)functionName)) {
            logger.info("Unknown function [{}]", (Object)function);
        }
        switch (operation) {
            case SUPERSCRIPT: 
            case SUBSCRIPT: 
            case APPROACHES: {
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
            case ASSIGN: {
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(settings.getProperty("value"));
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
            case EXPONENTIATION: {
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
            case ROOT: {
                MathMLNode from;
                settings.setNumberFormat(NumberFormat.ORDINAL);
                MathMLNode degree = node.getChildren().get(1);
                if (MathMLElement.DEGREE.equals((Object)degree.getType())) {
                    degree = degree.getChildren().get(0);
                    from = node.getChildren().get(2);
                } else {
                    degree = node.getChildren().get(2);
                    from = node.getChildren().get(1);
                }
                builder.append(Node.process(degree, settings));
                settings.setNumberFormat(NumberFormat.CARDINAL);
                builder.append(functionName);
                builder.append(Node.process(from, settings));
                return builder.toString();
            }
            case LOGARITHM: {
                builder.append(functionName);
                if (node.getChildren().size() == 2) {
                    builder.append(settings.getNumberTransformer().transform("10"));
                    builder.append(settings.getProperty("logarithm_from"));
                    builder.append(Node.process(node.getChildren().get(1), settings));
                } else {
                    MathMLNode base = MathMLElement.LOGBASE.equals((Object)node.getChildren().get(1).getType()) ? node.getChildren().get(1).getChildren().get(0) : node.getChildren().get(1);
                    builder.append(Node.process(base, settings));
                    builder.append(settings.getProperty("logarithm_from"));
                    builder.append(Node.process(node.getChildren().get(2), settings));
                }
                return builder.toString();
            }
            case SUBTRACT: {
                if (node.getChildren().size() != 2) break;
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(1), settings));
                return builder.toString();
            }
            case TILDE: 
            case DASHED: {
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(functionName);
                return builder.toString();
            }
            case INTERVAL: {
                builder.append(functionName);
                builder.append(settings.getProperty("from"));
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(settings.getProperty("to"));
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
            case COMPOSE: {
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(1), settings));
                for (int index = 2; index < node.getChildren().size(); ++index) {
                    if (index + 1 == node.getChildren().size()) {
                        builder.append(settings.getProperty("and"));
                    } else {
                        builder.append(", ");
                    }
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            case VECTOR: {
                builder.append(functionName);
                builder.append(settings.getProperty("first_value"));
                builder.append(Node.process(node.getChildren().get(1), settings));
                for (int index = 2; index < node.getChildren().size(); ++index) {
                    builder.append(settings.getProperty("next_value"));
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                builder.append(settings.getProperty("vector_end"));
                return builder.toString();
            }
        }
        if (Operation.SUBTRACT.equals((Object)operation) && node.getChildren().size() == 2) {
            builder.append(functionName);
            builder.append(Node.process(node.getChildren().get(1), settings));
            return builder.toString();
        }
        MathMLElement functionElement = MathMLElement.forElementName(function);
        if (MathMLElement.UNKNOWN.equals((Object)functionElement)) {
            functionElement = MathMLElement.forElementName(operation.getKey());
        }
        switch (functionElement.getType()) {
            case CONTENT_TRIGONOMETRY: {
                builder.append(functionName);
                builder.append(settings.getProperty("of"));
                builder.append(Node.process(node.getChildren().get(1), settings));
                return builder.toString();
            }
            case CONTENT_GROUP: {
                builder.append(functionName);
                builder.append(settings.getProperty("of"));
                builder.append(Node.process(node.getChildren().get(1), settings));
                int count = node.getChildren().size();
                for (int index = 2; index < count; ++index) {
                    if (index == count - 1) {
                        builder.append(settings.getProperty("and"));
                    } else {
                        builder.append(", ");
                    }
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            case CONTENT_MIDDLE: {
                builder.append(Node.process(node.getChildren().get(1), settings));
                int count = node.getChildren().size();
                for (int index = 2; index < count; ++index) {
                    builder.append(functionName);
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            case CONTENT_BEFORE: {
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(1), settings));
                return builder.toString();
            }
            case CONTENT_BEFORE_MIDDLE: {
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(settings.getProperty(Operation.DIVIDE.getKey()));
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
        }
        return builder.toString();
    }
}

