/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.impl.presentation;

import cz.muni.fi.mathml.mathml2text.converter.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.impl.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.impl.Node;
import cz.muni.fi.mathml.mathml2text.converter.numbers.NumberFormat;

public final class Mroot {
    public static String process(MathMLNode node, ConverterSettings settings) {
        if (node.getChildren().size() != 2) {
            throw new IllegalArgumentException("[mroot] should have two children.");
        }
        StringBuilder builder = new StringBuilder();
        settings.setNumberFormat(NumberFormat.ORDINAL);
        boolean braces = false;
        if (node.getChildren().get(1).getChildren().size() > 1) {
            braces = true;
        }
        if (braces) {
            builder.append(settings.getProperty("open_braces"));
        }
        builder.append(Node.process(node.getChildren().get(1), settings));
        if (braces) {
            builder.append(settings.getProperty("close_braces"));
        }
        settings.setNumberFormat(NumberFormat.CARDINAL);
        builder.append(settings.getProperty("root"));
        braces = false;
        if (node.getChildren().get(0).getChildren().size() > 1) {
            braces = true;
        }
        if (braces) {
            builder.append(settings.getProperty("open_braces"));
        }
        builder.append(Node.process(node.getChildren().get(0), settings));
        if (braces) {
            builder.append(settings.getProperty("close_braces"));
        }
        return builder.toString();
    }
}

