/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.numbers;

import cz.muni.fi.mathml.mathml2text.converter.numbers.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberTransformer {
    private final ResourceBundle bundle;
    private final Logger logger = LoggerFactory.getLogger(NumberTransformer.class);
    private NumberFormat numberFormat = NumberFormat.CARDINAL;

    public NumberTransformer(@Nullable Locale locale) {
        this.bundle = ResourceBundle.getBundle("cz.muni.fi.mathml.mathml2text.converter.numbers.numbers", locale != null ? locale : Locale.getDefault());
    }

    private ResourceBundle getBundle() {
        return this.bundle;
    }

    private Logger getLogger() {
        return this.logger;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String transform(String value) {
        switch (this.getNumberFormat()) {
            case CARDINAL: {
                return this.transformNumber(value);
            }
            case ORDINAL: {
                return this.transformOrdinalNumber(value);
            }
        }
        return "";
    }

    public String transformNumber(String numberAsString) throws NumberFormatException {
        StringBuilder builder = new StringBuilder();
        Double number = Double.valueOf(numberAsString);
        long integralPartNumber = (long)Math.floor(number);
        String decimalPartString = String.valueOf(number).split("\\.")[1];
        long decimalPartNumber = Long.valueOf(decimalPartString);
        String integralPartResult = this.translateNumber(integralPartNumber);
        builder.append(integralPartResult);
        builder.append(" ");
        if (decimalPartNumber != 0L) {
            if (integralPartNumber == 1L || integralPartNumber == -1L) {
                builder.append(this.getBundle().getString("POINT1"));
            } else if (Math.abs(integralPartNumber) > 1L && Math.abs(integralPartNumber) < 5L) {
                builder.append(this.getBundle().getString("POINT2"));
            } else {
                builder.append(this.getBundle().getString("POINT3"));
            }
            builder.append(" ");
            while (decimalPartString.startsWith("0")) {
                builder.append(this.getBundle().getString("ZERO"));
                builder.append(" ");
                decimalPartString = decimalPartString.substring(1);
            }
            String decimalPartResult = this.translateNumber(Long.valueOf(decimalPartString));
            builder.append(decimalPartResult);
        }
        return builder.toString();
    }

    public String transformOrdinalNumber(String numberAsString) {
        double number = 0.0;
        try {
            number = Double.parseDouble(numberAsString);
            this.getLogger().debug("Transforming ordinal number " + number);
        }
        catch (NumberFormatException nfe) {
            this.getLogger().error(String.format("Number [%1$s] cannot be transformed.", numberAsString));
        }
        long integralPart = (long)Math.floor(number);
        long decimalPart = 0L;
        String decimal = String.valueOf(number).split("\\.")[1];
        try {
            decimalPart = Long.valueOf(decimal);
        }
        catch (NumberFormatException nfe) {
            this.getLogger().error("ERROR");
        }
        if (decimalPart != 0L) {
            return this.transformNumber(numberAsString);
        }
        return this.translateOrdinalNumber(integralPart);
    }

    private String translateNumber(long number) {
        StringBuilder ret = new StringBuilder("");
        if (number == 0L) {
            return this.getBundle().getString("ZERO");
        }
        if (number < 0L) {
            ret.append(this.getBundle().getString("MINUS")).append(" ");
            number *= -1L;
        }
        while (number > 0L) {
            if (number < 1000L) {
                ret.append(this.translateNumber1000(number, true));
                return ret.toString();
            }
            if (number < 1000000L) {
                if (number / 1000L < 10L) {
                    ret.append(this.addCountDva((int)number / 1000, false));
                } else {
                    ret.append(this.translateNumber(number / 1000L));
                }
                ret.append(" ").append(this.getBundle().getString("THOUSAND")).append(" ");
                number %= 1000L;
                continue;
            }
            if (number >= 1000000000L) continue;
            int i = (int)number / 1000000;
            if (i < 10) {
                ret.append(this.addCountDva(i, true));
            } else {
                ret.append(this.translateNumber(number / 1000L));
            }
            if (i == 1) {
                ret.append(" ").append(this.getBundle().getString("MILLION")).append(" ");
            } else if (i < 5) {
                ret.append(" ").append(this.getBundle().getString("MILLIONS")).append(" ");
            } else {
                ret.append(" ").append(this.getBundle().getString("MILLIONS_2")).append(" ");
            }
            number %= 1000000L;
        }
        return ret.toString();
    }

    private String translateNumber1000(long number, boolean dva) {
        StringBuilder ret = new StringBuilder("");
        while (number > 0L) {
            if (number < 10L) {
                switch ((int)number) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ret.append(this.getBundle().getString("ONE"));
                        break;
                    }
                    case 2: {
                        ret.append(this.getBundle().getString("TWO_1"));
                        break;
                    }
                    case 3: {
                        ret.append(this.getBundle().getString("THREE"));
                        break;
                    }
                    case 4: {
                        ret.append(this.getBundle().getString("FOUR"));
                        break;
                    }
                    case 5: {
                        ret.append(this.getBundle().getString("FIVE"));
                        break;
                    }
                    case 6: {
                        ret.append(this.getBundle().getString("SIX"));
                        break;
                    }
                    case 7: {
                        ret.append(this.getBundle().getString("SEVEN"));
                        break;
                    }
                    case 8: {
                        ret.append(this.getBundle().getString("EIGHT"));
                        break;
                    }
                    case 9: {
                        ret.append(this.getBundle().getString("NINE"));
                        break;
                    }
                }
                break;
            }
            if (number < 20L) {
                switch ((int)number) {
                    case 10: {
                        ret.append(this.getBundle().getString("TEN"));
                        break;
                    }
                    case 11: {
                        ret.append(this.getBundle().getString("ELEVEN"));
                        break;
                    }
                    case 12: {
                        ret.append(this.getBundle().getString("TWELVE"));
                        break;
                    }
                    case 13: {
                        ret.append(this.getBundle().getString("THIRTEEN"));
                        break;
                    }
                    case 14: {
                        ret.append(this.getBundle().getString("FOURTEEN"));
                        break;
                    }
                    case 15: {
                        ret.append(this.getBundle().getString("FIFTEEN"));
                        break;
                    }
                    case 16: {
                        ret.append(this.getBundle().getString("SIXTEEN"));
                        break;
                    }
                    case 17: {
                        ret.append(this.getBundle().getString("SEVENTEEN"));
                        break;
                    }
                    case 18: {
                        ret.append(this.getBundle().getString("EIGHTEEN"));
                        break;
                    }
                    case 19: {
                        ret.append(this.getBundle().getString("NINETEEN"));
                        break;
                    }
                }
                break;
            }
            if (number < 100L) {
                int i = (int)(number / 10L);
                switch (i) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        ret.append(this.getBundle().getString("TWENTY"));
                        break;
                    }
                    case 3: {
                        ret.append(this.getBundle().getString("THIRTY"));
                        break;
                    }
                    case 4: {
                        ret.append(this.getBundle().getString("FOURTY"));
                        break;
                    }
                    case 5: {
                        ret.append(this.getBundle().getString("FIFTY"));
                        break;
                    }
                    case 6: {
                        ret.append(this.getBundle().getString("SIXTY"));
                        break;
                    }
                    case 7: {
                        ret.append(this.getBundle().getString("SEVENTY"));
                        break;
                    }
                    case 8: {
                        ret.append(this.getBundle().getString("EIGHTY"));
                        break;
                    }
                    case 9: {
                        ret.append(this.getBundle().getString("NINETY"));
                        break;
                    }
                }
                ret.append(" ");
                number %= 10L;
                continue;
            }
            if (number >= 1000L) continue;
            ret.append(this.addCountDva((int)number / 100, false));
            ret.append(this.getBundle().getString("HUNDRED")).append(" ");
            number %= 100L;
        }
        return ret.toString();
    }

    private String addCountDva(int number, boolean dva) {
        switch (number) {
            case 0: 
            case 1: {
                return "";
            }
            case 2: {
                if (dva) {
                    return this.getBundle().getString("TWO_1");
                }
                return this.getBundle().getString("TWO_2");
            }
            case 3: {
                return this.getBundle().getString("THREE");
            }
            case 4: {
                return this.getBundle().getString("FOUR");
            }
            case 5: {
                return this.getBundle().getString("FIVE");
            }
            case 6: {
                return this.getBundle().getString("SIX");
            }
            case 7: {
                return this.getBundle().getString("SEVEN");
            }
            case 8: {
                return this.getBundle().getString("EIGHT");
            }
            case 9: {
                return this.getBundle().getString("NINE");
            }
        }
        return null;
    }

    public String translateOrdinalNumber(long inputNumber) {
        StringBuilder ret = new StringBuilder("");
        long number = 0L;
        if (inputNumber < 100L) {
            number = inputNumber;
        } else if (inputNumber % 100L != 0L) {
            number = inputNumber % 100L;
            ret.append(this.translateNumber(inputNumber - number));
        } else if (inputNumber % 1000L != 0L) {
            ret.append(this.translateNumber(inputNumber - inputNumber % 1000L));
            ret.append(this.addCountDva((int)(inputNumber % 1000L) / 100, false));
            ret.append(this.getBundle().getString("HUNDRED2"));
        } else if (inputNumber % 10000L != 0L) {
            ret.append(this.translateNumber(inputNumber / 1000L)).append(" ");
            ret.append(this.getBundle().getString("THOUSAND2"));
        } else if (inputNumber % 10000000L != 0L) {
            ret.append(this.translateNumber(inputNumber / 1000000L)).append(" ");
            ret.append(this.getBundle().getString("MILLION2"));
        }
        while (number > 0L) {
            if (number < 10L) {
                switch ((int)number) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ret.append(this.getBundle().getString("ONE2"));
                        break;
                    }
                    case 2: {
                        ret.append(this.getBundle().getString("TWO2"));
                        break;
                    }
                    case 3: {
                        ret.append(this.getBundle().getString("THREE2"));
                        break;
                    }
                    case 4: {
                        ret.append(this.getBundle().getString("FOUR2"));
                        break;
                    }
                    case 5: {
                        ret.append(this.getBundle().getString("FIVE2"));
                        break;
                    }
                    case 6: {
                        ret.append(this.getBundle().getString("SIX2"));
                        break;
                    }
                    case 7: {
                        ret.append(this.getBundle().getString("SEVEN2"));
                        break;
                    }
                    case 8: {
                        ret.append(this.getBundle().getString("EIGHT2"));
                        break;
                    }
                    case 9: {
                        ret.append(this.getBundle().getString("NINE2"));
                        break;
                    }
                }
                break;
            }
            if (number < 20L) {
                switch ((int)number) {
                    case 10: {
                        ret.append(this.getBundle().getString("TEN2"));
                        break;
                    }
                    case 11: {
                        ret.append(this.getBundle().getString("ELEVEN2"));
                        break;
                    }
                    case 12: {
                        ret.append(this.getBundle().getString("TWELVE2"));
                        break;
                    }
                    case 13: {
                        ret.append(this.getBundle().getString("THIRTEEN2"));
                        break;
                    }
                    case 14: {
                        ret.append(this.getBundle().getString("FOURTEEN2"));
                        break;
                    }
                    case 15: {
                        ret.append(this.getBundle().getString("FIFTEEN2"));
                        break;
                    }
                    case 16: {
                        ret.append(this.getBundle().getString("SIXTEEN2"));
                        break;
                    }
                    case 17: {
                        ret.append(this.getBundle().getString("SEVENTEEN2"));
                        break;
                    }
                    case 18: {
                        ret.append(this.getBundle().getString("EIGHTEEN2"));
                        break;
                    }
                    case 19: {
                        ret.append(this.getBundle().getString("NINETEEN2"));
                        break;
                    }
                }
                break;
            }
            if (number >= 100L) continue;
            int i = (int)(number / 10L);
            switch (i) {
                case 0: {
                    break;
                }
                case 2: {
                    ret.append(this.getBundle().getString("TWENTY2"));
                    break;
                }
                case 3: {
                    ret.append(this.getBundle().getString("THIRTY2"));
                    break;
                }
                case 4: {
                    ret.append(this.getBundle().getString("FOURTY2"));
                    break;
                }
                case 5: {
                    ret.append(this.getBundle().getString("FIFTY2"));
                    break;
                }
                case 6: {
                    ret.append(this.getBundle().getString("SIXTY2"));
                    break;
                }
                case 7: {
                    ret.append(this.getBundle().getString("SEVENTY2"));
                    break;
                }
                case 8: {
                    ret.append(this.getBundle().getString("EIGHTY2"));
                    break;
                }
                case 9: {
                    ret.append(this.getBundle().getString("NINETY2"));
                    break;
                }
            }
            number %= 10L;
        }
        return ret.toString();
    }
}

