/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text;

import cz.muni.fi.mathml.mathml2text.converter.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.input.XmlParser;
import cz.muni.fi.mathml.mathml2text.input.XmlParserDOM;
import cz.muni.fi.mathml.mathml2text.input.XmlParserStAX;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static final Logger logger = LoggerFactory.getLogger(App.class);
    private static final Set<String> SUPPORTED_LANGUAGES = new HashSet<String>(3);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please specify input file path. Use '-h' option to print help.");
            System.exit(1);
        }
        String language = "en";
        if ("--h".equals(args[0]) || "-h".equals(args[0]) || "-help".equals(args[0]) || "--help".equals(args[0])) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("converter [options] <file...>", App.createOptions());
            System.exit(0);
        }
        String parserImplementation = "dom";
        BasicParser commandLineParser = new BasicParser();
        try {
            XmlParser parser;
            CommandLine line = commandLineParser.parse(App.createOptions(), args);
            if (line.hasOption("language") && !SUPPORTED_LANGUAGES.contains(language = line.getOptionValue("language"))) {
                System.err.println("Unsupported language.");
                System.exit(1);
            }
            if (line.hasOption("canonicalize")) {
                ConverterSettings.getInstance().setCanonicalize(true);
            }
            if (line.hasOption("replace-spaces")) {
                ConverterSettings.getInstance().setReplaceSpaces(true);
            }
            if (line.hasOption("threads")) {
                String optionValue = line.getOptionValue("threads");
                try {
                    Integer value = Integer.valueOf(optionValue);
                    ConverterSettings.getInstance().setThreadCount(value);
                }
                catch (NumberFormatException ex) {
                    logger.warn("Could not convert thread count [" + optionValue + "] to integer.");
                }
            }
            if (line.hasOption("output")) {
                String outputDirectoryPath = line.getOptionValue("output");
                if (outputDirectoryPath != null) {
                    outputDirectoryPath = StringUtils.stripEnd((String)outputDirectoryPath, (String)System.getProperty("file.separator"));
                }
                ConverterSettings.getInstance().setOutputDirectory(outputDirectoryPath);
            }
            if (line.hasOption("transform-numbers")) {
                ConverterSettings.getInstance().setTransformNumbers(true);
            }
            if (line.hasOption("parser")) {
                parserImplementation = line.getOptionValue("parser");
            }
            if (line.hasOption("content-markup")) {
                ConverterSettings.getInstance().setUseContentMarkup(true);
            }
            String[] fileNames = line.getArgs();
            ArrayList<File> inputFiles = new ArrayList<File>(fileNames.length);
            for (String fileName : fileNames) {
                inputFiles.add(new File(fileName));
            }
            Instant start = Instant.now();
            if ("stax".equals(parserImplementation)) {
                App.setUpForStAX();
                parser = new XmlParserStAX();
            } else if ("dom".equals(parserImplementation)) {
                App.setUpForDOM();
                parser = new XmlParserDOM();
            } else if ("aalto".equals(parserImplementation)) {
                App.setUpForAalto();
                parser = new XmlParserStAX();
            } else if ("woodstox".equals(parserImplementation)) {
                App.setUpForWoodstox();
                parser = new XmlParserStAX(false);
            } else {
                System.err.println("Unknown parser implementation");
                parser = null;
                System.exit(1);
            }
            List<File> parse = parser.parse(inputFiles, new Locale(language));
            Instant end = Instant.now();
            Duration duration = new Duration((ReadableInstant)start, (ReadableInstant)end);
            System.out.println("\n" + duration.getMillis() + " ms");
        }
        catch (ParseException ex) {
            System.err.println("Error while parsing command line arguments: " + ex.getMessage());
            System.exit(1);
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"language");
        OptionBuilder.withDescription((String)"specify language (defaults to en)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"LANGUAGE");
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.withDescription((String)"specify number of threads for parallel conversion (defaults to 1)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"NUMBER");
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"output directory path");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PATH");
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"parser");
        OptionBuilder.withDescription((String)"choose parser implementation [dom|stax|aalto|woodstox], defaults to dom");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PARSER");
        options.addOption(OptionBuilder.create((String)"p"));
        options.addOption("c", "canonicalize", false, "canonicalize input");
        options.addOption("r", "replace-spaces", false, "replace spaces with underscores");
        options.addOption("n", "transform-numbers", false, "transform all numbers to strings");
        options.addOption("cm", "content-markup", false, "use content markup for conversion");
        return options;
    }

    private static void setUpForDOM() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
        System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
        System.setProperty("javax.xml.stream.XMLEventFactory", "com.sun.xml.internal.stream.events.XMLEventFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
    }

    private static void setUpForStAX() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
        System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
        System.setProperty("javax.xml.stream.XMLEventFactory", "com.sun.xml.internal.stream.events.XMLEventFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
    }

    private static void setUpForAalto() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.fasterxml.aalto.stax.InputFactoryImpl");
        System.setProperty("javax.xml.stream.XMLOutputFactory", "com.fasterxml.aalto.stax.OutputFactoryImpl");
        System.setProperty("javax.xml.stream.XMLEventFactory", "com.fasterxml.aalto.stax.EventFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.fasterxml.aalto.sax.SAXParserFactoryImpl");
    }

    private static void setUpForWoodstox() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
        System.setProperty("javax.xml.stream.XMLEventFactory", "com.ctc.wstx.stax.WstxEventFactory");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.ctc.wstx.sax.WstxSAXParserFactory");
    }

    static {
        SUPPORTED_LANGUAGES.add("en");
        SUPPORTED_LANGUAGES.add("sk");
        SUPPORTED_LANGUAGES.add("cs");
    }
}

