/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter;

import com.google.common.collect.Sets;
import cz.muni.fi.mathml.mathml2text.numbers.NumberFormat;
import cz.muni.fi.mathml.mathml2text.numbers.NumberTransformer;
import java.util.Properties;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class ConverterSettings {
    private Properties localization;
    private NumberTransformer numberTransformer;
    private boolean replaceSpaces;
    private boolean canonicalize;
    private int threadCount = 1;
    private String outputDirectory;
    private boolean transformNumbers;
    private boolean useContentMarkup;
    private static final ConverterSettings INSTANCE = new ConverterSettings();

    private ConverterSettings() {
    }

    public static ConverterSettings getInstance() {
        return INSTANCE;
    }

    public Properties getLocalization() {
        return this.localization;
    }

    public void setLocalization(Properties localization) {
        this.localization = localization;
    }

    public NumberTransformer getNumberTransformer() {
        return this.numberTransformer;
    }

    public void setNumberTransformer(NumberTransformer numberTransformer) {
        this.numberTransformer = numberTransformer;
    }

    public NumberFormat getNumberFormat() {
        return this.getNumberTransformer().getNumberFormat();
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.getNumberTransformer().setNumberFormat(numberFormat);
    }

    public String getProperty(String key) {
        String result = this.getLocalization().getProperty(key);
        if (this.isReplaceSpaces()) {
            result = result.replace(" ", "_");
        }
        return result + " ";
    }

    public boolean isReplaceSpaces() {
        return this.replaceSpaces;
    }

    public void setReplaceSpaces(boolean replaceSpaces) {
        this.replaceSpaces = replaceSpaces;
    }

    public boolean isCanonicalize() {
        return this.canonicalize;
    }

    public void setCanonicalize(boolean canonicalize) {
        this.canonicalize = canonicalize;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        if (threadCount < 1) {
            LoggerFactory.getLogger(ConverterSettings.class).warn("The number of threads must be at least 1. Setting to 1.");
            this.threadCount = 1;
        } else {
            this.threadCount = threadCount;
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isTransformNumbers() {
        return this.transformNumbers;
    }

    public void setTransformNumbers(boolean transformNumbers) {
        this.transformNumbers = transformNumbers;
    }

    public boolean isUseContentMarkup() {
        return this.useContentMarkup;
    }

    public void setUseContentMarkup(boolean useContentMarkup) {
        this.useContentMarkup = useContentMarkup;
    }

    public Set<String> getSupportedLanguages() {
        return Sets.newHashSet((Object[])new String[]{"en", "cs", "sk"});
    }
}

