/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter;

import cz.muni.fi.mathml.mathml2text.converter.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.content.Apply;
import cz.muni.fi.mathml.mathml2text.converter.content.Ci;
import cz.muni.fi.mathml.mathml2text.converter.content.Cn;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Mfenced;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Mfrac;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Mi;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Mn;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Mo;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Mover;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Mroot;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Msqrt;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Msub;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Msup;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Munder;
import cz.muni.fi.mathml.mathml2text.converter.presentation.Munderover;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLType;

public final class Node {
    public static String process(MathMLNode node, ConverterSettings settings) {
        if (node.isProcessed()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        switch (node.getType()) {
            case MATH: 
            case SEMANTICS: {
                for (MathMLNode child : node.getChildren()) {
                    builder.append(Node.process(child, settings));
                }
                break;
            }
            case ANNOTATION_XML: {
                break;
            }
            case MROW: {
                boolean enclose;
                boolean bl = enclose = node.getChildren().size() > 1 && node.getParent() != null && MathMLType.PRESENTATION.equals((Object)node.getParent().getType().getType());
                if (enclose) {
                    builder.append(settings.getProperty("open_braces"));
                }
                for (MathMLNode child : node.getChildren()) {
                    builder.append(Node.process(child, settings));
                }
                if (!enclose) break;
                builder.append(settings.getProperty("close_braces"));
                break;
            }
            case MI: {
                builder.append(Mi.process(node, settings));
                break;
            }
            case MO: {
                builder.append(Mo.process(node, settings));
                break;
            }
            case MN: {
                builder.append(Mn.process(node, settings));
                break;
            }
            case MFRAC: {
                builder.append(Mfrac.process(node, settings));
                break;
            }
            case MSQRT: {
                builder.append(Msqrt.process(node, settings));
                break;
            }
            case MROOT: {
                builder.append(Mroot.process(node, settings));
                break;
            }
            case MSUB: {
                builder.append(Msub.process(node, settings));
                break;
            }
            case MSUP: {
                builder.append(Msup.process(node, settings));
                break;
            }
            case MUNDER: {
                builder.append(Munder.process(node, settings));
                break;
            }
            case MOVER: {
                builder.append(Mover.process(node, settings));
                break;
            }
            case MUNDEROVER: 
            case MSUBSUP: {
                builder.append(Munderover.process(node, settings));
                break;
            }
            case MFENCED: {
                builder.append(Mfenced.process(node, settings));
                break;
            }
            case CN: {
                builder.append(Cn.process(node, settings));
                break;
            }
            case CI: {
                builder.append(Ci.process(node, settings));
                break;
            }
            case APPLY: {
                builder.append(Apply.process(node, settings));
                break;
            }
            default: {
                if (node.getChildren().isEmpty()) {
                    builder.append(node.getValue());
                    break;
                }
                for (MathMLNode child : node.getChildren()) {
                    builder.append(Node.process(child, settings));
                }
            }
        }
        node.setProcessed();
        return builder.toString();
    }
}

