/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.content;

import cz.muni.fi.mathml.mathml2text.converter.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.Node;
import cz.muni.fi.mathml.mathml2text.converter.operation.Operation;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLElement;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLNode;
import cz.muni.fi.mathml.mathml2text.numbers.NumberFormat;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Apply {
    private static final Logger logger = LoggerFactory.getLogger(Apply.class);

    public static String process(MathMLNode node, ConverterSettings settings) {
        String function;
        StringBuilder builder = new StringBuilder();
        MathMLNode firstChild = node.getChildren().get(0);
        if (MathMLElement.CSYMBOL.equals((Object)firstChild.getType())) {
            function = firstChild.getValue();
        } else {
            if (MathMLElement.APPLY.equals((Object)firstChild.getType())) {
                builder.append(Node.process(firstChild, settings));
                builder.append(settings.getProperty("applied_to"));
                for (int index = 1; index < node.getChildren().size(); ++index) {
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            if (MathMLElement.CI.equals((Object)firstChild.getType()) && node.getChildren().size() > 1) {
                function = firstChild.getValue();
            } else {
                if (MathMLElement.MTEXT.equals((Object)firstChild.getType())) {
                    return "";
                }
                function = firstChild.getType().getElementName();
            }
        }
        firstChild.setProcessed();
        if ((MathMLElement.CN.getElementName().equals(function) || MathMLElement.CI.getElementName().equals(function)) && node.getChildren().size() == 1) {
            builder.append(Node.process(firstChild, settings));
            return builder.toString();
        }
        Operation operation = Operation.forSymbol(function);
        if (operation == null) {
            if (function == null) {
                logger.debug("Function is null. First child: [{}]", (Object)firstChild.getType().getElementName());
                return "";
            }
            ArrayList<Integer> chars = new ArrayList<Integer>();
            for (int i = 0; i < function.length(); ++i) {
                chars.add(Integer.valueOf(function.charAt(i)));
            }
            String join = StringUtils.join(chars, (String)",");
            logger.info("Unknown operation [{}] [{}]", (Object)function, (Object)join);
            builder.append(function);
            builder.append(" ");
            builder.append(settings.getProperty("with_parameters"));
            for (int index = 1; index < node.getChildren().size(); ++index) {
                builder.append(Node.process(node.getChildren().get(index), settings));
            }
            return builder.toString();
        }
        String functionName = settings.getProperty(operation.getKey());
        if (StringUtils.isBlank((CharSequence)functionName)) {
            logger.info("Unknown function [{}]", (Object)function);
        }
        if ((Operation.ADD.equals((Object)operation) || Operation.SUBTRACT.equals((Object)operation)) && node.getChildren().size() == 1) {
            builder.append(functionName);
            return builder.toString();
        }
        switch (operation.getType()) {
            case INFIX: {
                if (node.getChildren().size() == 1) {
                    logger.debug("Infix operator [{}] has no arguments.", (Object)operation.getKey());
                    builder.append(functionName);
                    return builder.toString();
                }
                builder.append(Node.process(node.getChildren().get(1), settings));
                int count = node.getChildren().size();
                for (int index = 2; index < count; ++index) {
                    builder.append(functionName);
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            case PREFIX: {
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(1), settings));
                return builder.toString();
            }
            case PREFIX_MULTI: {
                builder.append(functionName);
                builder.append(settings.getProperty("of"));
                builder.append(Node.process(node.getChildren().get(1), settings));
                int count = node.getChildren().size();
                for (int index = 2; index < count; ++index) {
                    if (index == count - 1) {
                        builder.append(settings.getProperty("and"));
                    } else {
                        builder.append(", ");
                    }
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            case EVERY_ARGUMENT: {
                for (int index = 1; index < node.getChildren().size(); ++index) {
                    builder.append(Node.process(node.getChildren().get(index), settings));
                    builder.append(settings.getProperty("with"));
                    builder.append(functionName);
                }
            }
            case INFIX_OR_PREFIX: {
                if (node.getChildren().size() == 2) {
                    builder.append(functionName);
                    builder.append(Node.process(node.getChildren().get(1), settings));
                    return builder.toString();
                }
                builder.append(Node.process(node.getChildren().get(1), settings));
                int count = node.getChildren().size();
                for (int index = 2; index < count; ++index) {
                    builder.append(functionName);
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            case WITH_INTERVAL: {
                MathMLNode secondChild = node.getChildren().get(1);
                if (node.getChildren().size() == 2) {
                    builder.append(functionName);
                    builder.append(settings.getProperty("of"));
                    builder.append(Node.process(secondChild, settings));
                    return builder.toString();
                }
                if (MathMLElement.DOMAIN_OF_APPLICATION.equals((Object)secondChild.getType())) {
                    builder.append(functionName);
                    builder.append(settings.getProperty("over"));
                    builder.append(settings.getProperty("domain"));
                    builder.append(Node.process(secondChild, settings));
                    builder.append(settings.getProperty("of"));
                    builder.append(Node.process(node.getChildren().get(2), settings));
                } else if (MathMLElement.BVAR.equals((Object)secondChild.getType())) {
                    if (MathMLElement.LOWLIMIT.equals((Object)node.getChildren().get(2).getType())) {
                        builder.append(functionName);
                        builder.append(settings.getProperty("over"));
                        builder.append(Node.process(secondChild, settings));
                        builder.append(settings.getProperty("from"));
                        builder.append(Node.process(node.getChildren().get(2), settings));
                        builder.append(settings.getProperty("to"));
                        builder.append(Node.process(node.getChildren().get(3), settings));
                        builder.append(settings.getProperty("of"));
                        builder.append(Node.process(node.getChildren().get(4), settings));
                    } else if (MathMLElement.CONDITION.equals((Object)node.getChildren().get(2).getType())) {
                        builder.append(functionName);
                        builder.append(settings.getProperty("over"));
                        builder.append(Node.process(secondChild, settings));
                        builder.append(settings.getProperty("where"));
                        builder.append(Node.process(node.getChildren().get(2), settings));
                        builder.append(settings.getProperty("of"));
                        builder.append(Node.process(node.getChildren().get(3), settings));
                    } else {
                        logger.warn("Bound variable has no limits.");
                    }
                } else if (MathMLElement.INTERVAL.equals((Object)secondChild.getType())) {
                    builder.append(functionName);
                    builder.append(settings.getProperty("from"));
                    builder.append(Node.process(secondChild.getChildren().get(0), settings));
                    builder.append(settings.getProperty("to"));
                    builder.append(Node.process(secondChild.getChildren().get(1), settings));
                    builder.append(settings.getProperty("of"));
                    builder.append(Node.process(node.getChildren().get(2), settings));
                } else {
                    logger.warn("Unknown variable definition [{}] of [{}].", (Object)secondChild.getType().getElementName(), (Object)operation.getKey());
                }
                return builder.toString();
            }
        }
        switch (operation) {
            case SUPERSCRIPT: 
            case SUBSCRIPT: 
            case APPROACHES: {
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
            case ASSIGN: {
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(settings.getProperty("value"));
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
            case EXPONENTIATION: {
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
            case ROOT: {
                MathMLNode from;
                settings.setNumberFormat(NumberFormat.ORDINAL);
                MathMLNode degree = node.getChildren().get(1);
                if (MathMLElement.DEGREE.equals((Object)degree.getType())) {
                    degree = degree.getChildren().get(0);
                    from = node.getChildren().get(2);
                } else {
                    degree = node.getChildren().get(2);
                    from = node.getChildren().get(1);
                }
                builder.append(Node.process(degree, settings));
                settings.setNumberFormat(NumberFormat.CARDINAL);
                builder.append(functionName);
                builder.append(Node.process(from, settings));
                return builder.toString();
            }
            case LOGARITHM: {
                builder.append(functionName);
                if (node.getChildren().size() == 2) {
                    builder.append(settings.getNumberTransformer().transform("10"));
                    builder.append(settings.getProperty("logarithm_from"));
                    builder.append(Node.process(node.getChildren().get(1), settings));
                } else {
                    MathMLNode base = MathMLElement.LOGBASE.equals((Object)node.getChildren().get(1).getType()) ? node.getChildren().get(1).getChildren().get(0) : node.getChildren().get(1);
                    builder.append(Node.process(base, settings));
                    builder.append(settings.getProperty("logarithm_from"));
                    builder.append(Node.process(node.getChildren().get(2), settings));
                }
                return builder.toString();
            }
            case INTERVAL: {
                builder.append(functionName);
                builder.append(settings.getProperty("from"));
                builder.append(Node.process(node.getChildren().get(1), settings));
                builder.append(settings.getProperty("to"));
                builder.append(Node.process(node.getChildren().get(2), settings));
                return builder.toString();
            }
            case COMPOSE: {
                if (node.getChildren().size() < 2) {
                    return builder.toString();
                }
                builder.append(functionName);
                builder.append(Node.process(node.getChildren().get(1), settings));
                for (int index = 2; index < node.getChildren().size(); ++index) {
                    if (index + 1 == node.getChildren().size()) {
                        builder.append(settings.getProperty("and"));
                    } else {
                        builder.append(", ");
                    }
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                return builder.toString();
            }
            case VECTOR: {
                builder.append(functionName);
                builder.append(settings.getProperty("first_value"));
                builder.append(Node.process(node.getChildren().get(1), settings));
                for (int index = 2; index < node.getChildren().size(); ++index) {
                    builder.append(settings.getProperty("next_value"));
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                builder.append(settings.getProperty("vector_end"));
                return builder.toString();
            }
            case UPWARDS_ARROW: 
            case DOWNWARDS_ARROW: {
                for (int index = 1; index < node.getChildren().size(); ++index) {
                    builder.append(Node.process(node.getChildren().get(index), settings));
                    builder.append(functionName);
                }
                break;
            }
            case FUNCTION_APPLICATION: {
                for (int index = 1; index < node.getChildren().size(); ++index) {
                    builder.append(Node.process(node.getChildren().get(index), settings));
                }
                break;
            }
            default: {
                logger.debug("Operation [{}] was not processed.", (Object)operation.getKey());
            }
        }
        return builder.toString();
    }
}

