/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.content;

import cz.muni.fi.mathml.mathml2text.converter.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.Strings;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.tree.XmlAttribute;
import org.slf4j.LoggerFactory;

public final class Cn {
    public static String process(MathMLNode node, ConverterSettings settings) {
        if (node.getValue() == null) {
            throw new IllegalStateException("[mi] node should have its value set.");
        }
        StringBuilder builder = new StringBuilder();
        for (XmlAttribute attr : node.getAttributes()) {
            if ((!"base".equals(attr.getKey()) || "10".equals(attr.getValue())) && (!"type".equals(attr.getKey()) || !"hexdouble".equals(attr.getValue()))) continue;
            builder.append(node.getValue());
            builder.append(" ");
            return builder.toString();
        }
        try {
            String strippedValue = node.getValue().trim();
            for (Character c : Strings.VALUE_EMPTY_CHARS) {
                strippedValue = strippedValue.replace(c.toString(), "");
            }
            String number = settings.isTransformNumbers() ? settings.getNumberTransformer().transform(strippedValue) : strippedValue;
            return number.trim() + " ";
        }
        catch (NumberFormatException ex) {
            LoggerFactory.getLogger(Cn.class).warn(String.format("Cannot transform string [%1$s] to number.", node.getValue()), (Throwable)ex);
        }
        catch (NullPointerException ex) {
            LoggerFactory.getLogger(Cn.class).warn(String.format("Cannot transform string [%1$s] to number.", node.getValue()), (Throwable)ex);
        }
        return "";
    }
}

