/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.operation;

import com.google.common.collect.ImmutableList;
import cz.muni.fi.mathml.mathml2text.converter.operation.OperationType;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public enum Operation {
    ADD("plus", OperationType.INFIX_OR_PREFIX, "+", "&plus;", "plus"),
    SUBTRACT("minus", OperationType.INFIX_OR_PREFIX, "-", "&minus;", "minus"),
    MULTIPLY("times", OperationType.INFIX, "&times;", "*", "times", "&sdot;", "&#8901;", "&#x22C5;", "\u22c5", "&#8290;", "&#x2062;", "\u2062", "&#8727;", "&#x2217;", "\u2217", "\u2219", "&#8729;", "&#x2219;", "&lowast;"),
    DIVIDE("divide", OperationType.INFIX, "/", "&divide;", "divide", ":"),
    EQUALS("equals", OperationType.INFIX, "=", "eq"),
    LOGARITHM("logarithm", OperationType.SPECIAL, "log"),
    NATURAL_LOGARITHM("natural_logarithm", OperationType.PREFIX, "ln"),
    SQUARE("square", OperationType.SPECIAL, "2"),
    LIMIT("limit", OperationType.SPECIAL, "lim", "limit"),
    APPROACHES("approaches", OperationType.INFIX, "&rarr;", "rarr", "\u2192"),
    INTEGRAL("integral", OperationType.WITH_INTERVAL, "int", "&int;"),
    CONTOUR_INTEGRAL("contour_integral", OperationType.WITH_INTERVAL, "&#8750;", "&#x222E;", "\u222e"),
    DIFFERENTIAL("differential", OperationType.SPECIAL, "dd", "&dd;", "&#8518;", "&#x2146;", "\u2146"),
    SUMMATION("summation", OperationType.WITH_INTERVAL, "sum", "&sum;"),
    PRODUCT("product", OperationType.WITH_INTERVAL, "prod", "&prod;", "\u220f", "&amp;prod;"),
    SIN("sin", OperationType.PREFIX, "sin"),
    COS("cos", OperationType.PREFIX, "cos"),
    TAN("tan", OperationType.PREFIX, "tan"),
    SEC("sec", OperationType.PREFIX, "sec"),
    CSC("csc", OperationType.PREFIX, "csc"),
    COT("cot", OperationType.PREFIX, "cot", "cotg"),
    SINH("sinh", OperationType.PREFIX, "sinh"),
    COSH("cosh", OperationType.PREFIX, "cosh"),
    TANH("tanh", OperationType.PREFIX, "tanh"),
    SECH("sech", OperationType.PREFIX, "sech"),
    CSCH("csch", OperationType.PREFIX, "csch"),
    COTH("coth", OperationType.PREFIX, "coth"),
    ARCSIN("arcsin", OperationType.PREFIX, "arcsin"),
    ARCCOS("arccos", OperationType.PREFIX, "arccos"),
    ARCTAN("arctan", OperationType.PREFIX, "arctan"),
    ARCCOSH("arccosh", OperationType.PREFIX, "arccosh"),
    ARCCOT("arccot", OperationType.PREFIX, "arccot"),
    ARCCOTH("arccoth", OperationType.PREFIX, "arccoth"),
    ARCCSC("arccsc", OperationType.PREFIX, "arccsc"),
    ARCCSCH("arccsch", OperationType.PREFIX, "arccsch"),
    ARCSEC("arcsec", OperationType.PREFIX, "arcsec"),
    ARCSECH("arcsech", OperationType.PREFIX, "arcsech"),
    ARCSINH("arcsinh", OperationType.PREFIX, "arcsinh"),
    ARCTANH("arctanh", OperationType.PREFIX, "arctanh"),
    NOT_EQUAL_TO("neq", OperationType.INFIX, "neq", "&neq;", "&ne;", "&#8800;", "&#x2260;"),
    GREATER_THAN("gt", OperationType.INFIX, "gt", "&gt;"),
    LESS_THAN("lt", OperationType.INFIX, "lt", "&lt;"),
    GREATER_THAN_OR_EQUAL_TO("geq", OperationType.INFIX, "geq", "&geq;", "&ge;", "&#10878;", "&#x2A7E;", "\u2a7e", "&#8807;", "&#x2267;", "\u2267"),
    LESS_THAN_OR_EQUAL_TO("leq", OperationType.INFIX, "leq", "&leq;", "&le;", "&#10877;", "&#x2A7D;", "\u2a7d", "&#8806;", "&#x2266;", "\u2266"),
    EQUIVALENT_TO("equivalent", OperationType.INFIX, "equivalent", "&hArr;", "\u21d4", "&#8596;", "&#x2194;", "\u2194", "&harr;", "&hArr;"),
    APPROXIMATELY("approx", OperationType.INFIX, "approx", "\u2248"),
    AND("and", OperationType.INFIX, "and", "&and;"),
    OR("or", OperationType.INFIX, "or", "&or;"),
    XOR("xor", OperationType.INFIX, "xor"),
    IMPLIES("implies", OperationType.INFIX, "implies", "&#8658;", "&#x21D2;", "\u21d2", "&rArr;"),
    FACTOR_OF("factorof", OperationType.INFIX, "factorof"),
    UNION("union", OperationType.INFIX, "union", "&#8746;", "&#x222A;", "\u222a", "&cup;"),
    INTERSECT("intersect", OperationType.INFIX, "intersect", "&#8745;", "&#x2229;", "\u2229", "&cap;"),
    IN("in", OperationType.INFIX, "in", "\u2208", "&isin;", "&#8714;", "&#x220A;", "&#8712;", "&#x2208;", "\u220a"),
    NOTIN("notin", OperationType.INFIX, "notin", "&#8713;", "&#x2209;", "\u2209", "&notin;"),
    SUBSET("subset", OperationType.INFIX, "subset", "\u2282", "&sub;"),
    PRSUBSET("prsubset", OperationType.INFIX, "prsubset"),
    NOTSUBSET("notsubset", OperationType.INFIX, "notsubset"),
    NOTPRSUBSET("notprsubset", OperationType.INFIX, "notprsubset"),
    SETDIFF("setdiff", OperationType.INFIX, "setdiff"),
    NOT("not", OperationType.PREFIX, "not"),
    ABSOLUTE_VALUE("abs", OperationType.PREFIX, "abs"),
    FLOOR("floor", OperationType.PREFIX, "floor"),
    CEILING("ceiling", OperationType.PREFIX, "ceiling"),
    EXPONENTIAL("exp", OperationType.PREFIX, "exp"),
    CARDINALITY("card", OperationType.SPECIAL, "card"),
    REMAINDER("rem", OperationType.SPECIAL, "rem"),
    QUOTIENT("quotient", OperationType.SPECIAL, "quotient"),
    EXPONENTIATION("power", OperationType.SPECIAL, "power"),
    ROOT("root", OperationType.SPECIAL, "root", "&radic;", "&#8730;", "&#x221A;", "\u221a"),
    OPEN_BRACES("open_braces", OperationType.SPECIAL, "("),
    CLOSE_BRACES("close_braces", OperationType.SPECIAL, ")"),
    LEFT_ANGLE_BRACKET("left_angle_bracket", OperationType.SPECIAL, "\u27e8", "&#10216;", "&#x27E8;"),
    RIGHT_ANGLE_BRACKET("right_angle_bracket", OperationType.SPECIAL, "\u27e9", "&#10217;", "&#x27E9;"),
    LEFT_SQUARE_BRACKET("left_square_bracket", OperationType.SPECIAL, "[", "&#91;", "&#x005B;"),
    RIGHT_SQUARE_BRACKET("right_square_bracket", OperationType.SPECIAL, "]", "&#93;", "&#x005D;"),
    LEFT_CURLY_BRACKET("left_curly_bracket", OperationType.SPECIAL, "{", "&#125;", "&#x007D;"),
    RIGHT_CURLY_BRACKET("right_curly_bracket", OperationType.SPECIAL, "}", "&#102177;", "&#x27E9;"),
    SUPERSCRIPT("superscript", OperationType.SPECIAL, "superscript", "sup"),
    SUBSCRIPT("subscript", OperationType.SPECIAL, "subscript", "sub"),
    CI("ci", OperationType.SPECIAL, new String[0]),
    ASSIGN("assign", OperationType.SPECIAL, ":="),
    TILDE("tilde", OperationType.EVERY_ARGUMENT, "~", "&#126;", "&#x007E;", "&#x7E;"),
    DASHED("dashed", OperationType.EVERY_ARGUMENT, "\u00af", "&#175;", "&#x00AF;", "&macr;"),
    INTERVAL("interval", OperationType.SPECIAL, "interval"),
    COMPOSE("compose", OperationType.SPECIAL, "compose"),
    VECTOR("vector", OperationType.SPECIAL, "vector"),
    DIRECT_SUM("direct_sum", OperationType.INFIX, "&oplus;", "\u2295"),
    PLUS_MINUS("plus_minus", OperationType.INFIX, "&plusmn;", "\u00b1"),
    MINUS_PLUS("minus_plus", OperationType.INFIX, "&#8723;", "&#x2213;", "\u2213"),
    SIMEQ("simeq", OperationType.INFIX, "\u2243"),
    SIM("sim", OperationType.INFIX, "\u223c", "&#8764;", "&#x223C;", "&sim;"),
    FAR_GT("far_gt", OperationType.INFIX, "\u226b"),
    FAR_LT("far_lt", OperationType.INFIX, "\u226a"),
    COMMA("comma", OperationType.INFIX, ",", "&#44;", "&#8291;", "&#x2063;", "\u2063"),
    SEMICOLON("semicolon", OperationType.INFIX, ";"),
    DOT("dot", OperationType.INFIX, ".", "&#46;"),
    PROPORTIONAL_TO("proportional_to", OperationType.INFIX, "\u221d", "&#8733;", "&#x221D;", "&prop;", "prop"),
    LT_EQUIV("lt_equiv", OperationType.INFIX, "\u2272", "&#8818;", "&#x2272;"),
    GT_EQUIV("gt_equiv", OperationType.INFIX, "\u2273", "&#8819;", "&#x2273;"),
    IDENTICAL("identical_to", OperationType.INFIX, "\u2261", "&#8801;", "&#x2261;", "&equiv;"),
    SET("set", OperationType.PREFIX_MULTI, "set"),
    LIST("list", OperationType.PREFIX_MULTI, "list"),
    PRIME("prime", OperationType.INFIX, "&#8242;", "&#x2032;", "&prime;"),
    DOUBLE_PRIME("double_prime", OperationType.INFIX, "&#8243;", "&#x2033;", "&Prime;"),
    DOT_ABOVE("dot_above", OperationType.EVERY_ARGUMENT, "&#729;", "&#x2D9;", "\u02d9"),
    UP_ARROWHEAD("up_arrowhead", OperationType.EVERY_ARGUMENT, "&#8963;", "&#x2303;", "\u2303", "&#94;", "&#x005E;", "^"),
    PERPENDICULAR("perpendicular", OperationType.INFIX, "&#10178;", "&#x27C2;", "\u27c2", "&#8869;", "&#x22A5;", "\u22a5", "&perp;"),
    DIAERESIS("diaeresis", OperationType.EVERY_ARGUMENT, "\u00a8", "&#168;", "&#x00A8;", "&uml;"),
    PARTIALDIFF("partialdiff", OperationType.PREFIX, "partialdiff", "&#8706;", "&#x2202;", "&part;"),
    FACTORIAL("factorial", OperationType.PREFIX, "factorial"),
    MINIMUM("min", OperationType.PREFIX_MULTI, "min"),
    MAXIMUM("max", OperationType.PREFIX_MULTI, "max"),
    DIRECT_PRODUCT("direct_product", OperationType.INFIX, "&#8857;", "&#x2299;", "\u2299"),
    BACKWARD_DIFFERENCE("backward_difference", OperationType.PREFIX, "&#8711;", "&#x2207;", "\u2207", "&nabla;"),
    ASYMPTOTIC_TO("asymptotic_to", OperationType.INFIX, "&#8776;", "&#x2248;", "\u2248", "&asymp;"),
    FOR_ALL("for_all", OperationType.PREFIX_MULTI, "&#8704;", "&#x2200;", "forall", "\u2200"),
    EXISTS("exists", OperationType.PREFIX_MULTI, "exists"),
    DIVIDES("divides", OperationType.INFIX, "&#8739;", "&#x2223;", "\u2223", "|"),
    TENSOR_PRODUCT("tensor_product", OperationType.INFIX, "&#8855;", "&#x2297;", "\u2297", "&otimes;"),
    MAPS_TO("maps_to", OperationType.INFIX, "\u21a6", "&#8614;", "&#x21A6;"),
    GREATER_THAN_EQUAL_TO_OR_LESS_THAN("greater_equal_less", OperationType.INFIX, "&#8923;", "&#x22DB;", "\u22db"),
    SET_MINUS("set_minus", OperationType.INFIX, "&#8726;", "&#x2216;", "\u2216", "\\"),
    SUBSET_EQUAL("subset_equal", OperationType.INFIX, "&#8838;", "&#x2286;", "\u2286", "&sube;"),
    TRANSPOSE("transpose", OperationType.EVERY_ARGUMENT, "\u2020", "&#8224;", "&#x2020;", "&dagger;"),
    UPWARDS_ARROW("upwards_arrow", OperationType.SPECIAL, "\u2191", "&#8593;", "&#x2191;", "&uarr;"),
    DOWNWARDS_ARROW("downwards_arrow", OperationType.SPECIAL, "\u2193", "&#8595;", "&#x2193;"),
    LESS_THAN_OR_APPROXIMATE("less_than_or_approximate", OperationType.INFIX, "&#10885;", "&#x2A85;", "\u2a85"),
    GREATER_THAN_OR_APPROXIMATE("greater_than_or_approximate", OperationType.INFIX, "&#10886;", "&#x2A86;", "\u2a86"),
    FUNCTION_APPLICATION("function_application", OperationType.SPECIAL, "&#8289;", "&#x2061;", "\u2061"),
    APPROACHES_THE_LIMIT("approaches_the_limit", OperationType.INFIX, "&#8784;", "&#x2250;", "\u2250"),
    RING_ABOVE("ring_above", OperationType.EVERY_ARGUMENT, "\u030a", "&#778;", "&#x030A;"),
    DOUBLE_INTEGRAL("double_integral", OperationType.WITH_INTERVAL, "&#8748;", "&#x222C;", "\u222c"),
    ENTAILS("entails", OperationType.INFIX, "\u22a7", "&#8871;", "&#x22A7;"),
    INFERS("infers", OperationType.INFIX, "\u22a2", "&#8866;", "&#x22A2;"),
    SUPERSET_EQUAL("superset_equal", OperationType.INFIX, "&#8839;", "&#x2287;", "\u2287", "&supe;"),
    SUPERSET("superset", OperationType.INFIX, "&#8835;", "&#x2283;", "\u2283", "&sup;"),
    NOT_IDENTICAL("not_identical", OperationType.INFIX, "&#8802;", "&#x2262;", "\u2262"),
    PRECEDES_OR_EQUAL("precedes_or_equal", OperationType.INFIX, "&#10927;", "&#x2AAF;", "\u2aaf", "&#8828;", "&#x227C;", "\u227c"),
    SUCCEEDS_OR_EQUAL("succeeds_or_equal", OperationType.INFIX, "&#10928;", "&#x2AB0;", "\u2ab0", "&#8829;", "&#x227D;", "\u227d"),
    DELTA("delta", OperationType.INFIX, "\u0394", "&#916;", "&#x0394;"),
    CONTAINS_AS_MEMBER("contains_as_member", OperationType.INFIX, "&#8715;", "&#x220B;", "\u220b", "\u220d", "&#8717;", "&#x220D;", "&ni;"),
    WREATH_PRODUCT("wreath_product", OperationType.INFIX, "&#8768;", "&#x2240;", "\u2240"),
    BREVE("breve", OperationType.EVERY_ARGUMENT, "&#728;", "&#x02D8;", "\u02d8"),
    NOT_SUPERSET("not_superset", OperationType.INFIX, "&#8837;", "&#x2285;", "\u2285"),
    SUCCEEDS_OR_NOT_EQUAL("succeeds_or_not_equal", OperationType.INFIX, "&#10934;", "&#x2AB6;", "\u2ab6"),
    NOT_SUBSET("not_subset", OperationType.INFIX, "&#8836;", "&#x2284;", "\u2284"),
    PRECEDES("precedes", OperationType.INFIX, "&#8826;", "&#x227A;", "\u227a"),
    SUCCEEDS("succeeds", OperationType.INFIX, "&#8827;", "&#x227B;", "\u227b"),
    SUBSET_NOT_EQUAL("subset_not_equal", OperationType.INFIX, "&#8842;", "&#x228A;", "\u228a"),
    NORMAL_SUBGROUP("normal_subgroup", OperationType.INFIX, "&#8882;", "&#x22B2;", "\u22b2"),
    NOT_LESS_NOT_EQUAL("not_less_not_equal", OperationType.INFIX, "&#8816;", "&#x2270;", "\u2270"),
    COPRODUCT("coproduct", OperationType.WITH_INTERVAL, "&#8720;", "&#x2210;", "\u2210"),
    NORMAL_SUBGROUP_OR_EQUAL("normal_subgroup_or_equal", OperationType.INFIX, "&#8884;", "&#x22B4;", "\u22b4"),
    NOT_PRECEDE_OR_EQUAL("not_precede_or_equal", OperationType.INFIX, "&#8928;", "&#x22E0;", "\u22e0"),
    NOT_SUBSET_NOT_EQUAL("not_subset_not_equal", OperationType.INFIX, "&#8840;", "&#x2288;", "\u2288"),
    SYMMETRIC_DIFFERENCE("symmetric_diffrence", OperationType.INFIX, "&#8854;", "&#x2296;", "\u2296"),
    NOT_LESS("not_less", OperationType.INFIX, "&#8814;", "&#x226E;", "\u226e"),
    NOT_EXISTS("not_exists", OperationType.PREFIX_MULTI, "&#8708;", "&#x2204;", "\u2204"),
    LCM("lcm", OperationType.PREFIX_MULTI, "lcm"),
    GCD("gcd", OperationType.PREFIX_MULTI, "gcd"),
    CONGRUENT("congruent", OperationType.INFIX, "&#8773;", "&#x2245;", "&cong;", "\u2245"),
    END_OF_PROOF("end_of_proof", OperationType.SPECIAL, "&#8718;", "&#x220E;", "\u220e"),
    UNION_NARY("union_nary", OperationType.WITH_INTERVAL, "&#8899;", "&#x22C3;", "\u22c3"),
    AND_NARY("and_nary", OperationType.WITH_INTERVAL, "&#8896;", "&#x22C0;", "\u22c0"),
    OR_NARY("or_nary", OperationType.WITH_INTERVAL, "&#8897;", "&#x22C1;", "\u22c1"),
    INTERSECT_NARY("intersect_nary", OperationType.WITH_INTERVAL, "&#8898;", "&#x22C2;", "\u22c2"),
    NOT_ALMOST_EQUAL("not_almost_equal", OperationType.INFIX, "&#8777;", "&#x2249;", "\u2249"),
    TOP_ELEMENT("top_element", OperationType.SPECIAL, "&#8868;", "&#x22A4;", "\u22a4"),
    CONTAINS_AS_NORMAL_SUBGROUP("contains_as_normal_subgroup", OperationType.INFIX, "&#8883;", "&#x22B3;", "\u22b3"),
    FUNCTION_COMPOSITION("function_composition", OperationType.INFIX, "&#8728;", "&#x2218;", "\u2218"),
    PARALLEL_TO("parallel_to", OperationType.INFIX, "&#8741;", "&#x2225;", "\u2225"),
    EMPTY("empty", OperationType.INFIX, new String[0]);

    private final String key;
    private final OperationType type;
    private final Collection<String> symbols;

    private Operation(String key, OperationType type, String ... symbols) {
        this.key = key;
        this.type = type;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])symbols);
        this.symbols = builder.build();
    }

    public String getKey() {
        return this.key;
    }

    public OperationType getType() {
        return this.type;
    }

    public Collection<String> getSymbols() {
        return this.symbols;
    }

    public static Operation forSymbol(String symbol) {
        if (StringUtils.isBlank((CharSequence)symbol)) {
            return EMPTY;
        }
        for (Operation operation : Operation.values()) {
            if (!operation.getSymbols().contains(symbol)) continue;
            return operation;
        }
        return null;
    }
}

