/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.presentation;

import cz.muni.fi.mathml.mathml2text.converter.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.Node;
import cz.muni.fi.mathml.mathml2text.converter.operation.Symbol;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.tree.XmlAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Mfenced {
    private static final Logger logger = LoggerFactory.getLogger(Mfenced.class);

    public static String process(MathMLNode node, ConverterSettings settings) {
        StringBuilder builder = new StringBuilder();
        String openBraces = settings.getProperty("open_braces");
        String closeBraces = settings.getProperty("close_braces");
        for (XmlAttribute attr : node.getAttributes()) {
            Symbol symbol;
            if ("open".equals(attr.getKey())) {
                symbol = Symbol.forValue(attr.getValue());
                if (symbol == null) {
                    logger.warn("Uknown braces [{}].", (Object)attr.getValue());
                } else {
                    openBraces = settings.getProperty(symbol.getKey());
                }
            }
            if (!"close".equals(attr.getKey())) continue;
            symbol = Symbol.forValue(attr.getValue());
            if (symbol == null) {
                logger.warn("Uknown braces [{}].", (Object)attr.getValue());
                continue;
            }
            if (Symbol.ABS.equals((Object)symbol)) {
                closeBraces = settings.getProperty("abs_close");
                continue;
            }
            closeBraces = settings.getProperty(symbol.getKey());
        }
        builder.append(openBraces);
        for (int index = 0; index < node.getChildren().size(); ++index) {
            MathMLNode child = node.getChildren().get(index);
            builder.append(Node.process(child, settings));
            if (index >= node.getChildren().size() - 1) continue;
            builder.append(settings.getProperty("comma"));
        }
        builder.append(closeBraces);
        return builder.toString();
    }
}

