/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.converter.presentation;

import cz.muni.fi.mathml.mathml2text.converter.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.Strings;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLNode;
import org.slf4j.LoggerFactory;

public final class Mn {
    public static String process(MathMLNode node, ConverterSettings settings) {
        if (!node.getChildren().isEmpty()) {
            throw new IllegalStateException("[mi] node should not have children.");
        }
        if (node.getValue() == null) {
            throw new IllegalStateException("[mi] node should have its value set.");
        }
        try {
            String strippedValue = node.getValue().trim();
            for (Character c : Strings.VALUE_EMPTY_CHARS) {
                strippedValue = strippedValue.replace(c.toString(), "");
            }
            String number = settings.isTransformNumbers() ? settings.getNumberTransformer().transform(strippedValue) : strippedValue;
            return number.trim() + " ";
        }
        catch (NumberFormatException ex) {
            LoggerFactory.getLogger(Mn.class).warn(String.format("Cannot transform string [%1$s] to number.", node.getValue()), (Throwable)ex);
        }
        catch (NullPointerException ex) {
            LoggerFactory.getLogger(Mn.class).warn(String.format("Cannot transform string [%1$s] to number.", node.getValue()), (Throwable)ex);
        }
        return "";
    }
}

