/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.input;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Unzipper {
    private static final Logger logger = LoggerFactory.getLogger(Unzipper.class);

    public static InputStream unzip(File zipFile) {
        Validate.isTrue((boolean)zipFile.getName().endsWith("zip"), (String)"Input file is not zipped.", (Object[])new Object[0]);
        int bufferSize = 2048;
        try {
            ZipFile zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                byte[] data = new byte[bufferSize];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((currentByte = is.read(data, 0, bufferSize)) != -1) {
                    out.write(data, 0, currentByte);
                }
                is.close();
                return new ByteArrayInputStream(out.toByteArray());
            }
        }
        catch (ZipException ex) {
            logger.warn("Error while unzipping file.", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.warn("Error while unzipping file.", (Throwable)ex);
        }
        return null;
    }
}

