/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.input;

import cz.muni.fi.mathml.mathml2text.converter.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.MathMLConverter;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLElement;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.tree.XmlAttribute;
import cz.muni.fi.mathml.mathml2text.input.UnsupportedLanguageException;
import cz.muni.fi.mathml.mathml2text.input.Unzipper;
import cz.muni.fi.mathml.mathml2text.input.XmlParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlParserDOM
implements XmlParser {
    private static final Logger logger = LoggerFactory.getLogger(XmlParserDOM.class);
    private final Set<File> originalInputFiles = new HashSet<File>();
    private final AtomicInteger atomicInteger = new AtomicInteger(0);
    final XMLOutputter outputter;
    private final MathMLConverter converter = new MathMLConverter();
    private static final String CONVERTER_NAMESPACE_URI = "http://code.google.com/p/mathml-converter/";
    private static final String CONVERTER_NAMESPACE_PREFIX = "conv";
    private static final String CONVERTER_ELEMENT_NAME = "math";

    public XmlParserDOM() {
        this.outputter = new XMLOutputter();
        this.outputter.setFormat(Format.getPrettyFormat());
    }

    private SAXBuilder createSAXBuilder() {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        saxBuilder.setFeature("http://xml.org/sax/features/validation", false);
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", true);
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
        saxBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.endsWith("dtd")) {
                    return new InputSource(XmlParserDOM.class.getResourceAsStream("xhtml-math11-f.dtd"));
                }
                return null;
            }
        });
        return saxBuilder;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<File> parse(@Nonnull List<File> files, Locale language) throws UnsupportedLanguageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public File parse(@Nonnull File file, Locale language) throws UnsupportedLanguageException {
        String outputFilePath;
        Validate.isTrue((file != null ? 1 : 0) != 0, (String)"File for transformation should not be null.", (Object[])new Object[0]);
        this.checkSupportedLanguages(language);
        int executionNumber = this.atomicInteger.incrementAndGet();
        logger.debug("Processing file [" + executionNumber + "] [" + file.getPath() + "].");
        if (StringUtils.isBlank((CharSequence)ConverterSettings.getInstance().getOutputDirectory())) {
            String filePath = file.getPath();
            outputFilePath = filePath.substring(0, filePath.lastIndexOf(46)) + "-transformed.xml";
        } else {
            String suffix = "";
            for (File f : this.originalInputFiles) {
                if (!file.getPath().startsWith(f.getPath())) continue;
                suffix = StringUtils.difference((String)f.getPath(), (String)file.getPath());
                break;
            }
            if (StringUtils.isBlank((CharSequence)suffix)) {
                suffix = file.getName();
            }
            if (!suffix.startsWith(System.getProperty("file.separator"))) {
                suffix = System.getProperty("file.separator") + suffix;
            }
            if ((outputFilePath = ConverterSettings.getInstance().getOutputDirectory() + suffix).endsWith("zip")) {
                outputFilePath = outputFilePath.substring(0, outputFilePath.lastIndexOf("."));
            }
        }
        File outputFile = new File(outputFilePath);
        outputFile.getParentFile().mkdirs();
        try {
            outputFile.createNewFile();
        }
        catch (IOException ex) {
            logger.warn("File [{}] already exists.", (Object)outputFile.getPath());
        }
        try {
            InputStream inputStream = file.getName().endsWith("zip") ? Unzipper.unzip(file) : new FileInputStream(file);
            Document document = this.createSAXBuilder().build(inputStream);
            Element root = document.getRootElement();
            root.addNamespaceDeclaration(Namespace.getNamespace((String)CONVERTER_NAMESPACE_PREFIX, (String)CONVERTER_NAMESPACE_URI));
            this.processMath(root, language);
            FileOutputStream output = new FileOutputStream(outputFile);
            this.outputter.output(document, (OutputStream)output);
            output.flush();
            ((OutputStream)output).close();
            inputStream.close();
        }
        catch (FileNotFoundException ex) {
            logger.error("Input file not found.", (Throwable)ex);
        }
        catch (JDOMException ex) {
            logger.error("Error while creating DOM document", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("IO error.", (Throwable)ex);
        }
        return null;
    }

    private void processMath(Element element, Locale language) {
        if (CONVERTER_ELEMENT_NAME.equals(element.getName())) {
            MathMLNode tree = this.createTree(element);
            element.setNamespace(Namespace.getNamespace((String)CONVERTER_NAMESPACE_PREFIX, (String)CONVERTER_NAMESPACE_URI));
            element.setName(CONVERTER_ELEMENT_NAME);
            String converted = this.converter.convert(tree, language);
            element.removeContent();
            element.setText(converted);
        } else {
            for (Element child : element.getChildren()) {
                this.processMath(child, language);
            }
        }
    }

    private MathMLNode createTree(Element element) {
        MathMLNode node = new MathMLNode();
        node.setType(MathMLElement.forElementName(element.getName()));
        String value = element.getText().trim();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            node.setValue(value);
        }
        for (Attribute attr : element.getAttributes()) {
            node.getAttributes().add(new XmlAttribute(attr.getName(), attr.getValue()));
        }
        for (Element child : element.getChildren()) {
            MathMLNode childTree = this.createTree(child);
            childTree.setParent(node);
            node.getChildren().add(childTree);
        }
        return node;
    }

    private void checkSupportedLanguages(Locale language) throws UnsupportedLanguageException {
        if (!ConverterSettings.getInstance().getSupportedLanguages().contains(language.getLanguage())) {
            throw new UnsupportedLanguageException(String.format("[%1$s] is not supported.", language.getLanguage()));
        }
    }

    private List<File> findFiles(File file) {
        ArrayList<File> files = new ArrayList<File>();
        if (file.canRead()) {
            if (file.isFile()) {
                files.add(file);
                return files;
            }
            for (File child : file.listFiles()) {
                files.addAll(this.findFiles(child));
            }
        }
        return files;
    }

    @Override
    public String parse(String inputString, Locale language) throws UnsupportedLanguageException {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)inputString), (String)"Input string cant be null nor blank.", (Object[])new Object[0]);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(inputString.getBytes());
            Document document = this.createSAXBuilder().build((InputStream)inputStream);
            Element root = document.getRootElement();
            root.addNamespaceDeclaration(Namespace.getNamespace((String)CONVERTER_NAMESPACE_PREFIX, (String)CONVERTER_NAMESPACE_URI));
            String converted = this.processMathAsString(root, language);
            return converted;
        }
        catch (FileNotFoundException ex) {
            logger.error("Input file not found.", (Throwable)ex);
        }
        catch (JDOMException ex) {
            logger.error("Error while creating DOM document", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("IO error.", (Throwable)ex);
        }
        return null;
    }

    private String processMathAsString(Element element, Locale language) {
        StringBuilder builder = new StringBuilder();
        if (CONVERTER_ELEMENT_NAME.equals(element.getName())) {
            MathMLNode tree = this.createTree(element);
            String converted = this.converter.convert(tree, language);
            builder.append(converted).append(" ");
        } else {
            for (Element child : element.getChildren()) {
                builder.append(this.processMathAsString(child, language));
            }
        }
        return builder.toString();
    }
}

