/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mathml.mathml2text.input;

import cz.muni.fi.mathml.mathml2text.converter.ConverterSettings;
import cz.muni.fi.mathml.mathml2text.converter.MathMLConverter;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLElement;
import cz.muni.fi.mathml.mathml2text.converter.tree.MathMLNode;
import cz.muni.fi.mathml.mathml2text.converter.tree.XmlAttribute;
import cz.muni.fi.mathml.mathml2text.input.UnsupportedLanguageException;
import cz.muni.fi.mathml.mathml2text.input.Unzipper;
import cz.muni.fi.mathml.mathml2text.input.XmlParser;
import cz.muni.fi.mathml.mathml2text.input.XmlStreamConstant;
import cz.muni.fi.mir.mathmlcanonicalization.MathMLCanonizer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.ElementMinimizer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.MfencedReplacer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.Module;
import cz.muni.fi.mir.mathmlcanonicalization.modules.MrowNormalizer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.OperatorNormalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlParserStAX
implements XmlParser {
    private final Logger logger = LoggerFactory.getLogger(XmlParserStAX.class);
    private final MathMLConverter converter;
    private final XMLInputFactory xmlInputFactory;
    private final XMLOutputFactory xmlOutputFactory;
    private static final String CONVERTER_NAMESPACE_URI = "http://code.google.com/p/mathml-converter/";
    private static final String CONVERTER_NAMESPACE_PREFIX = "conv";
    private static final String CONVERTER_ELEMENT_NAME = "math";
    private final MathMLCanonizer canonicalizer;
    private final Set<File> originalInputFiles = new HashSet<File>();
    private final AtomicInteger atomicInteger = new AtomicInteger(0);

    public XmlParserStAX() {
        this(true);
    }

    public XmlParserStAX(boolean supportDTD) {
        this.converter = new MathMLConverter();
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", supportDTD);
        this.xmlInputFactory.setProperty("javax.xml.stream.resolver", new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                if (systemID.endsWith("dtd")) {
                    return XmlParserStAX.class.getResourceAsStream("xhtml-math11-f.dtd");
                }
                return null;
            }
        });
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.canonicalizer = new MathMLCanonizer().addModule((Module)new ElementMinimizer()).addModule((Module)new MfencedReplacer()).addModule((Module)new MrowNormalizer()).addModule((Module)new OperatorNormalizer());
    }

    private Logger getLogger() {
        return this.logger;
    }

    @Override
    public String parse(@Nonnull String inputString, Locale language) throws UnsupportedLanguageException {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)inputString));
        this.checkSupportedLanguages(language);
        MathMLNode tree = null;
        MathMLNode currentNode = null;
        MathMLNode parentNode = null;
        MathMLElement currentElement = null;
        try {
            ByteArrayInputStream inputStream = ConverterSettings.getInstance().isCanonicalize() ? this.canonicalize(new ByteArrayInputStream(inputString.getBytes())) : new ByteArrayInputStream(inputString.getBytes());
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(inputStream, "UTF-8");
            StringBuilder output = new StringBuilder();
            boolean processingMathMLElement = false;
            while (reader.hasNext()) {
                int eventCode = reader.next();
                XmlStreamConstant constant = XmlStreamConstant.forEventCode(eventCode);
                if (!processingMathMLElement && !XmlStreamConstant.START_ELEMENT.equals((Object)constant)) continue;
                block1 : switch (constant) {
                    case START_ELEMENT: {
                        String elementName = reader.getLocalName();
                        if (!processingMathMLElement && !MathMLElement.MATH.getElementName().equals(elementName)) break;
                        currentElement = MathMLElement.forElementName(elementName);
                        processingMathMLElement = true;
                        currentNode = new MathMLNode();
                        currentNode.setType(currentElement);
                        for (int index = 0; index < reader.getAttributeCount(); ++index) {
                            currentNode.getAttributes().add(new XmlAttribute(reader.getAttributeLocalName(index), reader.getAttributeValue(index)));
                        }
                        if (parentNode != null) {
                            currentNode.setParent(parentNode);
                            parentNode.getChildren().add(currentNode);
                        }
                        if (tree == null) {
                            tree = currentNode;
                        }
                        parentNode = currentNode;
                        break;
                    }
                    case END_ELEMENT: {
                        currentNode = parentNode = currentNode.getParent();
                        String elementName = reader.getLocalName();
                        MathMLElement element = MathMLElement.forElementName(elementName);
                        switch (element) {
                            case MATH: {
                                String converted = this.converter.convert(tree, language);
                                output.append(converted);
                                processingMathMLElement = false;
                                currentElement = null;
                                tree = null;
                                currentNode = null;
                                parentNode = null;
                                break block1;
                            }
                        }
                        break;
                    }
                    case CHARACTERS: {
                        String value = reader.getText();
                        if (currentElement == null || !StringUtils.isNotBlank((CharSequence)value)) break;
                        currentNode.setValue(value);
                        break;
                    }
                    case ENTITY_REFERENCE: {
                        String value = reader.getLocalName();
                        if (currentElement == null || !StringUtils.isNotBlank((CharSequence)value)) break;
                        currentNode.setValue(value);
                        break;
                    }
                }
            }
            reader.close();
            return output.toString();
        }
        catch (XMLStreamException ex) {
            this.getLogger().error("Cannot open xml file for reading.", (Throwable)ex);
            return "";
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<File> parse(@Nonnull List<File> files, Locale language) throws UnsupportedLanguageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public File parse(@Nonnull File file, Locale language) throws UnsupportedLanguageException {
        String outputFilePath;
        Validate.isTrue((file != null ? 1 : 0) != 0, (String)"File for transformation should not be null.", (Object[])new Object[0]);
        this.checkSupportedLanguages(language);
        int executionNumber = this.atomicInteger.incrementAndGet();
        this.logger.debug("Processing file [" + executionNumber + "] [" + file.getPath() + "].");
        if (StringUtils.isBlank((CharSequence)ConverterSettings.getInstance().getOutputDirectory())) {
            String filePath = file.getPath();
            outputFilePath = filePath.substring(0, filePath.lastIndexOf(46)) + "-transformed.xml";
        } else {
            String suffix = "";
            for (File f : this.originalInputFiles) {
                if (!file.getPath().startsWith(f.getPath())) continue;
                suffix = StringUtils.difference((String)f.getPath(), (String)file.getPath());
                break;
            }
            if (StringUtils.isBlank((CharSequence)suffix)) {
                suffix = file.getName();
            }
            if (!suffix.startsWith(System.getProperty("file.separator"))) {
                suffix = System.getProperty("file.separator") + suffix;
            }
            if ((outputFilePath = ConverterSettings.getInstance().getOutputDirectory() + suffix).endsWith("zip")) {
                outputFilePath = outputFilePath.substring(0, outputFilePath.lastIndexOf("."));
            }
        }
        File outputFile = new File(outputFilePath);
        outputFile.getParentFile().mkdirs();
        try {
            outputFile.createNewFile();
        }
        catch (IOException ex) {
            this.getLogger().warn("File [{}] already exists.", (Object)outputFile.getPath());
        }
        MathMLNode tree = null;
        MathMLNode currentNode = null;
        MathMLNode parentNode = null;
        MathMLElement currentElement = null;
        try {
            InputStream inputStream = file.getName().endsWith("zip") ? Unzipper.unzip(file) : new FileInputStream(file);
            inputStream = ConverterSettings.getInstance().isCanonicalize() ? this.canonicalize(inputStream) : inputStream;
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(inputStream, "UTF-8");
            FileOutputStream output = new FileOutputStream(outputFile);
            XMLStreamWriter writer = this.xmlOutputFactory.createXMLStreamWriter(output, "UTF-8");
            writer.writeStartDocument(reader.getEncoding(), reader.getVersion());
            boolean isRoot = true;
            boolean processingMathMLElement = false;
            block22: while (reader.hasNext()) {
                int eventCode = reader.next();
                XmlStreamConstant constant = XmlStreamConstant.forEventCode(eventCode);
                if (!processingMathMLElement && !XmlStreamConstant.START_ELEMENT.equals((Object)constant)) {
                    switch (constant) {
                        case END_ELEMENT: {
                            writer.writeEndElement();
                            continue block22;
                        }
                        case CHARACTERS: {
                            writer.writeCharacters(reader.getText());
                            continue block22;
                        }
                        case DTD: {
                            writer.writeDTD(reader.getText());
                            continue block22;
                        }
                    }
                    continue;
                }
                block7 : switch (constant) {
                    case START_ELEMENT: {
                        String elementName = reader.getLocalName();
                        if (!processingMathMLElement && !MathMLElement.MATH.getElementName().equals(elementName)) {
                            int index;
                            writer.writeStartElement(reader.getName().getPrefix(), reader.getLocalName(), reader.getName().getNamespaceURI());
                            for (index = 0; index < reader.getAttributeCount(); ++index) {
                                writer.writeAttribute(reader.getAttributeLocalName(index), reader.getAttributeValue(index));
                            }
                            for (index = 0; index < reader.getNamespaceCount(); ++index) {
                                writer.writeNamespace(reader.getNamespacePrefix(index), reader.getNamespaceURI(index));
                            }
                            if (!isRoot) break;
                            writer.writeNamespace(CONVERTER_NAMESPACE_PREFIX, CONVERTER_NAMESPACE_URI);
                            isRoot = false;
                            break;
                        }
                        currentElement = MathMLElement.forElementName(elementName);
                        processingMathMLElement = true;
                        currentNode = new MathMLNode();
                        currentNode.setType(currentElement);
                        for (int index = 0; index < reader.getAttributeCount(); ++index) {
                            currentNode.getAttributes().add(new XmlAttribute(reader.getAttributeLocalName(index), reader.getAttributeValue(index)));
                        }
                        if (parentNode != null) {
                            currentNode.setParent(parentNode);
                            parentNode.getChildren().add(currentNode);
                        }
                        if (tree == null) {
                            tree = currentNode;
                        }
                        parentNode = currentNode;
                        break;
                    }
                    case END_ELEMENT: {
                        currentNode = parentNode = currentNode.getParent();
                        String elementName = reader.getLocalName();
                        MathMLElement element = MathMLElement.forElementName(elementName);
                        switch (element) {
                            case MATH: {
                                String converted = this.converter.convert(tree, language);
                                if (isRoot) {
                                    writer.writeStartElement(CONVERTER_ELEMENT_NAME);
                                    writer.writeDefaultNamespace(CONVERTER_NAMESPACE_URI);
                                    isRoot = false;
                                } else {
                                    writer.writeStartElement(CONVERTER_NAMESPACE_URI, CONVERTER_ELEMENT_NAME);
                                }
                                writer.writeCharacters(converted);
                                writer.writeEndElement();
                                processingMathMLElement = false;
                                currentElement = null;
                                tree = null;
                                currentNode = null;
                                parentNode = null;
                                break block7;
                            }
                        }
                        break;
                    }
                    case CHARACTERS: {
                        String value = reader.getText();
                        if (currentElement == null || !StringUtils.isNotBlank((CharSequence)value)) break;
                        currentNode.setValue(value);
                        break;
                    }
                    case ENTITY_REFERENCE: {
                        String value = reader.getLocalName();
                        if (currentElement == null || !StringUtils.isNotBlank((CharSequence)value)) break;
                        currentNode.setValue(value);
                        break;
                    }
                    case COMMENT: {
                        writer.writeComment(reader.getText());
                        break;
                    }
                    case DTD: {
                        writer.writeDTD(reader.getText());
                    }
                }
            }
            inputStream.close();
            reader.close();
            writer.flush();
            writer.close();
            output.flush();
            ((OutputStream)output).close();
            this.logger.debug("Finished conversion of file [" + executionNumber + "] [" + file.getPath() + "]");
        }
        catch (IOException ex) {
            this.getLogger().error("Exception while working with input/output file.", (Throwable)ex);
        }
        catch (XMLStreamException ex) {
            this.getLogger().error("Cannot open xml file for reading.", (Throwable)ex);
        }
        return outputFile;
    }

    private void checkSupportedLanguages(Locale language) throws UnsupportedLanguageException {
        if (!ConverterSettings.getInstance().getSupportedLanguages().contains(language.getLanguage())) {
            throw new UnsupportedLanguageException(String.format("[%1$s] is not supported.", language.getLanguage()));
        }
    }

    private InputStream canonicalize(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.logger.trace("Starting canonicalization.");
            this.canonicalizer.canonicalize(input, (OutputStream)output);
            this.logger.trace("Canonicalization completed.");
        }
        catch (JDOMException ex) {
            this.logger.error("Error while performing canonicalization.", (Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            this.logger.error("Input file not found.", (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error("General IO exception.", (Throwable)ex);
        }
        ByteArrayInputStream result = new ByteArrayInputStream(output.toByteArray());
        return result;
    }

    private List<File> findFiles(File file) {
        ArrayList<File> files = new ArrayList<File>();
        if (file.canRead()) {
            if (file.isFile()) {
                files.add(file);
                return files;
            }
            for (File child : file.listFiles()) {
                files.addAll(this.findFiles(child));
            }
        }
        return files;
    }
}

