/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization;

import cz.muni.fi.mir.mathmlcanonicalization.ConfigException;
import cz.muni.fi.mir.mathmlcanonicalization.Settings;
import cz.muni.fi.mir.mathmlcanonicalization.modules.DOMModule;
import cz.muni.fi.mir.mathmlcanonicalization.modules.Module;
import cz.muni.fi.mir.mathmlcanonicalization.modules.ModuleException;
import cz.muni.fi.mir.mathmlcanonicalization.modules.StreamModule;
import cz.muni.fi.mir.mathmlcanonicalization.utils.DTDManipulator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.SAXException;

public final class MathMLCanonicalizer {
    private List<StreamModule> streamModules = new LinkedList<StreamModule>();
    private List<DOMModule> domModules = new LinkedList<DOMModule>();
    private static final Logger LOGGER = Logger.getLogger(MathMLCanonicalizer.class.getName());
    private boolean enforcingXHTMLPlusMathMLDTD = false;

    public static MathMLCanonicalizer getDefaultCanonicalizer() {
        String property = Settings.getProperty("modules");
        String[] modules = property.split(" ");
        List<String> listOfModules = Arrays.asList(modules);
        MathMLCanonicalizer result = new MathMLCanonicalizer();
        for (String moduleName : listOfModules) {
            result.addModule(moduleName);
        }
        return result;
    }

    public MathMLCanonicalizer() {
    }

    public MathMLCanonicalizer(InputStream xmlConfigurationStream) throws ConfigException {
        if (xmlConfigurationStream == null) {
            throw new NullPointerException("xmlConfigurationStream is null");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)xmlConfigurationStream, (OutputStream)baos);
            this.validateXMLConfiguration(new ByteArrayInputStream(baos.toByteArray()));
            this.loadXMLConfiguration(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (XMLStreamException ex) {
            LOGGER.log(Level.SEVERE, "cannot load configuration. ", ex);
            throw new ConfigException("cannot load configuration", ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "cannot load configuration. ", ex);
            throw new ConfigException("cannot load configuration", ex);
        }
    }

    public MathMLCanonicalizer addModule(Module module) {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (module instanceof StreamModule) {
            if (module instanceof DOMModule) {
                LOGGER.log(Level.INFO, "Module is stream and DOM module at the same time, it will be used as a stream module.");
            }
            this.streamModules.add((StreamModule)module);
        } else if (module instanceof DOMModule) {
            this.domModules.add((DOMModule)module);
        } else {
            throw new UnsupportedOperationException("Module type not supported");
        }
        return this;
    }

    public MathMLCanonicalizer addModule(String moduleName) {
        if (moduleName == null) {
            throw new NullPointerException("moduleName");
        }
        if (moduleName.isEmpty()) {
            throw new IllegalArgumentException("empty moduleName");
        }
        try {
            String fullyQualified = this.getClass().getPackage().getName() + ".modules." + moduleName;
            Class<?> moduleClass = Class.forName(fullyQualified);
            return this.addModule((Module)moduleClass.newInstance());
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, "cannot load module " + moduleName, ex);
        }
        catch (InstantiationException ex) {
            LOGGER.log(Level.WARNING, "cannot instantiate module " + moduleName, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.WARNING, "cannot access module " + moduleName, ex);
        }
        return this;
    }

    private void validateXMLConfiguration(InputStream xmlConfigurationStream) throws IOException, ConfigException {
        assert (xmlConfigurationStream != null);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = sf.newSchema(MathMLCanonicalizer.class.getResource(Settings.getProperty("configSchema")));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xmlConfigurationStream));
        }
        catch (SAXException ex) {
            throw new ConfigException("configuration not valid\n" + ex.getMessage(), ex);
        }
    }

    private void loadXMLConfiguration(InputStream xmlConfigurationStream) throws ConfigException, XMLStreamException {
        assert (xmlConfigurationStream != null);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(xmlConfigurationStream);
        boolean config = false;
        Module module = null;
        block8: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    String attributeValue;
                    String attributeName;
                    String name = reader.getLocalName();
                    if (name.equals("config")) {
                        config = true;
                        break;
                    }
                    if (config && name.equals("module") && reader.getAttributeCount() == 1) {
                        attributeName = reader.getAttributeLocalName(0);
                        attributeValue = reader.getAttributeValue(0);
                        if (attributeName.equals("name") && attributeValue != null) {
                            String fullyQualified = Settings.class.getPackage().getName() + ".modules." + attributeValue;
                            try {
                                Class<?> moduleClass = Class.forName(fullyQualified);
                                module = (Module)moduleClass.newInstance();
                            }
                            catch (InstantiationException ex) {
                                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                throw new ConfigException("cannot instantiate module " + attributeValue, ex);
                            }
                            catch (IllegalAccessException ex) {
                                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                throw new ConfigException("cannot access module " + attributeValue, ex);
                            }
                            catch (ClassNotFoundException ex) {
                                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                throw new ConfigException("cannot load module " + attributeValue, ex);
                            }
                        }
                    }
                    if (!config || !name.equals("property") || reader.getAttributeCount() != 1) break;
                    attributeName = reader.getAttributeLocalName(0);
                    attributeValue = reader.getAttributeValue(0);
                    if (!attributeName.equals("name") || attributeValue == null) continue block8;
                    if (module == null) {
                        if (Settings.isProperty(attributeValue)) {
                            Settings.setProperty(attributeValue, reader.getElementText());
                            break;
                        }
                        throw new ConfigException("configuration not valid\nTried to override non-existing global property " + attributeValue);
                    }
                    if (module.isProperty(attributeValue)) {
                        module.setProperty(attributeValue, reader.getElementText());
                        break;
                    }
                    throw new ConfigException("configuration not valid\nconfiguration tried to override non-existing property " + attributeValue);
                }
                case 2: {
                    if (config && reader.getLocalName().equals("module")) {
                        this.addModule(module);
                        module = null;
                    }
                    if (!config || !reader.getLocalName().equals("config")) break;
                    config = false;
                }
            }
        }
    }

    public void canonicalize(InputStream in, OutputStream out) throws JDOMException, IOException, ModuleException, XMLStreamException {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (out == null) {
            throw new NullPointerException("out");
        }
        InputStream inputStream = in;
        if (this.enforcingXHTMLPlusMathMLDTD) {
            inputStream = DTDManipulator.injectXHTMLPlusMathMLDTD(in);
        }
        ByteArrayOutputStream outputStream = null;
        for (StreamModule module : this.streamModules) {
            outputStream = module.execute(inputStream);
            if (outputStream == null) {
                throw new IOException("Module " + module + "returned null.");
            }
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        }
        if (this.enforcingXHTMLPlusMathMLDTD) {
            inputStream = DTDManipulator.removeDTD(inputStream);
        }
        if (this.domModules.isEmpty()) {
            if (this.streamModules.isEmpty()) {
                throw new IOException("There are no modules added.");
            }
            assert (outputStream != null);
            outputStream.writeTo(out);
            return;
        }
        SAXBuilder builder = Settings.setupSAXBuilder();
        Document document = builder.build(inputStream);
        for (DOMModule module : this.domModules) {
            module.execute(document);
        }
        XMLOutputter serializer = new XMLOutputter();
        serializer.output(document, out);
    }

    public boolean isEnforcingXHTMLPlusMathMLDTD() {
        return this.enforcingXHTMLPlusMathMLDTD;
    }

    public void setEnforcingXHTMLPlusMathMLDTD(boolean mode) {
        this.enforcingXHTMLPlusMathMLDTD = mode;
    }
}

