/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization;

import cz.muni.fi.mir.mathmlcanonicalization.ConfigException;
import cz.muni.fi.mir.mathmlcanonicalization.MathMLCanonicalizer;
import cz.muni.fi.mir.mathmlcanonicalization.modules.ModuleException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.jdom2.JDOMException;

public final class MathMLCanonicalizerCommandLineTool {
    private static final String JARFILE = "mathml-canonicalizer.jar";

    public static void main(String[] args) throws FileNotFoundException, XMLStreamException {
        Options options = new Options();
        options.addOption("c", true, "load configuration file");
        options.addOption("dtd", false, "enforce injection of XHTML + MathML 1.1 DTD reference into input documents");
        options.addOption("w", false, "overwrite input files by canonical outputs");
        options.addOption("h", false, "print help");
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            MathMLCanonicalizerCommandLineTool.printHelp(options);
            System.exit(1);
        }
        File config = null;
        boolean overwrite = false;
        boolean dtdInjectionMode = false;
        if (line != null) {
            List<String> arguments;
            if (line.hasOption('c')) {
                config = new File(args[1]);
            }
            if (line.hasOption("dtd")) {
                dtdInjectionMode = true;
            }
            if (line.hasOption('w')) {
                overwrite = true;
            }
            if (line.hasOption('h')) {
                MathMLCanonicalizerCommandLineTool.printHelp(options);
                System.exit(0);
            }
            if ((arguments = Arrays.asList(line.getArgs())).size() > 0) {
                for (String arg : arguments) {
                    try {
                        List<File> files = MathMLCanonicalizerCommandLineTool.getFiles(new File(arg));
                        for (File file : files) {
                            MathMLCanonicalizerCommandLineTool.canonicalize(file, config, dtdInjectionMode, overwrite);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MathMLCanonicalizerCommandLineTool.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (ConfigException ex) {
                        Logger.getLogger(MathMLCanonicalizerCommandLineTool.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (JDOMException ex) {
                        Logger.getLogger(MathMLCanonicalizerCommandLineTool.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (ModuleException ex) {
                        Logger.getLogger(MathMLCanonicalizerCommandLineTool.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            } else {
                MathMLCanonicalizerCommandLineTool.printHelp(options);
                System.exit(0);
            }
        }
    }

    private static void canonicalize(File file, File config, boolean dtdInjectionMode, boolean overwrite) throws ConfigException, FileNotFoundException, JDOMException, IOException, ModuleException, XMLStreamException {
        MathMLCanonicalizer mlcan;
        assert (file != null);
        if (config != null) {
            FileInputStream configInputStream = new FileInputStream(config);
            mlcan = new MathMLCanonicalizer(configInputStream);
        } else {
            mlcan = MathMLCanonicalizer.getDefaultCanonicalizer();
        }
        mlcan.setEnforcingXHTMLPlusMathMLDTD(dtdInjectionMode);
        if (overwrite) {
            Logger.getLogger(MathMLCanonicalizerCommandLineTool.class.getName()).log(Level.INFO, "overwriting the file {0}", file.getAbsolutePath());
            ByteArrayInputStream source = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file));
            mlcan.canonicalize(source, new FileOutputStream(file));
        } else {
            mlcan.canonicalize(new FileInputStream(file), System.out);
        }
    }

    private static List<File> getFiles(File file) throws IOException {
        assert (file != null);
        ArrayList<File> result = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    result.addAll(MathMLCanonicalizerCommandLineTool.getFiles(files[i]));
                }
            }
        } else {
            result.add(file);
        }
        return result;
    }

    private static void printHelp(Options options) {
        System.err.println("Usage: java -jar mathml-canonicalizer.jar [-c /path/to/config.xml] [-w] [-dtd] [/path/to/input.xhtml | /path/to/directory]...");
        System.err.println("Options:");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printOptions(new PrintWriter(System.err, true), 80, options, 8, 8);
    }
}

