/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Settings {
    private static final String PROPERTIES_FILENAME = "settings.properties";
    private static final String MATHMLDTD = "mathmldtd";
    private static final Properties PROPERTIES = new Properties();

    public static String getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String property = PROPERTIES.getProperty(key);
        if (property == null) {
            throw new IllegalArgumentException("Property '" + key + "' not set");
        }
        return property;
    }

    public static boolean isProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return PROPERTIES.getProperty(key) != null;
    }

    public static void setProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        PROPERTIES.put(key, value);
    }

    public static XMLInputFactory setupXMLInputFactory() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", true);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        inputFactory.setProperty("javax.xml.stream.supportDTD", true);
        inputFactory.setProperty("javax.xml.stream.resolver", new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) {
                if (systemID.endsWith("dtd")) {
                    String dtdLocation = Settings.getProperty(Settings.MATHMLDTD);
                    return Settings.class.getResourceAsStream(dtdLocation);
                }
                return null;
            }
        });
        return inputFactory;
    }

    public static SAXBuilder setupSAXBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", true);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId.endsWith("dtd")) {
                    String dtdLocation = Settings.getProperty(Settings.MATHMLDTD);
                    return new InputSource(Settings.class.getResourceAsStream(dtdLocation));
                }
                return null;
            }
        });
        return builder;
    }

    private Settings() {
        assert (false);
    }

    static {
        try {
            InputStream resourceAsStream = Settings.class.getResourceAsStream(PROPERTIES_FILENAME);
            if (resourceAsStream == null) {
                throw new IOException("cannot find the property file");
            }
            PROPERTIES.load(resourceAsStream);
            Logger.getLogger(Settings.class.getName()).log(Level.FINER, "canonicalizer properties loaded succesfully");
        }
        catch (IOException ex) {
            Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, "cannot load settings.properties", ex);
        }
    }
}

