/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization.modules;

import cz.muni.fi.mir.mathmlcanonicalization.modules.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

abstract class AbstractModule
implements Module {
    protected final Properties properties = new Properties();
    private static final Logger LOGGER = Logger.getLogger(AbstractModule.class.getName());
    protected static final String FENCED = "mfenced";
    protected static final String IDENTIFIER = "mi";
    protected static final String MATH = "math";
    protected static final String OPERATOR = "mo";
    protected static final String OVERSCRIPT = "mover";
    protected static final String ROW = "mrow";
    protected static final String SUBSCRIPT = "msub";
    protected static final String SUPERSCRIPT = "msup";
    protected static final String SUBSUP = "msubsup";
    protected static final String UNDEROVER = "munderover";
    protected static final String UNDERSCRIPT = "munder";

    AbstractModule() {
    }

    @Override
    public String getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String property = this.properties.getProperty(key);
        if (property == null) {
            throw new IllegalArgumentException("Property '" + key + "' not set");
        }
        return property;
    }

    @Override
    public boolean isProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.properties.getProperty(key) != null;
    }

    @Override
    public void setProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.properties.setProperty(key, value);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    protected boolean isEnabled(String key) {
        assert (key != null);
        if (this.properties.getProperty(key).equals("1") || this.properties.getProperty(key).equals("true")) {
            return true;
        }
        if (this.properties.getProperty(key).equals("0") || this.properties.getProperty(key).equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("'" + this.properties.getProperty(key) + "' is not a valid boolean value of " + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties(String propertiesFilename) {
        assert (propertiesFilename != null && !propertiesFilename.isEmpty());
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = this.getClass().getResourceAsStream(propertiesFilename);
            if (resourceAsStream == null) {
                throw new IOException("cannot find the property file");
            }
            this.properties.load(resourceAsStream);
            LOGGER.log(Level.FINE, "Module properties loaded succesfully from {0}", propertiesFilename);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Cannot load " + propertiesFilename, ex);
        }
        finally {
            try {
                if (resourceAsStream != null) {
                    resourceAsStream.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Cannot close property file stream", ex);
            }
        }
    }

    protected Set<String> getPropertySet(String property) {
        assert (property != null && !property.isEmpty());
        return new HashSet<String>(Arrays.asList(this.getProperty(property).split(" ")));
    }

    protected boolean isOperator(Element element, String operator) {
        return this.isOperator(element) && element.getTextTrim().equals(operator);
    }

    protected boolean isOperator(Element element) {
        assert (element != null);
        return element.getName().equals(OPERATOR);
    }

    protected void replaceElement(Element toReplace, String replacementName) {
        assert (toReplace != null && replacementName != null);
        assert (!replacementName.isEmpty());
        Element parent = toReplace.getParentElement();
        assert (parent != null);
        Element replacement = new Element(replacementName);
        replacement.addContent((Collection)toReplace.removeContent());
        List attributes = toReplace.getAttributes();
        for (Attribute attribute : attributes) {
            replacement.setAttribute(attribute.detach());
        }
        int parentIndex = parent.indexOf((Content)toReplace);
        parent.removeContent(parentIndex);
        parent.addContent(parentIndex, (Content)replacement);
        LOGGER.log(Level.FINE, "{0} replaced with {1}", new Object[]{toReplace, replacementName});
    }
}

