/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization.modules;

import cz.muni.fi.mir.mathmlcanonicalization.modules.AbstractModule;
import cz.muni.fi.mir.mathmlcanonicalization.modules.DOMModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class MfencedReplacer
extends AbstractModule
implements DOMModule {
    private static final String PROPERTIES_FILENAME = "MfencedReplacer.properties";
    private static final Logger LOGGER = Logger.getLogger(MfencedReplacer.class.getName());
    private static final String OPEN_FENCE = "open";
    private static final String CLOSE_FENCE = "close";
    private static final String SEPARATORS = "separators";
    private static final String DEFAULT_OPEN = "open";
    private static final String DEFAULT_CLOSE = "close";
    private static final String DEFAULT_SEPARATORS = "separators";
    private static final String FORCE_DEFAULT_OPEN = "forceopen";
    private static final String FORCE_DEFAULT_CLOSE = "forceclose";
    private static final String FORCE_DEFAULT_SEPARATORS = "forceseparators";
    private static final String ADD_OUTER_ROW = "outermrow";
    private static final String ADD_INNER_ROW = "innermrow";

    public MfencedReplacer() {
        this.loadProperties(PROPERTIES_FILENAME);
    }

    @Override
    public void execute(Document doc) {
        if (doc == null) {
            throw new NullPointerException("doc");
        }
        ArrayList<Element> toReplace = new ArrayList<Element>();
        for (Element mfenced : doc.getDescendants((Filter)new ElementFilter("mfenced"))) {
            toReplace.add(mfenced);
        }
        if (toReplace.isEmpty()) {
            LOGGER.fine("No mfenced elements found");
            return;
        }
        for (Element mfenced : toReplace) {
            this.replaceMfenced(mfenced);
        }
    }

    private void replaceMfenced(Element mfencedElement) {
        assert (mfencedElement != null);
        char[] separators = this.getSeparators(mfencedElement);
        Namespace ns = mfencedElement.getNamespace();
        List children = mfencedElement.getChildren();
        int nChildren = children.size();
        int last = Math.min(separators.length - 1, nChildren - 2);
        Element insideFence = null;
        if (nChildren == 1 && ((Element)children.get(0)).getName().equals("mrow")) {
            insideFence = ((Element)children.get(0)).detach();
        } else if (nChildren != 0) {
            insideFence = new Element("mrow", ns);
            for (int i = 0; i < nChildren; ++i) {
                if (i > 0 && last >= 0) {
                    char separatorChar = separators[i - 1 > last ? last : i - 1];
                    String separatorStr = Character.toString(separatorChar);
                    insideFence.addContent((Content)new Element("mo", ns).setText(separatorStr));
                }
                insideFence.addContent((Content)((Element)children.get(0)).detach());
            }
        }
        this.replaceMfenced(mfencedElement, insideFence);
    }

    private void replaceMfenced(Element mfencedElement, Element insideContent) {
        assert (mfencedElement != null);
        Namespace ns = mfencedElement.getNamespace();
        Element replacement = new Element("mrow", ns);
        String openStr = this.getProperty("open");
        String closeStr = this.getProperty("close");
        if (openStr.isEmpty() || closeStr.isEmpty()) {
            LOGGER.warning("Default open or close fence not set");
        }
        if (!this.isEnabled(FORCE_DEFAULT_OPEN)) {
            openStr = mfencedElement.getAttributeValue("open", openStr);
        }
        if (!this.isEnabled(FORCE_DEFAULT_CLOSE)) {
            closeStr = mfencedElement.getAttributeValue("close", closeStr);
        }
        replacement.addContent((Content)new Element("mo", ns).setText(openStr));
        if (insideContent != null) {
            if (this.isEnabled(ADD_INNER_ROW)) {
                replacement.addContent((Content)insideContent);
            } else {
                replacement.addContent((Collection)insideContent.removeContent());
            }
        }
        replacement.addContent((Content)new Element("mo", ns).setText(closeStr));
        Element parent = mfencedElement.getParentElement();
        int index = parent.indexOf((Content)mfencedElement);
        parent.removeContent(index);
        if (this.isEnabled(ADD_OUTER_ROW)) {
            parent.addContent(index, (Content)replacement);
        } else {
            parent.addContent(index, (Collection)replacement.removeContent());
        }
        LOGGER.fine("Mfenced element converted");
    }

    private char[] getSeparators(Element element) {
        assert (element != null);
        if (this.isEnabled(FORCE_DEFAULT_SEPARATORS)) {
            return this.getProperty("separators").toCharArray();
        }
        return element.getAttributeValue("separators", this.getProperty("separators")).trim().toCharArray();
    }
}

